/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RespUtils {
    private static final Logger log = LoggerFactory.getLogger(RespUtils.class);
    public static Namespace NS_DAV = Namespace.getNamespace((String)"D", (String)"DAV:");

    public static QName davName(String localName) {
        return new QName(NS_DAV.getURI(), localName, NS_DAV.getPrefix());
    }

    public static String asString(Element el, String name) {
        Element elChild = el.getChild(name, NS_DAV);
        if (elChild == null) {
            return null;
        }
        return elChild.getText();
    }

    public static String asString(Element el, String name, Namespace ns) {
        Element elChild = el.getChild(name, ns);
        if (elChild == null) {
            return null;
        }
        return elChild.getText();
    }

    public static Long asLong(Element el, String name) {
        String s = RespUtils.asString(el, name);
        if (s == null || s.length() == 0) {
            return null;
        }
        long l = Long.parseLong(s);
        return l;
    }

    public static Long asLong(Element el, String name, Namespace ns) {
        String s = RespUtils.asString(el, name, ns);
        if (s == null || s.length() == 0) {
            return null;
        }
        long l = Long.parseLong(s);
        return l;
    }

    public static boolean hasChild(Element el, String name) {
        if (el == null) {
            return false;
        }
        List<Element> list = RespUtils.getElements(el, name);
        return !list.isEmpty();
    }

    public static List<Element> getElements(Element root, String name) {
        ArrayList<Element> list = new ArrayList<Element>();
        Iterator it = root.getDescendants((Filter)new ElementFilter(name));
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Element)) continue;
            list.add((Element)o);
        }
        return list;
    }

    public static Document getJDomDocument(InputStream in) throws JDOMException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)bout);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            return builder.build((InputStream)bin);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

