/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import io.milton.http.DateUtils;
import io.milton.httpclient.RespUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom.Element;
import org.jdom.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropFindResponse {
    private static final Logger log = LoggerFactory.getLogger(PropFindResponse.class);
    private final String name;
    private final String href;
    private final boolean collection;
    private Map<QName, Object> properties = new HashMap<QName, Object>();

    public PropFindResponse(Date serverDate, Element elResponse) {
        String[] arr;
        this.href = RespUtils.asString(elResponse, "href").trim();
        this.name = this.href.contains("/") ? ((arr = this.href.split("[/]")).length > 0 ? arr[arr.length - 1] : "") : this.href;
        List<Element> propElements = this.getFoundProps(elResponse);
        Element colElement = null;
        for (Element oElProp : propElements) {
            if (!(oElProp instanceof Element)) continue;
            Element elProp = oElProp;
            String localName = elProp.getName();
            Namespace ns = elProp.getNamespace();
            QName qn = new QName(ns.getURI(), localName, ns.getPrefix());
            if (localName.equals("resourcetype")) {
                colElement = elProp.getChild("collection", RespUtils.NS_DAV);
                continue;
            }
            if (localName.equals("lockdiscovery")) {
                String token;
                String owner;
                Element elActiveLock = elProp.getChild("activelock", RespUtils.NS_DAV);
                if (elActiveLock != null) {
                    owner = RespUtils.asString(elActiveLock, "owner");
                    Element elToken = elActiveLock.getChild("locktoken", RespUtils.NS_DAV);
                    token = elToken != null ? RespUtils.asString(elToken, "href") : null;
                } else {
                    owner = null;
                    token = null;
                }
                LockDiscovery lock = new LockDiscovery(owner, token);
                this.properties.put(qn, lock);
                continue;
            }
            String value = elProp.getText();
            if (localName.equals("creationdate") || localName.equals("getlastmodified")) {
                try {
                    Date dt = DateUtils.parseWebDavDate((String)value);
                    if (serverDate != null) {
                        long delta = serverDate.getTime() - dt.getTime();
                        dt = new Date(System.currentTimeMillis() - delta);
                    }
                    this.properties.put(qn, dt);
                    QName qnRaw = new QName(ns.getURI(), localName + "-raw", ns.getPrefix());
                    this.properties.put(qnRaw, value);
                }
                catch (DateUtils.DateParseException e) {
                    log.warn("Couldnt parse date property: " + localName + " = " + value);
                }
                continue;
            }
            this.properties.put(qn, value);
        }
        this.collection = colElement != null;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public String getHref() {
        return this.href;
    }

    public LockDiscovery getLock() {
        return (LockDiscovery)this.getDavProperty("lockdiscovery");
    }

    public String getName() {
        return this.name;
    }

    public Map<QName, Object> getProperties() {
        return this.properties;
    }

    public Object getDavProperty(String name) {
        QName qn = RespUtils.davName(name);
        return this.properties.get(qn);
    }

    public String getDisplayName() {
        String dn = (String)this.getDavProperty("displayname");
        if (dn == null) {
            dn = this.name;
        }
        return dn;
    }

    public Date getCreatedDate() {
        return (Date)this.getDavProperty("creationdate");
    }

    public Date getModifiedDate() {
        return (Date)this.getDavProperty("getlastmodified");
    }

    public String getEtag() {
        return (String)this.getDavProperty("getetag");
    }

    public String getContentType() {
        return (String)this.getDavProperty("getcontenttype");
    }

    public Long getContentLength() {
        String s = (String)this.getDavProperty("getcontentlength");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return Long.parseLong(s);
    }

    public Long getQuotaAvailableBytes() {
        String s = (String)this.getDavProperty("quota-available-bytes");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return Long.parseLong(s);
    }

    public Long getQuotaUsedBytes() {
        String s = (String)this.getDavProperty("quota-used-bytes");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return Long.parseLong(s);
    }

    private List<Element> getFoundProps(Element elResponse) {
        for (Object olPropStat : elResponse.getChildren()) {
            Element elProps;
            String st;
            Element elStatus;
            Element propStat;
            if (!(olPropStat instanceof Element) || !(propStat = (Element)olPropStat).getName().equals("propstat") || (elStatus = propStat.getChild("status", RespUtils.NS_DAV)) == null || (st = elStatus.getText()) == null || !st.contains("200") || (elProps = propStat.getChild("prop", RespUtils.NS_DAV)) == null) continue;
            ArrayList<Element> list = new ArrayList<Element>();
            for (Object oProp : elProps.getChildren()) {
                if (!(oProp instanceof Element)) continue;
                Element elProp = (Element)oProp;
                list.add(elProp);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public static class LockDiscovery {
        private String owner;
        private String token;

        public LockDiscovery(String owner, String token) {
            this.owner = owner;
            this.token = token;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getToken() {
            return this.token;
        }
    }
}

