/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient;

import io.milton.httpclient.ProgressListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class NotifyingFileInputStream
extends InputStream {
    private InputStream fin;
    private final InputStream wrapped;
    private final ProgressListener listener;
    private final String fileName;
    private long pos;
    private Long totalLength;
    private long timeLastNotify;
    private long bytesSinceLastNotify;

    public NotifyingFileInputStream(File f, ProgressListener listener) throws FileNotFoundException, IOException {
        this.fin = FileUtils.openInputStream((File)f);
        this.wrapped = new BufferedInputStream(this.fin);
        this.listener = listener;
        this.totalLength = f.length();
        this.fileName = f.getAbsolutePath();
        this.timeLastNotify = System.currentTimeMillis();
    }

    public NotifyingFileInputStream(InputStream in, Long length, String path, ProgressListener listener) throws IOException {
        this.fin = in;
        this.wrapped = new BufferedInputStream(this.fin);
        this.listener = listener;
        this.totalLength = length;
        this.fileName = path;
        this.timeLastNotify = System.currentTimeMillis();
    }

    @Override
    public int read() throws IOException {
        this.increment(1);
        return this.wrapped.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.increment(b.length);
        return this.wrapped.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.increment(len);
        return this.wrapped.read(b, off, len);
    }

    private void increment(int len) {
        this.pos += (long)len;
        this.notifyListener(len);
    }

    void notifyListener(int numBytes) {
        if (this.listener == null) {
            return;
        }
        this.listener.onRead(numBytes);
        this.bytesSinceLastNotify += (long)numBytes;
        if (this.bytesSinceLastNotify < 1000L) {
            return;
        }
        int timeDiff = (int)(System.currentTimeMillis() - this.timeLastNotify);
        if (timeDiff > 10) {
            this.timeLastNotify = System.currentTimeMillis();
            this.listener.onProgress(this.pos, this.totalLength, this.fileName);
            this.bytesSinceLastNotify = 0L;
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((InputStream)this.wrapped);
        IOUtils.closeQuietly((InputStream)this.fin);
        super.close();
    }
}

