/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.ext;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

public class MouseScrollableUI
extends AbstractLayerUI<JScrollPane>
implements ActionListener {
    private JXLayer<? extends JScrollPane> currentLayer;
    private Point scrollOrigin;
    private Point mousePoint;
    private Timer timer;
    private JLabel indicator;
    private Icon crissCrossIcon;
    private Icon horizontalIcon;
    private Icon verticalIcon;
    private Map<Icon, Cursor> cursorMap;
    private final MouseListener emptyMouseListener = new MouseAdapter(){};
    private ComponentListener componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            JXLayer jXLayer = (JXLayer)componentEvent.getComponent();
            if (MouseScrollableUI.this.indicator.isShowing() && jXLayer == MouseScrollableUI.this.currentLayer) {
                MouseScrollableUI.this.deactivateMouseScrolling(jXLayer);
            }
        }
    };

    public MouseScrollableUI() {
        this.timer = new Timer(20, this);
        this.cursorMap = new HashMap<Icon, Cursor>();
        this.crissCrossIcon = new ImageIcon(this.getClass().getResource("images/criss-cross.png"));
        this.cursorMap.put(this.crissCrossIcon, Cursor.getPredefinedCursor(13));
        this.horizontalIcon = new ImageIcon(this.getClass().getResource("images/horizontal.png"));
        this.cursorMap.put(this.horizontalIcon, Cursor.getPredefinedCursor(11));
        this.verticalIcon = new ImageIcon(this.getClass().getResource("images/vertical.png"));
        this.cursorMap.put(this.verticalIcon, Cursor.getPredefinedCursor(8));
        this.indicator = new JLabel(this.crissCrossIcon);
        this.indicator.addMouseListener(this.emptyMouseListener);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.addComponentListener(this.componentListener);
        JXLayer jXLayer = (JXLayer)jComponent;
        jXLayer.getGlassPane().setLayout(null);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.removeComponentListener(this.componentListener);
        JXLayer jXLayer = (JXLayer)jComponent;
        jXLayer.getGlassPane().setLayout(new FlowLayout());
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent, JXLayer<? extends JScrollPane> jXLayer) {
        super.processMouseEvent(mouseEvent, jXLayer);
        Icon icon = this.getIconForIndicator(jXLayer);
        if (this.isMouseScrollingTrigger(mouseEvent) && icon != null) {
            this.currentLayer = jXLayer;
            this.scrollOrigin = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.currentLayer);
            this.activateMouseScrolling(this.scrollOrigin, this.currentLayer, icon);
            this.mousePoint = this.scrollOrigin;
            mouseEvent.consume();
        }
    }

    protected boolean isMouseScrollingTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 501 && mouseEvent.getButton() == 2 && !mouseEvent.isPopupTrigger();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent, JXLayer<? extends JScrollPane> jXLayer) {
        super.processMouseMotionEvent(mouseEvent, jXLayer);
        if (this.indicator.isShowing()) {
            this.mousePoint = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.currentLayer);
            this.updateViewPosition(this.scrollOrigin, this.mousePoint, this.currentLayer);
        }
    }

    private void updateViewPosition(Point point, Point point2, JXLayer<? extends JScrollPane> jXLayer) {
        JViewport jViewport = jXLayer.getView().getViewport();
        Point point3 = SwingUtilities.convertPoint(jXLayer, point2, this.indicator);
        if (!this.indicator.contains(point3)) {
            Point point4 = jViewport.getViewPosition();
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            point4.x += n / 5;
            point4.y += n2 / 5;
            if (point4.x > jViewport.getView().getWidth() - jViewport.getWidth()) {
                point4.x = jViewport.getView().getWidth() - jViewport.getWidth();
            }
            if (point4.x < 0) {
                point4.x = 0;
            }
            if (point4.y > jViewport.getView().getHeight() - jViewport.getHeight()) {
                point4.y = jViewport.getView().getHeight() - jViewport.getHeight();
            }
            if (point4.y < 0) {
                point4.y = 0;
            }
            jViewport.setViewPosition(point4);
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent, JXLayer<? extends JScrollPane> jXLayer) {
        if (this.indicator.isShowing()) {
            InputEvent inputEvent;
            if (aWTEvent instanceof MouseEvent && (inputEvent = (MouseEvent)aWTEvent).getID() != 507 && inputEvent.getID() != 501 && (inputEvent.getID() != 502 && inputEvent.getID() != 500 || this.scrollOrigin.equals(this.mousePoint))) {
                super.eventDispatched(aWTEvent, jXLayer);
                return;
            }
            this.deactivateMouseScrolling(this.currentLayer);
            if (aWTEvent instanceof InputEvent) {
                inputEvent = (InputEvent)aWTEvent;
                inputEvent.consume();
            }
        } else {
            super.eventDispatched(aWTEvent, jXLayer);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateViewPosition(this.scrollOrigin, this.mousePoint, this.currentLayer);
    }

    private void activateMouseScrolling(Point point, JXLayer<? extends JScrollPane> jXLayer, Icon icon) {
        jXLayer.getGlassPane().addMouseListener(this.emptyMouseListener);
        jXLayer.getGlassPane().add(this.indicator);
        Dimension dimension = this.indicator.getPreferredSize();
        this.indicator.setBounds(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
        this.indicator.setIcon(icon);
        this.indicator.setCursor(this.cursorMap.get(icon));
        jXLayer.getGlassPane().repaint();
        this.timer.start();
    }

    private Icon getIconForIndicator(JXLayer<? extends JScrollPane> jXLayer) {
        JViewport jViewport = jXLayer.getView().getViewport();
        Dimension dimension = jViewport.getExtentSize();
        Icon icon = null;
        if (dimension.width >= jViewport.getView().getWidth() && dimension.height >= jViewport.getView().getHeight() || dimension.width < jViewport.getView().getWidth() && dimension.height < jViewport.getView().getHeight()) {
            icon = this.crissCrossIcon;
        } else if (dimension.width < jViewport.getView().getWidth()) {
            icon = this.horizontalIcon;
        } else if (dimension.height < jViewport.getView().getHeight()) {
            icon = this.verticalIcon;
        }
        return icon;
    }

    private void deactivateMouseScrolling(JXLayer<? extends JScrollPane> jXLayer) {
        jXLayer.getGlassPane().removeMouseListener(this.emptyMouseListener);
        this.indicator.setCursor(null);
        jXLayer.getGlassPane().remove(this.indicator);
        jXLayer.getGlassPane().repaint();
        this.timer.stop();
    }
}

