/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.ext;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractBufferedLayerUI;
import org.jdesktop.jxlayer.plaf.effect.LayerEffect;

public class LockableUI
extends AbstractBufferedLayerUI<JComponent> {
    private boolean isLocked;
    private Component recentFocusOwner;
    private Cursor lockedCursor = Cursor.getPredefinedCursor(3);
    private LayerEffect[] lockedEffects = new LayerEffect[0];
    private final FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getOppositeComponent() != null) {
                LockableUI.this.setDirty(true);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    };

    public LockableUI() {
        this(null);
    }

    public LockableUI(LayerEffect ... layerEffectArray) {
        this.setLockedEffects(layerEffectArray);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.addFocusListener(this.focusListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.removeFocusListener(this.focusListener);
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean bl) {
        if (bl != this.isLocked()) {
            if (this.getLayer() != null) {
                boolean bl2;
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component component = keyboardFocusManager.getPermanentFocusOwner();
                boolean bl3 = bl2 = component != null && SwingUtilities.isDescendingFrom(component, this.getLayer());
                if (bl) {
                    if (bl2 && keyboardFocusManager.getFocusedWindow() == SwingUtilities.getWindowAncestor(this.getLayer())) {
                        this.recentFocusOwner = component;
                        this.getLayer().requestFocusInWindow();
                    } else {
                        this.setDirty(true);
                    }
                    this.getLayer().getGlassPane().setCursor(this.getLockedCursor());
                } else {
                    ((JComponent)this.getLayer().getView()).setVisible(true);
                    if (bl2 && this.recentFocusOwner != null) {
                        this.recentFocusOwner.requestFocusInWindow();
                    }
                    this.recentFocusOwner = null;
                    this.getLayer().getGlassPane().setCursor(null);
                }
            }
            this.isLocked = bl;
            this.firePropertyChange("locked", !bl, bl);
        }
    }

    @Override
    protected boolean isIncrementalUpdate(JXLayer<? extends JComponent> jXLayer) {
        return !this.isLocked();
    }

    @Override
    protected void paintLayer(Graphics2D graphics2D, JXLayer<? extends JComponent> jXLayer) {
        if (this.isLocked()) {
            jXLayer.getView().setVisible(true);
            jXLayer.paint(graphics2D);
            jXLayer.getView().setVisible(false);
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        jComponent.paint(graphics);
    }

    public Cursor getLockedCursor() {
        return this.lockedCursor;
    }

    public void setLockedCursor(Cursor cursor) {
        Cursor cursor2 = this.getLockedCursor();
        this.lockedCursor = cursor;
        this.firePropertyChange("lockedCursor", cursor2, cursor);
        if (this.isLocked()) {
            this.getLayer().getGlassPane().setCursor(cursor);
        }
    }

    public LayerEffect[] getLockedEffects() {
        LayerEffect[] layerEffectArray = new LayerEffect[this.lockedEffects.length];
        System.arraycopy(this.lockedEffects, 0, layerEffectArray, 0, layerEffectArray.length);
        return layerEffectArray;
    }

    protected LayerEffect[] getLockedEffects(JXLayer<? extends JComponent> jXLayer) {
        return this.getLockedEffects();
    }

    public void setLockedEffects(LayerEffect ... layerEffectArray) {
        LayerEffect[] layerEffectArray2 = this.getLockedEffects();
        if (layerEffectArray == null) {
            layerEffectArray = new LayerEffect[]{};
        }
        for (LayerEffect layerEffect : this.getLockedEffects()) {
            layerEffect.removePropertyChangeListener(this);
        }
        this.lockedEffects = new LayerEffect[layerEffectArray.length];
        System.arraycopy(layerEffectArray, 0, this.lockedEffects, 0, layerEffectArray.length);
        for (LayerEffect layerEffect : layerEffectArray) {
            layerEffect.addPropertyChangeListener(this);
        }
        this.firePropertyChange("lockedEffects", layerEffectArray2, layerEffectArray);
    }

    @Override
    protected LayerEffect[] getLayerEffects(JXLayer<? extends JComponent> jXLayer) {
        if (this.isLocked()) {
            return this.getLockedEffects(jXLayer);
        }
        return super.getLayerEffects(jXLayer);
    }
}

