/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.ext;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

public class ButtonPanelUI
extends AbstractLayerUI<JComponent> {
    private boolean isFocusCyclic;

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setFocusTraversalPolicyProvider(true);
        jComponent.setFocusTraversalPolicy(new ButtonPanelFocusTraversalPolicy());
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setFocusTraversalPolicyProvider(false);
        jComponent.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    public ButtonPanelUI() {
        this(false);
    }

    public ButtonPanelUI(boolean bl) {
        this.isFocusCyclic = bl;
    }

    public boolean isFocusCyclic() {
        return this.isFocusCyclic;
    }

    public void setFocusCyclic(boolean bl) {
        this.isFocusCyclic = bl;
    }

    private ButtonGroup getButtonGroup(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel instanceof DefaultButtonModel) {
            return ((DefaultButtonModel)buttonModel).getGroup();
        }
        return null;
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent, JXLayer<? extends JComponent> jXLayer) {
        super.processKeyEvent(keyEvent, jXLayer);
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 39: 
                case 40: {
                    this.moveFocus(true, jXLayer);
                    break;
                }
                case 37: 
                case 38: {
                    this.moveFocus(false, jXLayer);
                }
            }
        }
    }

    private void moveFocus(boolean bl, JXLayer<? extends JComponent> jXLayer) {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        ButtonPanelFocusTraversalPolicy buttonPanelFocusTraversalPolicy = (ButtonPanelFocusTraversalPolicy)jXLayer.getFocusTraversalPolicy();
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            buttonPanelFocusTraversalPolicy.setAlternativeFocusMode(true);
            Component component2 = bl ? buttonPanelFocusTraversalPolicy.getComponentAfter(jXLayer, component) : buttonPanelFocusTraversalPolicy.getComponentBefore(jXLayer, component);
            buttonPanelFocusTraversalPolicy.setAlternativeFocusMode(false);
            abstractButton.getModel().setPressed(false);
            if (component2 instanceof AbstractButton) {
                AbstractButton abstractButton2;
                ButtonGroup buttonGroup = this.getButtonGroup((AbstractButton)component);
                if (buttonGroup != this.getButtonGroup(abstractButton2 = (AbstractButton)component2)) {
                    return;
                }
                if (buttonGroup != null && buttonGroup.getSelection() != null && !abstractButton2.isSelected()) {
                    abstractButton2.setSelected(true);
                }
                component2.requestFocusInWindow();
            }
        }
    }

    private class ButtonPanelFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private boolean isAlternativeFocusMode;

        private ButtonPanelFocusTraversalPolicy() {
        }

        public boolean isAlternativeFocusMode() {
            return this.isAlternativeFocusMode;
        }

        public void setAlternativeFocusMode(boolean bl) {
            this.isAlternativeFocusMode = bl;
        }

        @Override
        protected boolean accept(Component component) {
            AbstractButton abstractButton;
            ButtonGroup buttonGroup;
            if (!this.isAlternativeFocusMode() && component instanceof AbstractButton && (buttonGroup = ButtonPanelUI.this.getButtonGroup(abstractButton = (AbstractButton)component)) != null && buttonGroup.getSelection() != null && !abstractButton.isSelected()) {
                return false;
            }
            return super.accept(component);
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            Component component2 = super.getComponentAfter(container, component);
            if (!this.isAlternativeFocusMode()) {
                return component2;
            }
            if (ButtonPanelUI.this.isFocusCyclic()) {
                return component2 == null ? this.getFirstComponent(container) : component2;
            }
            if (component == this.getLastComponent(container)) {
                return component;
            }
            return component2;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            Component component2 = super.getComponentBefore(container, component);
            if (!this.isAlternativeFocusMode()) {
                return component2;
            }
            if (ButtonPanelUI.this.isFocusCyclic()) {
                return component2 == null ? this.getLastComponent(container) : component2;
            }
            if (component == this.getFirstComponent(container)) {
                return component;
            }
            return component2;
        }
    }
}

