/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.jxlayer.JXLayer;

public abstract class LayerUI<V extends Component>
extends ComponentUI
implements Serializable {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        jComponent.paint(graphics);
    }

    public void eventDispatched(AWTEvent aWTEvent, JXLayer<? extends V> jXLayer) {
    }

    public void updateUI(JXLayer<? extends V> jXLayer) {
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.addPropertyChangeListener((JXLayer)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.removePropertyChangeListener((JXLayer)jComponent);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.propertyChangeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent, JXLayer<? extends V> jXLayer) {
    }

    public Dimension getPreferredScrollableViewportSize(JXLayer<? extends V> jXLayer) {
        if (jXLayer.getView() instanceof Scrollable) {
            return ((Scrollable)jXLayer.getView()).getPreferredScrollableViewportSize();
        }
        return jXLayer.getPreferredSize();
    }

    public int getScrollableBlockIncrement(JXLayer<? extends V> jXLayer, Rectangle rectangle, int n, int n2) {
        if (jXLayer.getView() instanceof Scrollable) {
            return ((Scrollable)jXLayer.getView()).getScrollableBlockIncrement(rectangle, n, n2);
        }
        return n == 1 ? rectangle.height : rectangle.width;
    }

    public boolean getScrollableTracksViewportHeight(JXLayer<? extends V> jXLayer) {
        if (jXLayer.getView() instanceof Scrollable) {
            return ((Scrollable)jXLayer.getView()).getScrollableTracksViewportHeight();
        }
        if (jXLayer.getParent() instanceof JViewport) {
            return ((JViewport)jXLayer.getParent()).getHeight() > jXLayer.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth(JXLayer<? extends V> jXLayer) {
        if (jXLayer.getView() instanceof Scrollable) {
            return ((Scrollable)jXLayer.getView()).getScrollableTracksViewportWidth();
        }
        if (jXLayer.getParent() instanceof JViewport) {
            return ((JViewport)jXLayer.getParent()).getWidth() > jXLayer.getPreferredSize().width;
        }
        return false;
    }

    public int getScrollableUnitIncrement(JXLayer<? extends V> jXLayer, Rectangle rectangle, int n, int n2) {
        if (jXLayer.getView() instanceof Scrollable) {
            return ((Scrollable)jXLayer.getView()).getScrollableUnitIncrement(rectangle, n, n2);
        }
        return 1;
    }
}

