/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf;

import java.awt.AWTEvent;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class AbstractLayerUI<V extends JComponent>
extends LayerUI<V> {
    private static final Map<RenderingHints.Key, Object> emptyRenderingHintMap = Collections.unmodifiableMap(new HashMap(0));
    private boolean isDirty;

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        ((JXLayer)jComponent).setLayerEventMask(this.getLayerEventMask());
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        ((JXLayer)jComponent).setLayerEventMask(0L);
    }

    @Override
    public void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent, JXLayer<? extends V> jXLayer) {
        if (!"dirty".equals(propertyChangeEvent.getPropertyName()) || propertyChangeEvent.getNewValue() == Boolean.TRUE) {
            jXLayer.repaint();
        }
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty(boolean bl) {
        boolean bl2 = this.isDirty;
        this.isDirty = bl;
        this.firePropertyChange("dirty", bl2, bl);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            JXLayer jXLayer = (JXLayer)jComponent;
            this.configureGraphics(graphics2D, jXLayer);
            this.paintLayer(graphics2D, jXLayer);
            graphics2D.dispose();
            this.setDirty(false);
        }
    }

    protected void paintLayer(Graphics2D graphics2D, JXLayer<? extends V> jXLayer) {
        jXLayer.paint(graphics2D);
    }

    protected void configureGraphics(Graphics2D graphics2D, JXLayer<? extends V> jXLayer) {
        Map<RenderingHints.Key, Object> map;
        AffineTransform affineTransform;
        Shape shape;
        Composite composite = this.getComposite(jXLayer);
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
        if ((shape = this.getClip(jXLayer)) != null) {
            graphics2D.clip(shape);
        }
        if ((affineTransform = this.getTransform(jXLayer)) != null) {
            graphics2D.transform(affineTransform);
        }
        if ((map = this.getRenderingHints(jXLayer)) != null) {
            for (RenderingHints.Key key : map.keySet()) {
                Object object = map.get(key);
                if (object == null) continue;
                graphics2D.setRenderingHint(key, map.get(key));
            }
        }
    }

    protected Composite getComposite(JXLayer<? extends V> jXLayer) {
        return null;
    }

    protected AffineTransform getTransform(JXLayer<? extends V> jXLayer) {
        return null;
    }

    protected Shape getClip(JXLayer<? extends V> jXLayer) {
        return null;
    }

    protected Map<RenderingHints.Key, Object> getRenderingHints(JXLayer<? extends V> jXLayer) {
        return emptyRenderingHintMap;
    }

    public long getLayerEventMask() {
        return 131132L;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent, JXLayer<? extends V> jXLayer) {
        if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent, jXLayer);
        } else if (aWTEvent instanceof MouseEvent) {
            switch (aWTEvent.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)aWTEvent, jXLayer);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)aWTEvent, jXLayer);
                    break;
                }
                case 507: {
                    this.processMouseWheelEvent((MouseWheelEvent)aWTEvent, jXLayer);
                }
            }
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent, jXLayer);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent, JXLayer<? extends V> jXLayer) {
    }

    protected void processMouseEvent(MouseEvent mouseEvent, JXLayer<? extends V> jXLayer) {
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent, JXLayer<? extends V> jXLayer) {
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent, JXLayer<? extends V> jXLayer) {
    }

    protected void processKeyEvent(KeyEvent keyEvent, JXLayer<? extends V> jXLayer) {
    }
}

