/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jdesktop.jxlayer.plaf.effect.LayerEffect;

public class AbstractBufferedLayerUI<V extends JComponent>
extends AbstractLayerUI<V>
implements PropertyChangeListener {
    private JXLayer<? extends V> layer;
    private transient SoftReference<BufferedImage> cachedBuffer;
    private static final LayerEffect[] emptyEffectArray = new LayerEffect[0];

    @Override
    public void installUI(JComponent jComponent) {
        if (this.layer != null) {
            throw new IllegalStateException("BufferedLayerUI can't be shared between multiple layers");
        }
        this.layer = (JXLayer)jComponent;
        jComponent.addPropertyChangeListener(this);
        super.installUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.removePropertyChangeListener(this);
        this.layer = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() != this.getLayer() || "view".equals(string)) {
            this.setDirty(true);
        }
    }

    @Override
    public void updateUI(JXLayer<? extends V> jXLayer) {
        this.setDirty(true);
    }

    public JXLayer<? extends V> getLayer() {
        return this.layer;
    }

    protected BufferedImage getBuffer() {
        return this.cachedBuffer == null ? null : this.cachedBuffer.get();
    }

    protected void setBuffer(BufferedImage bufferedImage) {
        this.cachedBuffer = new SoftReference<BufferedImage>(bufferedImage);
    }

    protected LayerEffect[] getLayerEffects(JXLayer<? extends V> jXLayer) {
        return emptyEffectArray;
    }

    protected boolean isIncrementalUpdate(JXLayer<? extends V> jXLayer) {
        return true;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            JXLayer jXLayer = (JXLayer)jComponent;
            this.configureGraphics(graphics2D, jXLayer);
            Shape shape = graphics2D.getClip();
            BufferedImage bufferedImage = this.getBuffer();
            boolean bl = this.isBufferFormatValid(jXLayer);
            if (!bl || !this.isBufferContentValid(jXLayer, shape)) {
                if (!bl) {
                    bufferedImage = this.createBuffer(jXLayer.getWidth(), jXLayer.getHeight());
                    this.setBuffer(bufferedImage);
                }
                Graphics2D graphics2D2 = bufferedImage.createGraphics();
                if (this.isIncrementalUpdate(jXLayer)) {
                    graphics2D2.setClip(shape);
                }
                this.paintLayer(graphics2D2, jXLayer);
                this.applyLayerEffects(jXLayer, graphics2D2.getClip());
                graphics2D2.dispose();
            }
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            this.setDirty(false);
        }
    }

    protected boolean isBufferFormatValid(JXLayer<? extends V> jXLayer) {
        BufferedImage bufferedImage = this.getBuffer();
        return bufferedImage != null && bufferedImage.getWidth() == jXLayer.getWidth() && bufferedImage.getHeight() == jXLayer.getHeight();
    }

    protected boolean isBufferContentValid(JXLayer<? extends V> jXLayer, Shape shape) {
        return !this.isDirty() && !this.isIncrementalUpdate(jXLayer);
    }

    protected BufferedImage createBuffer(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    protected void applyLayerEffects(JXLayer<? extends V> jXLayer, Shape shape) {
        if (this.getBuffer() == null) {
            throw new IllegalStateException("Buffer is null");
        }
        for (LayerEffect layerEffect : this.getLayerEffects(jXLayer)) {
            if (!layerEffect.isEnabled()) continue;
            layerEffect.apply(this.getBuffer(), shape);
        }
    }
}

