/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CSVRecord
implements Serializable,
Iterable<String> {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final Map<String, Integer> mapping;
    private final long recordNumber;
    private final String[] values;

    CSVRecord(String[] values, Map<String, Integer> mapping, String comment, long recordNumber) {
        this.recordNumber = recordNumber;
        this.values = values != null ? values : EMPTY_STRING_ARRAY;
        this.mapping = mapping;
        this.comment = comment;
    }

    public String get(Enum<?> e) {
        return this.get(e.toString());
    }

    public String get(int i) {
        return this.values[i];
    }

    public String get(String name) {
        if (this.mapping == null) {
            throw new IllegalStateException("No header mapping was specified, the record values can't be accessed by name");
        }
        Integer index = this.mapping.get(name);
        if (index == null) {
            throw new IllegalArgumentException(String.format("Mapping for %s not found, expected one of %s", name, this.mapping.keySet()));
        }
        try {
            return this.values[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("Index for header '%s' is %d but CSVRecord only has %d values!", name, index, this.values.length));
        }
    }

    public String getComment() {
        return this.comment;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public boolean isConsistent() {
        return this.mapping == null || this.mapping.size() == this.values.length;
    }

    public boolean isMapped(String name) {
        return this.mapping != null && this.mapping.containsKey(name);
    }

    public boolean isSet(String name) {
        return this.isMapped(name) && this.mapping.get(name) < this.values.length;
    }

    @Override
    public Iterator<String> iterator() {
        return this.toList().iterator();
    }

    <M extends Map<String, String>> M putIn(M map) {
        if (this.mapping == null) {
            return map;
        }
        for (Map.Entry<String, Integer> entry : this.mapping.entrySet()) {
            int col = entry.getValue();
            if (col >= this.values.length) continue;
            map.put((String)entry.getKey(), (String)this.values[col]);
        }
        return map;
    }

    public int size() {
        return this.values.length;
    }

    private List<String> toList() {
        return Arrays.asList(this.values);
    }

    public Map<String, String> toMap() {
        return this.putIn(new HashMap(this.values.length));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CSVRecord [comment=").append(this.comment);
        sb.append(", mapping=").append(this.mapping);
        sb.append(", recordNumber=").append(this.recordNumber);
        sb.append(", values=").append(Arrays.toString(this.values)).append(']');
        return sb.toString();
    }

    String[] values() {
        return this.values;
    }
}

