/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.math.BigInteger;

public final class NumberUtility {
    public static final Double DOUBLE_ZERO = 0.0;

    public static final int getInt(Number value) {
        return value == null ? 0 : value.intValue();
    }

    public static final int getInt(String value) {
        return value == null || value.length() == 0 ? 0 : Integer.parseInt(value);
    }

    public static final Integer getInteger(Number value) {
        Integer result = null;
        if (value != null) {
            result = value instanceof Integer ? (Integer)value : Integer.valueOf((int)Math.round(value.doubleValue()));
        }
        return result;
    }

    public static final Integer getInteger(String value) {
        Integer result;
        try {
            result = Integer.parseInt(value);
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    public static final BigInteger getBigInteger(Number value) {
        BigInteger result = null;
        if (value != null) {
            result = value instanceof BigInteger ? (BigInteger)value : BigInteger.valueOf(Math.round(value.doubleValue()));
        }
        return result;
    }

    public static final double getDouble(Number value) {
        return value == null ? 0.0 : value.doubleValue();
    }

    public static final Double getDouble(double value) {
        return value == 0.0 ? DOUBLE_ZERO : Double.valueOf(value);
    }

    public static final double truncate(double value, double precision) {
        precision = Math.pow(10.0, precision);
        double result = value > 0.0 ? Math.floor(value * precision) / precision : Math.ceil(value * precision) / precision;
        return result;
    }

    public static final Integer parseInteger(String value) {
        return value == null || value.length() == 0 ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public static boolean equals(Number lhs, Number rhs) {
        boolean result = false;
        if (lhs == null && rhs == null) {
            result = true;
        } else if (lhs != null && rhs != null) {
            result = lhs.equals(rhs);
        }
        return result;
    }

    public static boolean equals(double lhs, double rhs, double delta) {
        return Math.abs(lhs - rhs) < delta;
    }
}

