/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.primavera.Record;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.TaskCosts;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.DateUtility;

final class PrimaveraReader {
    private ProjectFile m_project;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private Map<Integer, ProjectCalendar> m_calMap = new HashMap<Integer, ProjectCalendar>();
    private DateFormat m_calendarTimeFormat = new SimpleDateFormat("HH:mm");
    private Map<Integer, String> m_udfMap = new HashMap<Integer, String>();
    private final UserFieldCounters m_udfCounters;
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, TaskType> TASK_TYPE_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;
    private static final Map<String, CurrencySymbolPosition> CURRENCY_SYMBOL_POSITION_MAP;

    public PrimaveraReader(UserFieldCounters udfCounters) {
        this.m_project = new ProjectFile();
        this.m_project.setAutoTaskUniqueID(false);
        this.m_project.setAutoResourceUniqueID(false);
        this.m_project.setAutoCalendarUniqueID(true);
        this.m_project.setAutoAssignmentUniqueID(false);
        this.m_project.setAutoWBS(false);
        this.m_project.setTaskFieldAlias(TaskField.DATE1, "Suspend Date");
        this.m_project.setTaskFieldAlias(TaskField.DATE2, "Resume Date");
        this.m_udfCounters = udfCounters;
        this.m_udfCounters.reset();
        this.addUserDefinedField(UserFieldDataType.FT_TEXT, "Code");
        this.addUserDefinedField(UserFieldDataType.FT_INT, "Parent Resource Unique ID");
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public void processProjectHeader(List<Row> rows) {
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            ProjectHeader header = this.m_project.getProjectHeader();
            header.setCreationDate(row.getDate("create_date"));
            header.setFinishDate(row.getDate("plan_end_date"));
            header.setName(row.getString("proj_short_name"));
            header.setStartDate(row.getDate("plan_start_date"));
            header.setProjectTitle(row.getString("proj_short_name"));
            header.setDefaultTaskType(TASK_TYPE_MAP.get(row.getString("def_duration_type")));
            header.setStatusDate(row.getDate("last_recalc_date"));
        }
    }

    public void processUserDefinedFields(List<Row> userDefinedFields) {
        for (Row row : userDefinedFields) {
            if (!"TASK".equals(row.getString("table_name"))) continue;
            this.parseTaskUDF(row);
        }
    }

    public void processCalendars(List<Row> rows) {
        for (Row row : rows) {
            ProjectCalendar calendar = this.m_project.addCalendar();
            Integer id = row.getInteger("clndr_id");
            this.m_calMap.put(id, calendar);
            calendar.setName(row.getString("clndr_name"));
            String calendarData = row.getString("clndr_data");
            if (calendarData != null && !calendarData.isEmpty()) {
                Record exceptions;
                Record root = new Record(calendarData);
                Record daysOfWeek = root.getChild("DaysOfWeek");
                if (daysOfWeek != null) {
                    for (Record recDay : daysOfWeek.getChildren()) {
                        Day day = Day.getInstance(Integer.parseInt(recDay.getField()));
                        List<Record> recHours = recDay.getChildren();
                        if (recHours.size() == 0) {
                            calendar.setWorkingDay(day, false);
                            continue;
                        }
                        calendar.setWorkingDay(day, true);
                        ProjectCalendarHours hours = calendar.addCalendarHours(day);
                        for (Record recWorkingHours : recHours) {
                            if (recWorkingHours.getValue() == null) continue;
                            String[] wh = recWorkingHours.getValue().split("\\|");
                            try {
                                Date start = this.m_calendarTimeFormat.parse(wh[1]);
                                Date end = this.m_calendarTimeFormat.parse(wh[3]);
                                hours.addRange(new DateRange(start, end));
                            }
                            catch (ParseException e) {}
                        }
                    }
                }
                if ((exceptions = root.getChild("Exceptions")) == null) continue;
                for (Record exception : exceptions.getChildren()) {
                    int daysFrom1900 = Integer.parseInt(exception.getValue().split("\\|")[1]);
                    int daysFrom1970 = daysFrom1900 - 25567 - 2;
                    Date startEx = new Date((long)daysFrom1970 * 24L * 60L * 60L * 1000L);
                    calendar.addCalendarException(startEx, startEx);
                }
            }
            this.m_project.fireCalendarReadEvent(calendar);
        }
    }

    public void processResources(List<Row> rows) {
        for (Row row : rows) {
            ProjectCalendar calendar;
            Resource resource = this.m_project.addResource();
            resource.setUniqueID(row.getInteger("rsrc_id"));
            resource.setName(row.getString("rsrc_name"));
            resource.setCode(row.getString("employee_code"));
            resource.setEmailAddress(row.getString("email_addr"));
            resource.setNotes(row.getString("rsrc_notes"));
            resource.setCreationDate(row.getDate("create_date"));
            resource.setType(RESOURCE_TYPE_MAP.get(row.getString("rsrc_type")));
            resource.setInitials(row.getString("rsrc_short_name"));
            resource.setNumber(1, row.getInteger("parent_rsrc_id"));
            Integer calendarID = row.getInteger("clndr_id");
            if (calendarID != null && (calendar = this.m_calMap.get(calendarID)) != null) {
                if (!calendar.isDerived()) {
                    ProjectCalendar resourceCalendar = this.m_project.addCalendar();
                    resourceCalendar.setParent(calendar);
                    resourceCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                    resource.setResourceCalendar(resourceCalendar);
                } else if (calendar.getResource() == null) {
                    resource.setResourceCalendar(calendar);
                } else {
                    ProjectCalendar copy = this.m_project.addCalendar();
                    copy.copy(calendar);
                    resource.setResourceCalendar(copy);
                }
            }
            this.m_project.fireResourceReadEvent(resource);
        }
    }

    public void processTasks(List<Row> wbs, List<Row> tasks, List<Row> costs) {
        this.processTasks(wbs, tasks, costs, null);
    }

    public void processTasks(List<Row> wbs, List<Row> tasks, List<Row> costs, List<Row> udfVals) {
        Integer uniqueID;
        Task task;
        HashSet<Integer> uniqueIDs = new HashSet<Integer>();
        Map<Integer, TaskCosts> taskCostsMap = this.processCosts(costs);
        for (Row row : wbs) {
            task = this.m_project.addTask();
            uniqueID = row.getInteger("wbs_id");
            uniqueIDs.add(uniqueID);
            task.setUniqueID(uniqueID);
            task.setName(row.getString("wbs_name"));
            task.setBaselineCost(row.getDouble("orig_cost"));
            task.setRemainingCost(row.getDouble("indep_remain_total_cost"));
            task.setRemainingWork(row.getDuration("indep_remain_work_qty"));
            task.setBaselineStart(row.getDate("anticip_start_date"));
            task.setBaselineFinish(row.getDate("anticip_end_date"));
            task.setDate(1, row.getDate("suspend_date"));
            task.setDate(2, row.getDate("resume_date"));
            task.setText(1, row.getString("task_code"));
            task.setWBS(row.getString("wbs_short_name"));
            this.m_project.fireTaskReadEvent(task);
        }
        this.m_project.getChildTasks().clear();
        for (Row row : wbs) {
            task = this.m_project.getTaskByUniqueID(row.getInteger("wbs_id"));
            Task parentTask = this.m_project.getTaskByUniqueID(row.getInteger("parent_wbs_id"));
            if (parentTask == null) {
                this.m_project.getChildTasks().add(task);
                continue;
            }
            this.m_project.getChildTasks().remove(task);
            parentTask.getChildTasks().add(task);
            task.setWBS(parentTask.getWBS() + "." + task.getWBS());
        }
        int nextID = 1;
        this.m_clashMap.clear();
        for (Row row : tasks) {
            uniqueID = row.getInteger("task_id");
            if (uniqueIDs.contains(uniqueID)) {
                while (uniqueIDs.contains(nextID)) {
                    ++nextID;
                }
                Integer newUniqueID = nextID;
                this.m_clashMap.put(uniqueID, newUniqueID);
                uniqueID = newUniqueID;
            }
            uniqueIDs.add(uniqueID);
            Integer parentTaskID = row.getInteger("wbs_id");
            Task parentTask = this.m_project.getTaskByUniqueID(parentTaskID);
            Task task2 = parentTask == null ? this.m_project.addTask() : parentTask.addTask();
            task2.setUniqueID(uniqueID);
            task2.setPercentageComplete(row.getDouble("phys_complete_pct"));
            task2.setName(row.getString("task_name"));
            task2.setRemainingDuration(row.getDuration("remain_drtn_hr_cnt"));
            task2.setActualWork(row.getDuration("act_work_qty"));
            task2.setRemainingWork(row.getDuration("remain_work_qty"));
            task2.setBaselineWork(row.getDuration("target_work_qty"));
            task2.setBaselineDuration(row.getDuration("target_drtn_hr_cnt"));
            task2.setConstraintDate(row.getDate("cstr_date"));
            task2.setActualStart(row.getDate("act_start_date"));
            task2.setActualFinish(row.getDate("act_end_date"));
            task2.setLateStart(row.getDate("late_start_date"));
            task2.setLateFinish(row.getDate("late_end_date"));
            task2.setFinish(row.getDate("expect_end_date"));
            task2.setEarlyStart(row.getDate("early_start_date"));
            task2.setEarlyFinish(row.getDate("early_end_date"));
            task2.setBaselineStart(row.getDate("target_start_date"));
            task2.setBaselineFinish(row.getDate("target_end_date"));
            task2.setConstraintType(CONSTRAINT_TYPE_MAP.get(row.getString("cstr_type")));
            task2.setPriority(PRIORITY_MAP.get(row.getString("priority_type")));
            task2.setCreateDate(row.getDate("create_date"));
            task2.setType(TASK_TYPE_MAP.get(row.getString("duration_type")));
            task2.setMilestone(BooleanUtility.getBoolean(MILESTONE_MAP.get(row.getString("task_type"))));
            task2.setFreeSlack(row.getDuration("free_float_hr_cnt"));
            task2.setTotalSlack(row.getDuration("total_float_hr_cnt"));
            task2.setText(1, row.getString("task_code"));
            TaskCosts taskCosts = taskCostsMap.get(row.getInteger("task_id"));
            if (taskCosts != null) {
                task2.setActualCost(taskCosts.getActual());
                task2.setCost(taskCosts.getPlanned());
                task2.setRemainingCost(taskCosts.getRemaining());
            }
            Integer calId = row.getInteger("clndr_id");
            ProjectCalendar cal = this.m_calMap.get(calId);
            task2.setCalendar(cal);
            this.populateField(task2, TaskField.START, TaskField.BASELINE_START, TaskField.ACTUAL_START);
            this.populateField(task2, TaskField.FINISH, TaskField.BASELINE_FINISH, TaskField.ACTUAL_FINISH);
            this.populateField(task2, TaskField.WORK, TaskField.BASELINE_WORK, TaskField.ACTUAL_WORK);
            List<Row> taskUDF = this.getTaskUDF(uniqueID, udfVals);
            for (Row r : taskUDF) {
                this.addTaskUDFValue(task2, r);
            }
            this.m_project.fireTaskReadEvent(task2);
        }
        this.updateStructure();
        this.updateDates();
    }

    private Map<Integer, TaskCosts> processCosts(List<Row> costs) {
        HashMap<Integer, TaskCosts> map = new HashMap<Integer, TaskCosts>();
        for (Row cost : costs) {
            Integer taskID = cost.getInteger("task_id");
            TaskCosts taskCosts = (TaskCosts)map.get(taskID);
            if (taskCosts == null) {
                taskCosts = new TaskCosts();
                map.put(taskID, taskCosts);
            }
            taskCosts.addActual(cost.getDouble("act_cost"));
            taskCosts.addPlanned(cost.getDouble("target_cost"));
            taskCosts.addRemaining(cost.getDouble("remain_cost"));
        }
        return map;
    }

    private void addUserDefinedField(UserFieldDataType type, String name) {
        try {
            String fieldName = this.m_udfCounters.nextName(type);
            TaskField taskField = TaskField.valueOf(fieldName);
            this.m_project.setTaskFieldAlias(taskField, name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseTaskUDF(Row row) {
        Integer fieldId = Integer.valueOf(row.getString("udf_type_id"));
        String fieldType = row.getString("logical_data_type");
        String fieldName = row.getString("udf_type_label");
        this.m_udfMap.put(fieldId, fieldName);
        this.addUserDefinedField(UserFieldDataType.valueOf(fieldType), fieldName);
    }

    private void addTaskUDFValue(Task task, Row row) {
        Integer fieldId = Integer.valueOf(row.getString("udf_type_id"));
        String fieldName = this.m_udfMap.get(fieldId);
        Object value = null;
        TaskField field = this.m_project.getAliasTaskField(fieldName);
        if (field != null) {
            DataType fieldType = field.getDataType();
            switch (fieldType) {
                case DATE: {
                    value = row.getDate("udf_date");
                    break;
                }
                case CURRENCY: 
                case NUMERIC: {
                    value = row.getDouble("udf_number");
                    break;
                }
                case GUID: 
                case INTEGER: {
                    value = row.getInteger("udf_code_id");
                    break;
                }
                default: {
                    value = row.getString("udf_text");
                }
            }
            task.setFieldByAlias(fieldName, value);
        }
    }

    private List<Row> getTaskUDF(Integer taskID, List<Row> udfs) {
        LinkedList<Row> udf = new LinkedList<Row>();
        if (udfs != null) {
            for (Row row : udfs) {
                if (!taskID.equals(row.getInteger("fk_id"))) continue;
                udf.add(row);
            }
        }
        return udf;
    }

    private void populateField(FieldContainer container, FieldType target, FieldType baseline, FieldType actual) {
        Object value = container.getCachedValue(actual);
        if (value == null) {
            value = container.getCachedValue(baseline);
        }
        container.set(target, value);
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_project.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    private void updateDates() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        int finished = 0;
        Date plannedStartDate = parentTask.getStart();
        Date plannedFinishDate = parentTask.getFinish();
        Date actualStartDate = parentTask.getActualStart();
        Date actualFinishDate = parentTask.getActualFinish();
        for (Task task : parentTask.getChildTasks()) {
            this.updateDates(task);
            if (plannedStartDate == null || DateUtility.compare(plannedStartDate, task.getStart()) > 0) {
                plannedStartDate = task.getStart();
            }
            if (actualStartDate == null || DateUtility.compare(actualStartDate, task.getActualStart()) > 0) {
                actualStartDate = task.getActualStart();
            }
            if (plannedFinishDate == null || DateUtility.compare(plannedFinishDate, task.getFinish()) < 0) {
                plannedFinishDate = task.getFinish();
            }
            if (actualFinishDate == null || DateUtility.compare(actualFinishDate, task.getActualFinish()) < 0) {
                actualFinishDate = task.getFinish();
            }
            if (task.getActualFinish() == null) continue;
            ++finished;
        }
        parentTask.setStart(plannedStartDate);
        parentTask.setFinish(plannedFinishDate);
        parentTask.setActualStart(actualStartDate);
        if (finished == parentTask.getChildTasks().size()) {
            parentTask.setActualFinish(actualFinishDate);
        }
    }

    public void processPredecessors(List<Row> rows) {
        for (Row row : rows) {
            Task currentTask = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("task_id")));
            Task predecessorTask = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("pred_task_id")));
            if (currentTask == null || predecessorTask == null) continue;
            RelationType type = RELATION_TYPE_MAP.get(row.getString("pred_type"));
            Duration lag = row.getDuration("lag_hr_cnt");
            Relation relation = currentTask.addPredecessor(predecessorTask, type, lag);
            this.m_project.fireRelationReadEvent(relation);
        }
    }

    public void processAssignments(List<Row> rows) {
        for (Row row : rows) {
            Task task = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("task_id")));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("rsrc_id"));
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setUniqueID(row.getInteger("taskrsrc_id"));
            assignment.setRemainingWork(row.getDuration("remain_qty"));
            assignment.setBaselineWork(row.getDuration("target_qty"));
            assignment.setActualWork(row.getDuration("act_reg_qty"));
            assignment.setBaselineCost(row.getDouble("target_cost"));
            assignment.setActualCost(row.getDouble("act_reg_cost"));
            assignment.setActualStart(row.getDate("act_start_date"));
            assignment.setActualFinish(row.getDate("act_end_date"));
            assignment.setBaselineStart(row.getDate("target_start_date"));
            assignment.setBaselineFinish(row.getDate("target_end_date"));
            assignment.setDelay(row.getDuration("target_lag_drtn_hr_cnt"));
            this.populateField(assignment, AssignmentField.WORK, AssignmentField.BASELINE_WORK, AssignmentField.ACTUAL_WORK);
            this.populateField(assignment, AssignmentField.COST, AssignmentField.BASELINE_COST, AssignmentField.ACTUAL_COST);
            this.populateField(assignment, AssignmentField.START, AssignmentField.BASELINE_START, AssignmentField.ACTUAL_START);
            this.populateField(assignment, AssignmentField.FINISH, AssignmentField.BASELINE_FINISH, AssignmentField.ACTUAL_FINISH);
            this.m_project.fireAssignmentReadEvent(assignment);
        }
    }

    public void processDefaultCurrency(Row row) {
        ProjectHeader header = this.m_project.getProjectHeader();
        header.setCurrencySymbol(row.getString("curr_symbol"));
        header.setSymbolPosition(CURRENCY_SYMBOL_POSITION_MAP.get(row.getString("pos_curr_fmt_type")));
        header.setCurrencyDigits(row.getInteger("decimal_digit_cnt"));
        header.setThousandsSeparator(row.getString("digit_group_symbol").charAt(0));
        header.setDecimalSeparator(row.getString("decimal_symbol").charAt(0));
    }

    private Integer mapTaskID(Integer id) {
        Integer mappedID = this.m_clashMap.get(id);
        if (mappedID == null) {
            mappedID = id;
        }
        return mappedID;
    }

    static {
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Mat", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("RT_Equip", ResourceType.WORK);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("CS_MSO", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MSOB", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MSOA", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEO", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MEOB", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEOA", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_ALAP", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("CS_MANDSTART", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MANDFIN", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("PT_Top", Priority.getInstance(900));
        PRIORITY_MAP.put("PT_High", Priority.getInstance(600));
        PRIORITY_MAP.put("PT_Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("PT_Low", Priority.getInstance(400));
        PRIORITY_MAP.put("PT_Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("PR_FS", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("PR_FF", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("PR_SS", RelationType.START_START);
        RELATION_TYPE_MAP.put("PR_SF", RelationType.START_FINISH);
        TASK_TYPE_MAP = new HashMap<String, TaskType>();
        TASK_TYPE_MAP.put("DT_FixedDrtn", TaskType.FIXED_DURATION);
        TASK_TYPE_MAP.put("DT_FixedQty", TaskType.FIXED_UNITS);
        TASK_TYPE_MAP.put("DT_FixedDUR2", TaskType.FIXED_WORK);
        TASK_TYPE_MAP.put("DT_FixedRate", TaskType.FIXED_WORK);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("TT_Task", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Rsrc", Boolean.FALSE);
        MILESTONE_MAP.put("TT_LOE", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Mile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_FinMile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_WBS", Boolean.FALSE);
        CURRENCY_SYMBOL_POSITION_MAP = new HashMap<String, CurrencySymbolPosition>();
        CURRENCY_SYMBOL_POSITION_MAP.put("#1.1", CurrencySymbolPosition.BEFORE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1#", CurrencySymbolPosition.AFTER);
        CURRENCY_SYMBOL_POSITION_MAP.put("# 1.1", CurrencySymbolPosition.BEFORE_WITH_SPACE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1 #", CurrencySymbolPosition.AFTER_WITH_SPACE);
    }
}

