/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.ReplaceOnceStream;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ActivityType;
import net.sf.mpxj.primavera.schema.CalendarType;
import net.sf.mpxj.primavera.schema.CurrencyType;
import net.sf.mpxj.primavera.schema.GlobalPreferencesType;
import net.sf.mpxj.primavera.schema.ProjectType;
import net.sf.mpxj.primavera.schema.RelationshipType;
import net.sf.mpxj.primavera.schema.ResourceAssignmentType;
import net.sf.mpxj.primavera.schema.WBSType;
import net.sf.mpxj.primavera.schema.WorkTimeType;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class PrimaveraPMFileReader
extends AbstractProjectReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private ProjectFile m_projectFile;
    private List<ProjectListener> m_projectListeners;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private Map<Integer, ProjectCalendar> m_calMap = new HashMap<Integer, ProjectCalendar>();
    private static final Charset UTF8;
    private static final int NAMESPACE_SCOPE = 512;
    private static final String NAMESPACE_REGEX = "xmlns=\\\".*\\\"";
    private static final String NAMESPACE_REPLACEMENT = "xmlns=\"http://xmlns.oracle.com/Primavera/P6/V8.3/API/BusinessObjects\"";
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP;
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, Day> DAY_MAP;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            ReplaceOnceStream namespaceCorrectedStream = new ReplaceOnceStream(stream, NAMESPACE_REGEX, NAMESPACE_REPLACEMENT, 512, UTF8);
            this.m_projectFile = new ProjectFile();
            this.m_projectFile.setAutoTaskUniqueID(false);
            this.m_projectFile.setAutoResourceUniqueID(false);
            this.m_projectFile.setAutoCalendarUniqueID(false);
            this.m_projectFile.setAutoAssignmentUniqueID(false);
            this.m_projectFile.setTaskFieldAlias(TaskField.TEXT1, "WBS Code");
            this.m_projectFile.setTaskFieldAlias(TaskField.TEXT2, "Task ID");
            this.m_projectFile.addProjectListeners(this.m_projectListeners);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            SAXSource doc = new SAXSource(xmlReader, new InputSource(namespaceCorrectedStream));
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            APIBusinessObjects apibo = (APIBusinessObjects)unmarshaller.unmarshal((Source)doc);
            List<ProjectType> projects = apibo.getProject();
            ProjectType project = null;
            for (ProjectType currentProject : projects) {
                if (BooleanUtility.getBoolean(currentProject.isExternal())) continue;
                project = currentProject;
                break;
            }
            if (project == null) {
                throw new MPXJException("Unable to locate any non-external projects in a list of " + projects.size() + " projects");
            }
            this.processProjectHeader(apibo, project);
            this.processCalendars(apibo);
            this.processResources(apibo);
            this.processTasks(project);
            this.processPredecessors(project);
            this.processAssignments(project);
            this.m_projectFile.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXJException("Failed to parse file", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_clashMap.clear();
            this.m_calMap.clear();
        }
    }

    private void processProjectHeader(APIBusinessObjects apibo, ProjectType project) {
        ProjectHeader header = this.m_projectFile.getProjectHeader();
        header.setCreationDate(project.getCreateDate());
        header.setFinishDate(project.getFinishDate());
        header.setName(project.getName());
        header.setStartDate(project.getPlannedStartDate());
        header.setStatusDate(project.getDataDate());
        List<GlobalPreferencesType> list = apibo.getGlobalPreferences();
        if (!list.isEmpty()) {
            GlobalPreferencesType prefs = list.get(0);
            header.setCreationDate(prefs.getCreateDate());
            header.setLastSaved(prefs.getLastUpdateDate());
            header.setMinutesPerDay((int)(NumberUtility.getDouble(prefs.getHoursPerDay()) * 60.0));
            header.setMinutesPerWeek((int)(NumberUtility.getDouble(prefs.getHoursPerWeek()) * 60.0));
            header.setWeekStartDay(Day.getInstance(NumberUtility.getInt(prefs.getStartDayOfWeek())));
            List<CurrencyType> currencyList = apibo.getCurrency();
            for (CurrencyType currency : currencyList) {
                if (!currency.getObjectId().equals(prefs.getBaseCurrencyObjectId())) continue;
                header.setCurrencySymbol(currency.getSymbol());
                break;
            }
        }
    }

    private void processCalendars(APIBusinessObjects apibo) {
        for (CalendarType row : apibo.getCalendar()) {
            CalendarType.HolidayOrExceptions hoe;
            ProjectCalendar calendar = this.m_projectFile.addCalendar();
            Integer id = row.getObjectId();
            this.m_calMap.put(id, calendar);
            calendar.setName(row.getName());
            calendar.setUniqueID(id);
            CalendarType.StandardWorkWeek stdWorkWeek = row.getStandardWorkWeek();
            if (stdWorkWeek != null) {
                for (CalendarType.StandardWorkWeek.StandardWorkHours hours : stdWorkWeek.getStandardWorkHours()) {
                    Day day = DAY_MAP.get(hours.getDayOfWeek());
                    List<WorkTimeType> workTime = hours.getWorkTime();
                    if (workTime.isEmpty() || workTime.get(0) == null) {
                        calendar.setWorkingDay(day, false);
                        continue;
                    }
                    calendar.setWorkingDay(day, true);
                    ProjectCalendarHours calendarHours = calendar.addCalendarHours(day);
                    for (WorkTimeType work : workTime) {
                        if (work == null) continue;
                        calendarHours.addRange(new DateRange(work.getStart(), work.getFinish()));
                    }
                }
            }
            if ((hoe = row.getHolidayOrExceptions()) == null) continue;
            for (CalendarType.HolidayOrExceptions.HolidayOrException ex : hoe.getHolidayOrException()) {
                Date startDate = DateUtility.getDayStartDate(ex.getDate());
                Date endDate = DateUtility.getDayEndDate(ex.getDate());
                ProjectCalendarException pce = calendar.addCalendarException(startDate, endDate);
                List<WorkTimeType> workTime = ex.getWorkTime();
                for (WorkTimeType work : workTime) {
                    if (work == null) continue;
                    pce.addRange(new DateRange(work.getStart(), work.getFinish()));
                }
            }
        }
    }

    private void processResources(APIBusinessObjects apibo) {
        List<net.sf.mpxj.primavera.schema.ResourceType> resources = apibo.getResource();
        for (net.sf.mpxj.primavera.schema.ResourceType xml : resources) {
            ProjectCalendar calendar;
            Resource resource = this.m_projectFile.addResource();
            resource.setUniqueID(xml.getObjectId());
            resource.setName(xml.getName());
            resource.setCode(xml.getEmployeeId());
            resource.setEmailAddress(xml.getEmailAddress());
            resource.setNotes(xml.getResourceNotes());
            resource.setCreationDate(xml.getCreateDate());
            resource.setType(RESOURCE_TYPE_MAP.get(xml.getResourceType()));
            Integer calendarID = xml.getCalendarObjectId();
            if (calendarID != null && (calendar = this.m_calMap.get(calendarID)) != null) {
                if (!calendar.isDerived()) {
                    ProjectCalendar resourceCalendar = this.m_projectFile.addCalendar();
                    resourceCalendar.setParent(calendar);
                    resourceCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                    resource.setResourceCalendar(resourceCalendar);
                } else if (calendar.getResource() == null) {
                    resource.setResourceCalendar(calendar);
                } else {
                    ProjectCalendar copy = this.m_projectFile.addCalendar();
                    copy.copy(calendar);
                    resource.setResourceCalendar(copy);
                }
            }
            this.m_projectFile.fireResourceReadEvent(resource);
        }
    }

    private void processTasks(ProjectType project) {
        Integer uniqueID;
        Task task;
        List<WBSType> wbs = project.getWBS();
        List<ActivityType> tasks = project.getActivity();
        HashSet<Integer> uniqueIDs = new HashSet<Integer>();
        for (WBSType row : wbs) {
            task = this.m_projectFile.addTask();
            uniqueID = row.getObjectId();
            uniqueIDs.add(uniqueID);
            task.setUniqueID(uniqueID);
            task.setName(row.getName());
            task.setBaselineCost(row.getSummaryBaselineTotalCost());
            task.setRemainingCost(row.getSummaryRemainingTotalCost());
            task.setRemainingDuration(this.getDuration(row.getSummaryRemainingDuration()));
            task.setStart(row.getAnticipatedStartDate());
            task.setFinish(row.getAnticipatedFinishDate());
            task.setText(1, row.getCode());
        }
        this.m_projectFile.getChildTasks().clear();
        for (WBSType row : wbs) {
            task = this.m_projectFile.getTaskByUniqueID(row.getObjectId());
            Task parentTask = this.m_projectFile.getTaskByUniqueID(row.getParentObjectId());
            if (parentTask == null) {
                this.m_projectFile.getChildTasks().add(task);
                continue;
            }
            this.m_projectFile.getChildTasks().remove(task);
            parentTask.getChildTasks().add(task);
        }
        int nextID = 1;
        this.m_clashMap.clear();
        for (ActivityType row : tasks) {
            uniqueID = row.getObjectId();
            if (uniqueIDs.contains(uniqueID)) {
                while (uniqueIDs.contains(nextID)) {
                    ++nextID;
                }
                Integer newUniqueID = nextID;
                this.m_clashMap.put(uniqueID, newUniqueID);
                uniqueID = newUniqueID;
            }
            uniqueIDs.add(uniqueID);
            Integer parentTaskID = row.getWBSObjectId();
            Task parentTask = this.m_projectFile.getTaskByUniqueID(parentTaskID);
            Task task2 = parentTask == null ? this.m_projectFile.addTask() : parentTask.addTask();
            task2.setUniqueID(uniqueID);
            task2.setPercentageComplete(row.getPhysicalPercentComplete());
            task2.setName(row.getName());
            task2.setRemainingDuration(this.getDuration(row.getRemainingDuration()));
            task2.setActualWork(this.getDuration(row.getActualDuration()));
            task2.setRemainingWork(this.getDuration(row.getRemainingTotalUnits()));
            task2.setBaselineDuration(this.getDuration(row.getBaselineDuration()));
            task2.setConstraintDate(row.getPrimaryConstraintDate());
            task2.setConstraintType(CONSTRAINT_TYPE_MAP.get(row.getPrimaryConstraintType()));
            task2.setActualStart(row.getActualStartDate());
            task2.setActualFinish(row.getActualFinishDate());
            task2.setLateStart(row.getLateStartDate());
            task2.setLateFinish(row.getLateFinishDate());
            task2.setFinish(row.getExpectedFinishDate());
            task2.setEarlyStart(row.getEarlyStartDate());
            task2.setEarlyFinish(row.getEarlyFinishDate());
            task2.setBaselineStart(row.getBaselineStartDate());
            task2.setBaselineFinish(row.getBaselineFinishDate());
            task2.setPriority(PRIORITY_MAP.get(row.getLevelingPriority()));
            task2.setCreateDate(row.getCreateDate());
            task2.setText(1, row.getId());
            Integer calId = row.getCalendarObjectId();
            ProjectCalendar cal = this.m_calMap.get(calId);
            task2.setCalendar(cal);
            this.populateField(task2, TaskField.START, TaskField.BASELINE_START, TaskField.ACTUAL_START);
            this.populateField(task2, TaskField.FINISH, TaskField.BASELINE_FINISH, TaskField.ACTUAL_FINISH);
            this.populateField(task2, TaskField.WORK, TaskField.BASELINE_WORK, TaskField.ACTUAL_WORK);
            this.m_projectFile.fireTaskReadEvent(task2);
        }
        this.updateStructure();
    }

    private void populateField(FieldContainer container, FieldType target, FieldType baseline, FieldType actual) {
        Object value = container.getCachedValue(actual);
        if (value == null) {
            value = container.getCachedValue(baseline);
        }
        container.set(target, value);
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_projectFile.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    private void processPredecessors(ProjectType project) {
        for (RelationshipType row : project.getRelationship()) {
            Task currentTask = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(row.getSuccessorActivityObjectId()));
            Task predecessorTask = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(row.getPredecessorActivityObjectId()));
            if (currentTask == null || predecessorTask == null) continue;
            RelationType type = RELATION_TYPE_MAP.get(row.getType());
            Duration lag = this.getDuration(row.getLag());
            Relation relation = currentTask.addPredecessor(predecessorTask, type, lag);
            this.m_projectFile.fireRelationReadEvent(relation);
        }
    }

    private void processAssignments(ProjectType project) {
        List<ResourceAssignmentType> assignments = project.getResourceAssignment();
        for (ResourceAssignmentType row : assignments) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(row.getActivityObjectId()));
            Resource resource = this.m_projectFile.getResourceByUniqueID(row.getResourceObjectId());
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setUniqueID(row.getObjectId());
            assignment.setRemainingWork(this.getDuration(row.getRemainingUnits()));
            assignment.setBaselineWork(this.getDuration(row.getPlannedUnits()));
            assignment.setActualWork(this.getDuration(row.getActualUnits()));
            assignment.setBaselineCost(row.getPlannedCost());
            assignment.setActualCost(row.getActualCost());
            assignment.setActualStart(row.getActualStartDate());
            assignment.setActualFinish(row.getActualFinishDate());
            assignment.setBaselineStart(row.getPlannedStartDate());
            assignment.setBaselineFinish(row.getPlannedFinishDate());
            this.populateField(assignment, AssignmentField.WORK, AssignmentField.BASELINE_WORK, AssignmentField.ACTUAL_WORK);
            this.populateField(assignment, AssignmentField.COST, AssignmentField.BASELINE_COST, AssignmentField.ACTUAL_COST);
            this.populateField(assignment, AssignmentField.START, AssignmentField.BASELINE_START, AssignmentField.ACTUAL_START);
            this.populateField(assignment, AssignmentField.FINISH, AssignmentField.BASELINE_FINISH, AssignmentField.ACTUAL_FINISH);
            this.m_projectFile.fireAssignmentReadEvent(assignment);
        }
    }

    private Duration getDuration(Double duration) {
        Duration result = null;
        if (duration != null) {
            result = Duration.getInstance(NumberUtility.getDouble(duration), TimeUnit.HOURS);
        }
        return result;
    }

    private Integer mapTaskID(Integer id) {
        Integer mappedID = this.m_clashMap.get(id);
        if (mappedID == null) {
            mappedID = id;
        }
        return mappedID;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.primavera.schema", (ClassLoader)PrimaveraPMFileReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        UTF8 = Charset.forName("UTF8");
        RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Material", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("Nonlabor", ResourceType.MATERIAL);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("Start On", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Start On or Before", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Start On or After", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("Finish On or Before", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On or After", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("As Late As Possible", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("Mandatory Start", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Mandatory Finish", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("Top", Priority.getInstance(900));
        PRIORITY_MAP.put("High", Priority.getInstance(600));
        PRIORITY_MAP.put("Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("Low", Priority.getInstance(400));
        PRIORITY_MAP.put("Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("Finish to Start", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("Finish to Finish", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("Start to Start", RelationType.START_START);
        RELATION_TYPE_MAP.put("Start to Finish", RelationType.START_FINISH);
        DAY_MAP = new HashMap<String, Day>();
        DAY_MAP.put("Monday", Day.MONDAY);
        DAY_MAP.put("Tuesday", Day.TUESDAY);
        DAY_MAP.put("Wednesday", Day.WEDNESDAY);
        DAY_MAP.put("Thursday", Day.THURSDAY);
        DAY_MAP.put("Friday", Day.FRIDAY);
        DAY_MAP.put("Saturday", Day.SATURDAY);
        DAY_MAP.put("Sunday", Day.SUNDAY);
    }
}

