/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FileCreationRecord;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceAssignmentWorkgroupFields;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpx.LocaleData;
import net.sf.mpxj.mpx.LocaleUtility;
import net.sf.mpxj.mpx.MPXConstants;
import net.sf.mpxj.mpx.MPXResourceField;
import net.sf.mpxj.mpx.MPXTaskField;
import net.sf.mpxj.mpx.RecurrenceUtility;
import net.sf.mpxj.mpx.ResourceModel;
import net.sf.mpxj.mpx.TaskModel;
import net.sf.mpxj.utility.MPXJFormats;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.writer.AbstractProjectWriter;

public final class MPXWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private OutputStreamWriter m_writer;
    private ResourceModel m_resourceModel;
    private TaskModel m_taskModel;
    private char m_delimiter;
    private Locale m_locale = Locale.ENGLISH;
    private boolean m_useLocaleDefaults = true;
    private StringBuilder m_buffer;
    private MPXJFormats m_formats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ProjectFile projectFile, OutputStream out) throws IOException {
        this.m_projectFile = projectFile;
        if (this.m_useLocaleDefaults) {
            LocaleUtility.setLocale(this.m_projectFile, this.m_locale);
        }
        this.m_delimiter = projectFile.getDelimiter();
        this.m_writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), projectFile.getFileCreationRecord().getCodePage().getCharset());
        this.m_buffer = new StringBuilder();
        this.m_formats = new MPXJFormats(this.m_locale, LocaleData.getString(this.m_locale, "NA"), this.m_projectFile);
        try {
            this.write();
        }
        finally {
            this.m_writer = null;
            this.m_projectFile = null;
            this.m_resourceModel = null;
            this.m_taskModel = null;
            this.m_buffer = null;
            this.m_locale = null;
            this.m_formats = null;
        }
    }

    private void write() throws IOException {
        this.m_projectFile.validateUniqueIDsForMicrosoftProject();
        this.writeFileCreationRecord(this.m_projectFile.getFileCreationRecord());
        this.writeProjectHeader(this.m_projectFile.getProjectHeader());
        if (!this.m_projectFile.getAllResources().isEmpty()) {
            this.m_resourceModel = new ResourceModel(this.m_projectFile, this.m_locale);
            this.m_writer.write(this.m_resourceModel.toString());
            for (Resource resource : this.m_projectFile.getAllResources()) {
                this.writeResource(resource);
            }
        }
        if (!this.m_projectFile.getAllTasks().isEmpty()) {
            this.m_taskModel = new TaskModel(this.m_projectFile, this.m_locale);
            this.m_writer.write(this.m_taskModel.toString());
            this.writeTasks(this.m_projectFile.getChildTasks());
        }
        this.m_writer.flush();
    }

    private void writeFileCreationRecord(FileCreationRecord record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append("MPX");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getProgramName());
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getFileVersion());
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append((Object)record.getCodePage());
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeProjectHeader(ProjectHeader record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(10);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getCurrencySymbol()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getSymbolPosition()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getCurrencyDigits()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(record.getThousandsSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(record.getDecimalSeparator())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_buffer.append(11);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDefaultDurationUnits().getValue()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getDefaultDurationIsFixed() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDefaultWorkUnits().getValue()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDecimal(NumberUtility.getDouble(record.getMinutesPerDay()) / 60.0)));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDecimal(NumberUtility.getDouble(record.getMinutesPerWeek()) / 60.0)));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatRate(record.getDefaultStandardRate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatRate(record.getDefaultOvertimeRate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getUpdatingTaskStatusUpdatesResourceStatus() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getSplitInProgressTasks() ? "1" : "0");
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_buffer.append(12);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDateOrder()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getTimeFormat()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.getIntegerTimeInMinutes(record.getDefaultStartTime())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(record.getDateSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(record.getTimeSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getAMText()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getPMText()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDateFormat()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getBarTextDateFormat()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        for (ProjectCalendar cal : this.m_projectFile.getCalendars()) {
            this.writeCalendar(cal);
        }
        this.m_buffer.setLength(0);
        this.m_buffer.append(30);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getProjectTitle()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getCompany()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getManager()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getCalendarName()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getStartDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getFinishDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getScheduleFrom()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getCurrentDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getComments()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getBaselineCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getActualCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getBaselineWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getActualWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatPercentage(record.getWork2())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getBaselineDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getActualDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatPercentage(record.getPercentageComplete())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getBaselineStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getBaselineFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getActualStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getActualFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getStartVariance())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getFinishVariance())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getSubject()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getAuthor()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getKeywords()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeCalendar(ProjectCalendar record) throws IOException {
        if (record.getParent() == null || record.getResource() != null) {
            this.m_buffer.setLength(0);
            if (record.getParent() == null) {
                this.m_buffer.append(20);
                this.m_buffer.append(this.m_delimiter);
                if (record.getName() != null) {
                    this.m_buffer.append(record.getName());
                }
            } else {
                this.m_buffer.append(55);
                this.m_buffer.append(this.m_delimiter);
                this.m_buffer.append(record.getParent().getName());
            }
            DayType[] days = record.getDays();
            for (int loop = 0; loop < days.length; ++loop) {
                this.m_buffer.append(this.m_delimiter);
                this.m_buffer.append(days[loop].getValue());
            }
            this.m_buffer.append("\r\n");
            this.m_writer.write(this.m_buffer.toString());
            ProjectCalendarHours[] hours = record.getHours();
            for (int loop = 0; loop < hours.length; ++loop) {
                if (hours[loop] == null) continue;
                this.writeCalendarHours(record, hours[loop]);
            }
            if (!record.getCalendarExceptions().isEmpty()) {
                for (ProjectCalendarException ex : record.getCalendarExceptions()) {
                    this.writeCalendarException(record, ex);
                }
            }
            this.m_projectFile.fireCalendarWrittenEvent(record);
        }
    }

    private void writeCalendarHours(ProjectCalendar parentCalendar, ProjectCalendarHours record) throws IOException {
        DateRange range3;
        DateRange range2;
        this.m_buffer.setLength(0);
        int recordNumber = !parentCalendar.isDerived() ? 25 : 56;
        DateRange range1 = record.getRange(0);
        if (range1 == null) {
            range1 = DateRange.EMPTY_RANGE;
        }
        if ((range2 = record.getRange(1)) == null) {
            range2 = DateRange.EMPTY_RANGE;
        }
        if ((range3 = record.getRange(2)) == null) {
            range3 = DateRange.EMPTY_RANGE;
        }
        this.m_buffer.append(recordNumber);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDay()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range1.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range1.getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range2.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range2.getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range3.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range3.getEnd())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeCalendarException(ProjectCalendar parentCalendar, ProjectCalendarException record) throws IOException {
        this.m_buffer.setLength(0);
        if (!parentCalendar.isDerived()) {
            this.m_buffer.append(26);
        } else {
            this.m_buffer.append(57);
        }
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDate(record.getFromDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDate(record.getToDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getWorking() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(0).getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(0).getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(1).getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(1).getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(2).getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(2).getEnd())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeResource(Resource record) throws IOException {
        int mpxFieldType;
        this.m_buffer.setLength(0);
        int[] fields = this.m_resourceModel.getModel();
        this.m_buffer.append(50);
        for (int loop = 0; loop < fields.length && (mpxFieldType = fields[loop]) != -1; ++loop) {
            ResourceField resourceField = MPXResourceField.getMpxjField(mpxFieldType);
            Object value = record.getCachedValue(resourceField);
            value = this.formatType(resourceField.getDataType(), value);
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(value));
        }
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        String notes = record.getNotes();
        if (notes.length() != 0) {
            this.writeNotes(51, notes);
        }
        if (record.getResourceCalendar() != null) {
            this.writeCalendar(record.getResourceCalendar());
        }
        this.m_projectFile.fireResourceWrittenEvent(record);
    }

    private void writeNotes(int recordNumber, String text) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(recordNumber);
        this.m_buffer.append(this.m_delimiter);
        if (text != null) {
            String note = this.stripLineBreaks(text, MPXConstants.EOL_PLACEHOLDER_STRING);
            boolean quote = note.indexOf(this.m_delimiter) != -1 || note.indexOf(34) != -1;
            int length = note.length();
            if (quote) {
                this.m_buffer.append('\"');
            }
            block3: for (int loop = 0; loop < length; ++loop) {
                char c = note.charAt(loop);
                switch (c) {
                    case '\"': {
                        this.m_buffer.append("\"\"");
                        continue block3;
                    }
                    default: {
                        this.m_buffer.append(c);
                    }
                }
            }
            if (quote) {
                this.m_buffer.append('\"');
            }
        }
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeTask(Task record) throws IOException {
        int field;
        this.m_buffer.setLength(0);
        int[] fields = this.m_taskModel.getModel();
        this.m_buffer.append(70);
        for (int loop = 0; loop < fields.length && (field = fields[loop]) != -1; ++loop) {
            TaskField taskField = MPXTaskField.getMpxjField(field);
            Object value = record.getCachedValue(taskField);
            value = this.formatType(taskField.getDataType(), value);
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(value));
        }
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        String notes = record.getNotes();
        if (notes.length() != 0) {
            this.writeNotes(71, notes);
        }
        if (record.getRecurringTask() != null) {
            this.writeRecurringTask(record.getRecurringTask());
        }
        if (!record.getResourceAssignments().isEmpty()) {
            for (ResourceAssignment assignment : record.getResourceAssignments()) {
                this.writeResourceAssignment(assignment);
            }
        }
        this.m_projectFile.fireTaskWrittenEvent(record);
    }

    private void writeRecurringTask(RecurringTask record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(72);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append("1");
        if (record.getRecurrenceType() != null) {
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(this.formatDateTime(record.getStartDate())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(this.formatDateTime(record.getFinishDate())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDurationValue(this.m_projectFile.getProjectHeader(), record.getDuration())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDurationUnits(record)));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getOccurrences()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getRecurrenceValue(record.getRecurrenceType())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append("0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(record.getUseEndDate() ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(record.getDailyWorkday() ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDays(record.getWeeklyDays())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(record.getMonthlyRelative() ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(record.getYearlyAbsolute() ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getDailyFrequency()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getWeeklyFrequency()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getMonthlyRelativeOrdinal()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDay(record.getMonthlyRelativeDay())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getMonthlyRelativeFrequency()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getMonthlyAbsoluteDay()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getMonthlyAbsoluteFrequency()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getYearlyRelativeOrdinal()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDay(record.getYearlyRelativeDay())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getYearlyRelativeMonth()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(this.formatDateTime(record.getYearlyAbsoluteDate())));
            this.stripTrailingDelimiters(this.m_buffer);
        }
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeResourceAssignment(ResourceAssignment record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(75);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.formatResource(record.getResource()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatUnits(record.getUnits())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getBaselineWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getActualWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getOvertimeWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getBaselineCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getActualCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getDelay())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getResourceUniqueID()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        ResourceAssignmentWorkgroupFields workgroup = record.getWorkgroupAssignment();
        if (workgroup == null) {
            workgroup = ResourceAssignmentWorkgroupFields.EMPTY;
        }
        this.writeResourceAssignmentWorkgroupFields(workgroup);
        this.m_projectFile.fireAssignmentWrittenEvent(record);
    }

    private void writeResourceAssignmentWorkgroupFields(ResourceAssignmentWorkgroupFields record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(76);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getMessageUniqueID()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getConfirmed() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getResponsePending() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTimeNull(record.getUpdateStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTimeNull(record.getUpdateFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getScheduleID()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeTasks(List<Task> tasks) throws IOException {
        for (Task task : tasks) {
            this.writeTask(task);
            this.writeTasks(task.getChildTasks());
        }
    }

    private Integer getIntegerTimeInMinutes(Date date) {
        Integer result = null;
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int time = cal.get(11) * 60;
            result = time += cal.get(12);
        }
        return result;
    }

    private String escapeQuotes(String value) {
        StringBuilder sb = new StringBuilder();
        int length = value.length();
        sb.append('\"');
        for (int index = 0; index < length; ++index) {
            char c = value.charAt(index);
            sb.append(c);
            if (c != '\"') continue;
            sb.append('\"');
        }
        sb.append('\"');
        return sb.toString();
    }

    private String stripLineBreaks(String text, String replacement) {
        if (text.indexOf(13) != -1 || text.indexOf(10) != -1) {
            int index;
            StringBuilder sb = new StringBuilder(text);
            while ((index = sb.indexOf("\r\n")) != -1) {
                sb.replace(index, index + 2, replacement);
            }
            while ((index = sb.indexOf("\n\r")) != -1) {
                sb.replace(index, index + 2, replacement);
            }
            while ((index = sb.indexOf("\r")) != -1) {
                sb.replace(index, index + 1, replacement);
            }
            while ((index = sb.indexOf("\n")) != -1) {
                sb.replace(index, index + 1, replacement);
            }
            text = sb.toString();
        }
        return text;
    }

    private String format(Object o) {
        String result;
        if (o == null) {
            result = "";
        } else {
            result = o instanceof Boolean ? LocaleData.getString(this.m_locale, (Boolean)o == true ? "YES" : "NO") : (o instanceof Float || o instanceof Double ? this.m_formats.getDecimalFormat().format(((Number)o).doubleValue()) : (o instanceof Day ? Integer.toString(((Day)o).getValue()) : o.toString()));
            if ((result = this.stripLineBreaks(result, MPXConstants.EOL_PLACEHOLDER_STRING)).indexOf(34) != -1) {
                result = this.escapeQuotes(result);
            } else if (result.indexOf(this.m_delimiter) != -1) {
                result = '\"' + result + '\"';
            }
        }
        return result;
    }

    private void stripTrailingDelimiters(StringBuilder buffer) {
        int index;
        for (index = buffer.length() - 1; index > 0 && buffer.charAt(index) == this.m_delimiter; --index) {
        }
        buffer.setLength(index + 1);
    }

    private String formatTime(Date value) {
        return value == null ? null : this.m_formats.getTimeFormat().format(value);
    }

    private String formatCurrency(Number value) {
        return value == null ? null : this.m_formats.getCurrencyFormat().format(value);
    }

    private String formatUnits(Number value) {
        return value == null ? null : this.m_formats.getUnitsDecimalFormat().format(value.doubleValue() / 100.0);
    }

    private String formatDateTime(Object value) {
        String result = null;
        if (value instanceof Date) {
            result = this.m_formats.getDateTimeFormat().format(value);
        }
        return result;
    }

    private String formatDateTimeNull(Date value) {
        return value == null ? this.m_formats.getNullText() : this.m_formats.getDateTimeFormat().format(value);
    }

    private String formatDate(Date value) {
        return value == null ? null : this.m_formats.getDateFormat().format(value);
    }

    private String formatPercentage(Number value) {
        return value == null ? null : this.m_formats.getPercentageDecimalFormat().format(value) + "%";
    }

    private String formatAccrueType(AccrueType type) {
        return type == null ? null : LocaleData.getStringArray(this.m_locale, "ACCRUE_TYPES")[type.getValue() - 1];
    }

    private String formatConstraintType(ConstraintType type) {
        return type == null ? null : LocaleData.getStringArray(this.m_locale, "CONSTRAINT_TYPES")[type.getValue()];
    }

    private String formatDuration(Object value) {
        String result = null;
        if (value instanceof Duration) {
            Duration duration = (Duration)value;
            result = this.m_formats.getDurationDecimalFormat().format(duration.getDuration()) + this.formatTimeUnit(duration.getUnits());
        }
        return result;
    }

    private String formatRate(Rate value) {
        String result = null;
        if (value != null) {
            StringBuilder buffer = new StringBuilder(this.m_formats.getCurrencyFormat().format(value.getAmount()));
            buffer.append("/");
            buffer.append(this.formatTimeUnit(value.getUnits()));
            result = buffer.toString();
        }
        return result;
    }

    private String formatPriority(Priority value) {
        String result = null;
        if (value != null) {
            String[] priorityTypes = LocaleData.getStringArray(this.m_locale, "PRIORITY_TYPES");
            int priority = value.getValue();
            if (priority < 100) {
                priority = 100;
            } else if (priority > 1000) {
                priority = 1000;
            }
            result = priorityTypes[(priority /= 100) - 1];
        }
        return result;
    }

    private String formatTaskType(TaskType value) {
        return LocaleData.getString(this.m_locale, value == TaskType.FIXED_DURATION ? "YES" : "NO");
    }

    private String formatRelationList(List<Relation> value) {
        String result = null;
        if (value != null) {
            StringBuilder sb = new StringBuilder();
            for (Relation relation : value) {
                if (sb.length() != 0) {
                    sb.append(this.m_delimiter);
                }
                sb.append(this.formatRelation(relation));
            }
            result = sb.toString();
        }
        return result;
    }

    private String formatRelation(Relation relation) {
        String result = null;
        if (relation != null) {
            StringBuilder sb = new StringBuilder(relation.getTargetTask().getID().toString());
            Duration duration = relation.getLag();
            RelationType type = relation.getType();
            double durationValue = duration.getDuration();
            if (durationValue != 0.0 || type != RelationType.FINISH_START) {
                String[] typeNames = LocaleData.getStringArray(this.m_locale, "RELATION_TYPES");
                sb.append(typeNames[type.getValue()]);
            }
            if (durationValue != 0.0) {
                if (durationValue > 0.0) {
                    sb.append('+');
                }
                sb.append(this.formatDuration(duration));
            }
            result = sb.toString();
        }
        this.m_projectFile.fireRelationWrittenEvent(relation);
        return result;
    }

    private String formatTimeUnit(TimeUnit timeUnit) {
        int units = timeUnit.getValue();
        String[][] unitNames = LocaleData.getStringArrays(this.m_locale, "TIME_UNITS_ARRAY");
        String result = units < 0 || units >= unitNames.length ? "" : unitNames[units][0];
        return result;
    }

    private String formatDecimal(double value) {
        return this.m_formats.getDecimalFormat().format(value);
    }

    private Object formatType(DataType type, Object value) {
        switch (type) {
            case DATE: {
                value = this.formatDateTime(value);
                break;
            }
            case CURRENCY: {
                value = this.formatCurrency((Number)value);
                break;
            }
            case UNITS: {
                value = this.formatUnits((Number)value);
                break;
            }
            case PERCENTAGE: {
                value = this.formatPercentage((Number)value);
                break;
            }
            case ACCRUE: {
                value = this.formatAccrueType((AccrueType)value);
                break;
            }
            case CONSTRAINT: {
                value = this.formatConstraintType((ConstraintType)value);
                break;
            }
            case WORK: 
            case DURATION: {
                value = this.formatDuration(value);
                break;
            }
            case RATE: {
                value = this.formatRate((Rate)value);
                break;
            }
            case PRIORITY: {
                value = this.formatPriority((Priority)value);
                break;
            }
            case RELATION_LIST: {
                value = this.formatRelationList((List)value);
                break;
            }
            case TASK_TYPE: {
                value = this.formatTaskType((TaskType)value);
                break;
            }
        }
        return value;
    }

    private String formatResource(Resource resource) {
        return resource == null ? "-65535" : this.format(resource.getID());
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public boolean getUseLocaleDefaults() {
        return this.m_useLocaleDefaults;
    }

    public void setUseLocaleDefaults(boolean useLocaleDefaults) {
        this.m_useLocaleDefaults = useLocaleDefaults;
    }

    public Locale[] getSupportedLocales() {
        return LocaleUtility.getSupportedLocales();
    }
}

