/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import net.sf.mpxj.AbstractTimephasedWorkNormaliser;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.utility.DateUtility;

public abstract class MPPAbstractTimephasedWorkNormaliser
extends AbstractTimephasedWorkNormaliser {
    private static final double EQUALITY_DELTA = 0.1;

    @Override
    public void normalise(ProjectCalendar calendar, LinkedList<TimephasedWork> list) {
        if (!list.isEmpty()) {
            this.splitDays(calendar, list);
            this.mergeSameDay(calendar, list);
            this.mergeSameWork(list);
            this.convertToHours(list);
        }
    }

    private void splitDays(ProjectCalendar calendar, LinkedList<TimephasedWork> list) {
        LinkedList<TimephasedWork> result = new LinkedList<TimephasedWork>();
        boolean remainderInserted = false;
        Calendar cal = Calendar.getInstance();
        block0: for (TimephasedWork assignment : list) {
            if (remainderInserted) {
                cal.setTime(assignment.getStart());
                cal.add(6, 1);
                assignment.setStart(cal.getTime());
                remainderInserted = false;
            }
            while (assignment != null) {
                Date startDay = DateUtility.getDayStartDate(assignment.getStart());
                Date finishDay = DateUtility.getDayStartDate(assignment.getFinish());
                if (assignment.getFinish().getTime() == finishDay.getTime()) {
                    cal.setTime(finishDay);
                    cal.add(6, -1);
                    finishDay = cal.getTime();
                }
                if (startDay.getTime() == finishDay.getTime()) {
                    Duration totalWork = (Duration)assignment.getTotalAmount();
                    Duration assignmentWork = this.getAssignmentWork(calendar, assignment);
                    if (totalWork.getDuration() - assignmentWork.getDuration() > 0.1) {
                        assignment.setTotalAmount(assignmentWork);
                        result.add(assignment);
                        Duration remainingWork = Duration.getInstance(totalWork.getDuration() - assignmentWork.getDuration(), TimeUnit.MINUTES);
                        cal.setTime(finishDay);
                        cal.add(6, 1);
                        Date remainderStart = cal.getTime();
                        cal.add(6, 1);
                        Date remainderFinish = cal.getTime();
                        TimephasedWork remainder = new TimephasedWork();
                        remainder.setStart(remainderStart);
                        remainder.setFinish(remainderFinish);
                        remainder.setTotalAmount(remainingWork);
                        result.add(remainder);
                        remainderInserted = true;
                        continue block0;
                    }
                    result.add(assignment);
                    continue block0;
                }
                TimephasedWork[] split = this.splitFirstDay(calendar, assignment);
                if (split[0] != null) {
                    result.add(split[0]);
                }
                if (assignment.equals(split[1])) continue block0;
                assignment = split[1];
            }
        }
        list.clear();
        list.addAll(result);
    }

    private TimephasedWork[] splitFirstDay(ProjectCalendar calendar, TimephasedWork assignment) {
        TimephasedWork[] result = new TimephasedWork[2];
        Date assignmentStart = assignment.getStart();
        Date assignmentFinish = assignment.getFinish();
        Duration calendarWork = calendar.getWork(assignmentStart, assignmentFinish, TimeUnit.MINUTES);
        Duration assignmentWork = (Duration)assignment.getTotalAmount();
        if (calendarWork.getDuration() != 0.0) {
            TimephasedWork split;
            double splitMinutes;
            Date splitFinish;
            Date splitStart;
            if (calendar.isWorkingDate(assignmentStart)) {
                Duration splitWork;
                splitStart = assignmentStart;
                Date splitFinishTime = calendar.getFinishTime(splitStart);
                splitFinish = DateUtility.setTime(splitStart, splitFinishTime);
                Duration calendarSplitWork = calendar.getWork(splitStart, splitFinish, TimeUnit.MINUTES);
                Duration calendarWorkPerDay = calendar.getWork(splitStart, TimeUnit.MINUTES);
                Duration assignmentWorkPerDay = (Duration)assignment.getAmountPerDay();
                if (calendarSplitWork.durationComponentEquals(calendarWorkPerDay)) {
                    if (calendarSplitWork.durationComponentEquals(assignmentWorkPerDay)) {
                        splitWork = assignmentWorkPerDay;
                        splitMinutes = splitWork.getDuration();
                    } else {
                        splitMinutes = assignmentWorkPerDay.getDuration();
                        splitMinutes *= calendarSplitWork.getDuration();
                        splitWork = Duration.getInstance(splitMinutes /= 480.0, TimeUnit.MINUTES);
                    }
                } else {
                    splitMinutes = assignmentWorkPerDay.getDuration();
                    splitMinutes *= calendarSplitWork.getDuration();
                    splitWork = Duration.getInstance(splitMinutes /= 480.0, TimeUnit.MINUTES);
                }
                TimephasedWork split2 = new TimephasedWork();
                split2.setStart(splitStart);
                split2.setFinish(splitFinish);
                split2.setTotalAmount(splitWork);
                result[0] = split2;
            } else {
                splitFinish = assignmentStart;
                splitMinutes = 0.0;
            }
            splitStart = calendar.getNextWorkStart(splitFinish);
            splitFinish = assignmentFinish;
            if (splitStart.getTime() > splitFinish.getTime()) {
                split = null;
            } else {
                splitMinutes = assignmentWork.getDuration() - splitMinutes;
                Duration splitWork = Duration.getInstance(splitMinutes, TimeUnit.MINUTES);
                split = new TimephasedWork();
                split.setStart(splitStart);
                split.setFinish(splitFinish);
                split.setTotalAmount(splitWork);
                split.setAmountPerDay(assignment.getAmountPerDay());
            }
            result[1] = split;
        }
        return result;
    }

    protected abstract void mergeSameDay(ProjectCalendar var1, LinkedList<TimephasedWork> var2);

    private Duration getAssignmentWork(ProjectCalendar calendar, TimephasedWork assignment) {
        Date assignmentStart;
        Date splitStart = assignmentStart = assignment.getStart();
        Date splitFinishTime = calendar.getFinishTime(splitStart);
        Date splitFinish = DateUtility.setTime(splitStart, splitFinishTime);
        Duration calendarSplitWork = calendar.getWork(splitStart, splitFinish, TimeUnit.MINUTES);
        Duration assignmentWorkPerDay = (Duration)assignment.getAmountPerDay();
        double splitMinutes = assignmentWorkPerDay.getDuration();
        splitMinutes *= calendarSplitWork.getDuration();
        Duration splitWork = Duration.getInstance(splitMinutes /= 480.0, TimeUnit.MINUTES);
        return splitWork;
    }
}

