/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.Column;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpp.ExtendedData;
import net.sf.mpxj.mpp.FixDeferFix;
import net.sf.mpxj.mpp.FixFix;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.ProjectHeaderReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props8;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.View8;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.Pair;
import net.sf.mpxj.utility.RTFUtility;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

final class MPP8Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private HashMap<Integer, ProjectCalendar> m_calendarMap;
    private DirectoryEntry m_root;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private static final Integer TASK_WBS = 104;
    private static final Integer TASK_CONTACT = 105;
    private static final Integer TASK_TEXT1 = 106;
    private static final Integer TASK_TEXT2 = 107;
    private static final Integer TASK_TEXT3 = 108;
    private static final Integer TASK_TEXT4 = 109;
    private static final Integer TASK_TEXT5 = 110;
    private static final Integer TASK_TEXT6 = 111;
    private static final Integer TASK_TEXT7 = 112;
    private static final Integer TASK_TEXT8 = 113;
    private static final Integer TASK_TEXT9 = 114;
    private static final Integer TASK_TEXT10 = 115;
    private static final Integer TASK_START1 = 116;
    private static final Integer TASK_FINISH1 = 117;
    private static final Integer TASK_START2 = 118;
    private static final Integer TASK_FINISH2 = 119;
    private static final Integer TASK_START3 = 120;
    private static final Integer TASK_FINISH3 = 121;
    private static final Integer TASK_START4 = 122;
    private static final Integer TASK_FINISH4 = 123;
    private static final Integer TASK_START5 = 124;
    private static final Integer TASK_FINISH5 = 125;
    private static final Integer TASK_START6 = 126;
    private static final Integer TASK_FINISH6 = 127;
    private static final Integer TASK_START7 = 128;
    private static final Integer TASK_FINISH7 = 129;
    private static final Integer TASK_START8 = 130;
    private static final Integer TASK_FINISH8 = 131;
    private static final Integer TASK_START9 = 132;
    private static final Integer TASK_FINISH9 = 133;
    private static final Integer TASK_START10 = 134;
    private static final Integer TASK_FINISH10 = 135;
    private static final Integer TASK_NUMBER1 = 137;
    private static final Integer TASK_NUMBER2 = 138;
    private static final Integer TASK_NUMBER3 = 139;
    private static final Integer TASK_NUMBER4 = 140;
    private static final Integer TASK_NUMBER5 = 141;
    private static final Integer TASK_NUMBER6 = 142;
    private static final Integer TASK_NUMBER7 = 143;
    private static final Integer TASK_NUMBER8 = 144;
    private static final Integer TASK_NUMBER9 = 145;
    private static final Integer TASK_NUMBER10 = 146;
    private static final Integer TASK_DURATION1 = 147;
    private static final Integer TASK_DURATION1_UNITS = 148;
    private static final Integer TASK_DURATION2 = 149;
    private static final Integer TASK_DURATION2_UNITS = 150;
    private static final Integer TASK_DURATION3 = 151;
    private static final Integer TASK_DURATION3_UNITS = 152;
    private static final Integer TASK_DURATION4 = 153;
    private static final Integer TASK_DURATION4_UNITS = 154;
    private static final Integer TASK_DURATION5 = 155;
    private static final Integer TASK_DURATION5_UNITS = 156;
    private static final Integer TASK_DURATION6 = 157;
    private static final Integer TASK_DURATION6_UNITS = 158;
    private static final Integer TASK_DURATION7 = 159;
    private static final Integer TASK_DURATION7_UNITS = 160;
    private static final Integer TASK_DURATION8 = 161;
    private static final Integer TASK_DURATION8_UNITS = 162;
    private static final Integer TASK_DURATION9 = 163;
    private static final Integer TASK_DURATION9_UNITS = 164;
    private static final Integer TASK_DURATION10 = 165;
    private static final Integer TASK_DURATION10_UNITS = 166;
    private static final Integer TASK_RECURRING_DATA = 168;
    private static final Integer TASK_DATE1 = 174;
    private static final Integer TASK_DATE2 = 175;
    private static final Integer TASK_DATE3 = 176;
    private static final Integer TASK_DATE4 = 177;
    private static final Integer TASK_DATE5 = 178;
    private static final Integer TASK_DATE6 = 179;
    private static final Integer TASK_DATE7 = 180;
    private static final Integer TASK_DATE8 = 181;
    private static final Integer TASK_DATE9 = 182;
    private static final Integer TASK_DATE10 = 183;
    private static final Integer TASK_TEXT11 = 184;
    private static final Integer TASK_TEXT12 = 185;
    private static final Integer TASK_TEXT13 = 186;
    private static final Integer TASK_TEXT14 = 187;
    private static final Integer TASK_TEXT15 = 188;
    private static final Integer TASK_TEXT16 = 189;
    private static final Integer TASK_TEXT17 = 190;
    private static final Integer TASK_TEXT18 = 191;
    private static final Integer TASK_TEXT19 = 192;
    private static final Integer TASK_TEXT20 = 193;
    private static final Integer TASK_TEXT21 = 194;
    private static final Integer TASK_TEXT22 = 195;
    private static final Integer TASK_TEXT23 = 196;
    private static final Integer TASK_TEXT24 = 197;
    private static final Integer TASK_TEXT25 = 198;
    private static final Integer TASK_TEXT26 = 199;
    private static final Integer TASK_TEXT27 = 200;
    private static final Integer TASK_TEXT28 = 201;
    private static final Integer TASK_TEXT29 = 202;
    private static final Integer TASK_TEXT30 = 203;
    private static final Integer TASK_NUMBER11 = 204;
    private static final Integer TASK_NUMBER12 = 205;
    private static final Integer TASK_NUMBER13 = 206;
    private static final Integer TASK_NUMBER14 = 207;
    private static final Integer TASK_NUMBER15 = 208;
    private static final Integer TASK_NUMBER16 = 209;
    private static final Integer TASK_NUMBER17 = 210;
    private static final Integer TASK_NUMBER18 = 211;
    private static final Integer TASK_NUMBER19 = 212;
    private static final Integer TASK_NUMBER20 = 213;
    private static final Integer TASK_HYPERLINK = 236;
    private static final Integer TASK_COST1 = 237;
    private static final Integer TASK_COST2 = 238;
    private static final Integer TASK_COST3 = 239;
    private static final Integer TASK_COST4 = 240;
    private static final Integer TASK_COST5 = 241;
    private static final Integer TASK_COST6 = 242;
    private static final Integer TASK_COST7 = 243;
    private static final Integer TASK_COST8 = 244;
    private static final Integer TASK_COST9 = 245;
    private static final Integer TASK_COST10 = 246;
    private static final Integer TASK_NOTES = 247;
    private static final Integer RESOURCE_GROUP = 61;
    private static final Integer RESOURCE_CODE = 62;
    private static final Integer RESOURCE_EMAIL = 63;
    private static final Integer RESOURCE_TEXT1 = 64;
    private static final Integer RESOURCE_TEXT2 = 65;
    private static final Integer RESOURCE_TEXT3 = 66;
    private static final Integer RESOURCE_TEXT4 = 67;
    private static final Integer RESOURCE_TEXT5 = 68;
    private static final Integer RESOURCE_TEXT6 = 69;
    private static final Integer RESOURCE_TEXT7 = 70;
    private static final Integer RESOURCE_TEXT8 = 71;
    private static final Integer RESOURCE_TEXT9 = 72;
    private static final Integer RESOURCE_TEXT10 = 73;
    private static final Integer RESOURCE_TEXT11 = 74;
    private static final Integer RESOURCE_TEXT12 = 75;
    private static final Integer RESOURCE_TEXT13 = 76;
    private static final Integer RESOURCE_TEXT14 = 77;
    private static final Integer RESOURCE_TEXT15 = 78;
    private static final Integer RESOURCE_TEXT16 = 79;
    private static final Integer RESOURCE_TEXT17 = 80;
    private static final Integer RESOURCE_TEXT18 = 81;
    private static final Integer RESOURCE_TEXT19 = 82;
    private static final Integer RESOURCE_TEXT20 = 83;
    private static final Integer RESOURCE_TEXT21 = 84;
    private static final Integer RESOURCE_TEXT22 = 85;
    private static final Integer RESOURCE_TEXT23 = 86;
    private static final Integer RESOURCE_TEXT24 = 87;
    private static final Integer RESOURCE_TEXT25 = 88;
    private static final Integer RESOURCE_TEXT26 = 89;
    private static final Integer RESOURCE_TEXT27 = 90;
    private static final Integer RESOURCE_TEXT28 = 91;
    private static final Integer RESOURCE_TEXT29 = 92;
    private static final Integer RESOURCE_TEXT30 = 93;
    private static final Integer RESOURCE_START1 = 94;
    private static final Integer RESOURCE_START2 = 95;
    private static final Integer RESOURCE_START3 = 96;
    private static final Integer RESOURCE_START4 = 97;
    private static final Integer RESOURCE_START5 = 98;
    private static final Integer RESOURCE_START6 = 99;
    private static final Integer RESOURCE_START7 = 100;
    private static final Integer RESOURCE_START8 = 101;
    private static final Integer RESOURCE_START9 = 102;
    private static final Integer RESOURCE_START10 = 103;
    private static final Integer RESOURCE_FINISH1 = 104;
    private static final Integer RESOURCE_FINISH2 = 105;
    private static final Integer RESOURCE_FINISH3 = 106;
    private static final Integer RESOURCE_FINISH4 = 107;
    private static final Integer RESOURCE_FINISH5 = 108;
    private static final Integer RESOURCE_FINISH6 = 109;
    private static final Integer RESOURCE_FINISH7 = 110;
    private static final Integer RESOURCE_FINISH8 = 111;
    private static final Integer RESOURCE_FINISH9 = 112;
    private static final Integer RESOURCE_FINISH10 = 113;
    private static final Integer RESOURCE_NUMBER1 = 114;
    private static final Integer RESOURCE_NUMBER2 = 115;
    private static final Integer RESOURCE_NUMBER3 = 116;
    private static final Integer RESOURCE_NUMBER4 = 117;
    private static final Integer RESOURCE_NUMBER5 = 118;
    private static final Integer RESOURCE_NUMBER6 = 119;
    private static final Integer RESOURCE_NUMBER7 = 120;
    private static final Integer RESOURCE_NUMBER8 = 121;
    private static final Integer RESOURCE_NUMBER9 = 122;
    private static final Integer RESOURCE_NUMBER10 = 123;
    private static final Integer RESOURCE_NUMBER11 = 124;
    private static final Integer RESOURCE_NUMBER12 = 125;
    private static final Integer RESOURCE_NUMBER13 = 126;
    private static final Integer RESOURCE_NUMBER14 = 127;
    private static final Integer RESOURCE_NUMBER15 = 128;
    private static final Integer RESOURCE_NUMBER16 = 129;
    private static final Integer RESOURCE_NUMBER17 = 130;
    private static final Integer RESOURCE_NUMBER18 = 131;
    private static final Integer RESOURCE_NUMBER19 = 132;
    private static final Integer RESOURCE_NUMBER20 = 133;
    private static final Integer RESOURCE_DURATION1 = 134;
    private static final Integer RESOURCE_DURATION2 = 135;
    private static final Integer RESOURCE_DURATION3 = 136;
    private static final Integer RESOURCE_DURATION4 = 137;
    private static final Integer RESOURCE_DURATION5 = 138;
    private static final Integer RESOURCE_DURATION6 = 139;
    private static final Integer RESOURCE_DURATION7 = 140;
    private static final Integer RESOURCE_DURATION8 = 141;
    private static final Integer RESOURCE_DURATION9 = 142;
    private static final Integer RESOURCE_DURATION10 = 143;
    private static final Integer RESOURCE_DURATION1_UNITS = 144;
    private static final Integer RESOURCE_DURATION2_UNITS = 145;
    private static final Integer RESOURCE_DURATION3_UNITS = 146;
    private static final Integer RESOURCE_DURATION4_UNITS = 147;
    private static final Integer RESOURCE_DURATION5_UNITS = 148;
    private static final Integer RESOURCE_DURATION6_UNITS = 149;
    private static final Integer RESOURCE_DURATION7_UNITS = 150;
    private static final Integer RESOURCE_DURATION8_UNITS = 151;
    private static final Integer RESOURCE_DURATION9_UNITS = 152;
    private static final Integer RESOURCE_DURATION10_UNITS = 153;
    private static final Integer RESOURCE_DATE1 = 157;
    private static final Integer RESOURCE_DATE2 = 158;
    private static final Integer RESOURCE_DATE3 = 159;
    private static final Integer RESOURCE_DATE4 = 160;
    private static final Integer RESOURCE_DATE5 = 161;
    private static final Integer RESOURCE_DATE6 = 162;
    private static final Integer RESOURCE_DATE7 = 163;
    private static final Integer RESOURCE_DATE8 = 164;
    private static final Integer RESOURCE_DATE9 = 165;
    private static final Integer RESOURCE_DATE10 = 166;
    private static final Integer RESOURCE_NOTES = 169;
    private static final Integer RESOURCE_COST1 = 170;
    private static final Integer RESOURCE_COST2 = 171;
    private static final Integer RESOURCE_COST3 = 172;
    private static final Integer RESOURCE_COST4 = 173;
    private static final Integer RESOURCE_COST5 = 174;
    private static final Integer RESOURCE_COST6 = 175;
    private static final Integer RESOURCE_COST7 = 176;
    private static final Integer RESOURCE_COST8 = 177;
    private static final Integer RESOURCE_COST9 = 178;
    private static final Integer RESOURCE_COST10 = 179;
    private static final boolean[] DEFAULT_WORKING_WEEK = new boolean[]{false, true, true, true, true, true, false};

    MPP8Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader reader, ProjectFile file, DirectoryEntry root) throws MPXJException, IOException {
        try {
            this.m_reader = reader;
            this.m_root = root;
            this.m_file = file;
            this.m_calendarMap = new HashMap();
            this.m_projectDir = (DirectoryEntry)root.getEntry("   1");
            this.m_viewDir = (DirectoryEntry)root.getEntry("   2");
            this.m_file.setMppFileType(8);
            this.processPropertyData();
            this.processCalendarData();
            this.processResourceData();
            this.processTaskData();
            this.processConstraintData();
            this.processAssignmentData();
            if (reader.getReadPresentationData()) {
                this.processViewPropertyData();
                this.processViewData();
                this.processTableData();
            }
        }
        finally {
            this.m_reader = null;
            this.m_root = null;
            this.m_file = null;
            this.m_calendarMap = null;
            this.m_projectDir = null;
            this.m_viewDir = null;
        }
    }

    private void processPropertyData() throws MPXJException, IOException {
        Props8 props = new Props8((InputStream)new DocumentInputStream((DocumentEntry)this.m_projectDir.getEntry("Props")));
        ProjectHeaderReader projectHeaderReader = new ProjectHeaderReader();
        projectHeaderReader.process(this.m_file, props, this.m_root);
    }

    private void processViewPropertyData() throws IOException {
        Props8 props = new Props8((InputStream)new DocumentInputStream((DocumentEntry)this.m_viewDir.getEntry("Props")));
        ProjectHeader header = this.m_file.getProjectHeader();
        header.setShowProjectSummaryTask(props.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
    }

    private void processCalendarData() throws MPXJException, IOException {
        Date defaultEnd2;
        Date defaultStart2;
        Date defaultEnd1;
        Date defaultStart1;
        DirectoryEntry calDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCal");
        FixFix calendarFixedData = new FixFix(36, (InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("FixFix   0")));
        FixDeferFix calendarVarData = new FixDeferFix((InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("FixDeferFix   0")));
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        try {
            defaultStart1 = df.parse("08:00");
            defaultEnd1 = df.parse("12:00");
            defaultStart2 = df.parse("13:00");
            defaultEnd2 = df.parse("17:00");
        }
        catch (ParseException ex) {
            throw new MPXJException("Invalid format", ex);
        }
        int calendars = calendarFixedData.getItemCount();
        LinkedList<Pair<ProjectCalendar, Integer>> baseCalendars = new LinkedList<Pair<ProjectCalendar, Integer>>();
        for (int loop = 0; loop < calendars; ++loop) {
            ProjectCalendar cal;
            byte[] baseData = calendarFixedData.getByteArrayValue(loop);
            int calendarID = MPPUtility.getInt(baseData, 0);
            int baseCalendarID = MPPUtility.getInt(baseData, 4);
            String name = calendarVarData.getUnicodeString(this.getOffset(baseData, 20));
            if (calendarID < 0) continue;
            ExtendedData ed = new ExtendedData(calendarVarData, this.getOffset(baseData, 32));
            int offset = -1 - ed.getInt(8);
            if (offset == -1) {
                if (baseCalendarID > 0) {
                    cal = this.m_file.addDefaultDerivedCalendar();
                    baseCalendars.add(new Pair<ProjectCalendar, Integer>(cal, baseCalendarID));
                } else {
                    cal = this.m_file.addDefaultBaseCalendar();
                    cal.setName(name);
                }
                cal.setUniqueID(calendarID);
            } else {
                long duration;
                Date start;
                int periodCount;
                int index;
                if (baseCalendarID > 0) {
                    cal = this.m_file.addCalendar();
                    baseCalendars.add(new Pair<ProjectCalendar, Integer>(cal, baseCalendarID));
                } else {
                    cal = this.m_file.addCalendar();
                    cal.setName(name);
                }
                cal.setUniqueID(calendarID);
                byte[] extData = calendarVarData.getByteArray(offset);
                for (index = 0; index < 7; ++index) {
                    ProjectCalendarHours hours;
                    offset = 4 + 40 * index;
                    int defaultFlag = MPPUtility.getShort(extData, offset);
                    Day day = Day.getInstance(index + 1);
                    if (defaultFlag == 1) {
                        cal.setWorkingDay(day, DEFAULT_WORKING_WEEK[index]);
                        if (!cal.isWorkingDay(day)) continue;
                        hours = cal.addCalendarHours(Day.getInstance(index + 1));
                        hours.addRange(new DateRange(defaultStart1, defaultEnd1));
                        hours.addRange(new DateRange(defaultStart2, defaultEnd2));
                        continue;
                    }
                    periodCount = MPPUtility.getShort(extData, offset + 2);
                    if (periodCount == 0) {
                        cal.setWorkingDay(day, false);
                        continue;
                    }
                    cal.setWorkingDay(day, true);
                    hours = cal.addCalendarHours(Day.getInstance(index + 1));
                    for (int periodIndex = 0; periodIndex < periodCount; ++periodIndex) {
                        start = MPPUtility.getTime(extData, offset + 8 + periodIndex * 2);
                        duration = MPPUtility.getDuration(extData, offset + 16 + periodIndex * 4);
                        hours.addRange(new DateRange(start, new Date(start.getTime() + duration)));
                    }
                }
                int exceptionCount = MPPUtility.getShort(extData, 0);
                if (exceptionCount != 0) {
                    for (index = 0; index < exceptionCount; ++index) {
                        offset = 284 + index * 44;
                        Date fromDate = MPPUtility.getDate(extData, offset);
                        Date toDate = MPPUtility.getDate(extData, offset + 2);
                        ProjectCalendarException exception = cal.addCalendarException(fromDate, toDate);
                        periodCount = MPPUtility.getShort(extData, offset + 6);
                        if (periodCount == 0) continue;
                        for (int exceptionPeriodIndex = 0; exceptionPeriodIndex < periodCount; ++exceptionPeriodIndex) {
                            start = MPPUtility.getTime(extData, offset + 12 + exceptionPeriodIndex * 2);
                            duration = MPPUtility.getDuration(extData, offset + 20 + exceptionPeriodIndex * 4);
                            exception.addRange(new DateRange(start, new Date(start.getTime() + duration)));
                        }
                    }
                }
            }
            this.m_calendarMap.put(calendarID, cal);
            this.m_file.fireCalendarReadEvent(cal);
        }
        this.updateBaseCalendarNames(baseCalendars);
    }

    private void updateBaseCalendarNames(List<Pair<ProjectCalendar, Integer>> baseCalendars) {
        for (Pair<ProjectCalendar, Integer> pair : baseCalendars) {
            ProjectCalendar cal = pair.getFirst();
            Integer baseCalendarID = pair.getSecond();
            ProjectCalendar baseCal = this.m_calendarMap.get(baseCalendarID);
            if (baseCal == null) continue;
            cal.setParent(baseCal);
        }
    }

    private void processTaskData() throws IOException {
        DirectoryEntry taskDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        FixFix taskFixedData = new FixFix(316, (InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("FixFix   0")));
        if (taskFixedData.getDiff() != 0) {
            taskFixedData = new FixFix(366, (InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("FixFix   0")));
        }
        FixDeferFix taskVarData = null;
        ExtendedData taskExtData = null;
        int tasks = taskFixedData.getItemCount();
        boolean autoWBS = true;
        byte[] flags = new byte[3];
        RecurringTaskReader recurringTaskReader = null;
        TimeUnit defaultProjectTimeUnits = this.m_file.getProjectHeader().getDefaultDurationUnits();
        for (int loop = 0; loop < tasks; ++loop) {
            String notes;
            int deleted;
            byte[] data = taskFixedData.getByteArrayValue(loop);
            int uniqueID = MPPUtility.getInt(data, 0);
            if (uniqueID < 1 || ((deleted = MPPUtility.getShort(data, 272)) & 0xC0) == 0 && (deleted & 3) != 0 && deleted != 49 && deleted != 8253) continue;
            if (taskVarData == null) {
                taskVarData = new FixDeferFix((InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("FixDeferFix   0")));
            }
            if ((data[8] & 1) != 0) continue;
            taskExtData = new ExtendedData(taskVarData, this.getOffset(data, 312));
            byte[] recurringData = taskExtData.getByteArray(TASK_RECURRING_DATA);
            int id = MPPUtility.getInt(data, 4);
            flags[0] = (byte)(data[268] & data[303]);
            flags[1] = (byte)(data[269] & data[304]);
            flags[2] = (byte)(data[270] & data[305]);
            Task task = this.m_file.addTask();
            task.setActualCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 234) / 100.0));
            task.setActualDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 74), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 72), defaultProjectTimeUnits)));
            task.setActualFinish(MPPUtility.getTimestamp(data, 108));
            task.setActualOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 210) / 100.0));
            task.setActualOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 192) / 100.0, TimeUnit.HOURS));
            task.setActualStart(MPPUtility.getTimestamp(data, 104));
            task.setActualWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 180) / 100.0, TimeUnit.HOURS));
            task.setBaselineCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 246) / 100.0));
            task.setBaselineDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 82), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 72), defaultProjectTimeUnits)));
            task.setBaselineFinish(MPPUtility.getTimestamp(data, 116));
            task.setBaselineStart(MPPUtility.getTimestamp(data, 112));
            task.setBaselineWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 174) / 100.0, TimeUnit.HOURS));
            task.setConstraintDate(MPPUtility.getTimestamp(data, 120));
            task.setConstraintType(ConstraintType.getInstance(MPPUtility.getShort(data, 88)));
            task.setContact(taskExtData.getUnicodeString(TASK_CONTACT));
            task.setCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 222) / 100.0));
            task.setCost(1, NumberUtility.getDouble((double)taskExtData.getLong(TASK_COST1) / 100.0));
            task.setCost(2, NumberUtility.getDouble((double)taskExtData.getLong(TASK_COST2) / 100.0));
            task.setCost(3, NumberUtility.getDouble((double)taskExtData.getLong(TASK_COST3) / 100.0));
            task.setCost(4, NumberUtility.getDouble((double)taskExtData.getLong(TASK_COST4) / 100.0));
            task.setCost(5, NumberUtility.getDouble((double)taskExtData.getLong(TASK_COST5) / 100.0));
            task.setCost(6, NumberUtility.getDouble((double)taskExtData.getLong(TASK_COST6) / 100.0));
            task.setCost(7, NumberUtility.getDouble((double)taskExtData.getLong(TASK_COST7) / 100.0));
            task.setCost(8, NumberUtility.getDouble((double)taskExtData.getLong(TASK_COST8) / 100.0));
            task.setCost(9, NumberUtility.getDouble((double)taskExtData.getLong(TASK_COST9) / 100.0));
            task.setCost(10, NumberUtility.getDouble((double)taskExtData.getLong(TASK_COST10) / 100.0));
            task.setCreateDate(MPPUtility.getTimestamp(data, 138));
            task.setDate(1, taskExtData.getTimestamp(TASK_DATE1));
            task.setDate(2, taskExtData.getTimestamp(TASK_DATE2));
            task.setDate(3, taskExtData.getTimestamp(TASK_DATE3));
            task.setDate(4, taskExtData.getTimestamp(TASK_DATE4));
            task.setDate(5, taskExtData.getTimestamp(TASK_DATE5));
            task.setDate(6, taskExtData.getTimestamp(TASK_DATE6));
            task.setDate(7, taskExtData.getTimestamp(TASK_DATE7));
            task.setDate(8, taskExtData.getTimestamp(TASK_DATE8));
            task.setDate(9, taskExtData.getTimestamp(TASK_DATE9));
            task.setDate(10, taskExtData.getTimestamp(TASK_DATE10));
            task.setDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 68), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 72), defaultProjectTimeUnits)));
            task.setDuration(1, MPPUtility.getAdjustedDuration(this.m_file, taskExtData.getInt(TASK_DURATION1), MPPUtility.getDurationTimeUnits(taskExtData.getShort(TASK_DURATION1_UNITS), defaultProjectTimeUnits)));
            task.setDuration(2, MPPUtility.getAdjustedDuration(this.m_file, taskExtData.getInt(TASK_DURATION2), MPPUtility.getDurationTimeUnits(taskExtData.getShort(TASK_DURATION2_UNITS), defaultProjectTimeUnits)));
            task.setDuration(3, MPPUtility.getAdjustedDuration(this.m_file, taskExtData.getInt(TASK_DURATION3), MPPUtility.getDurationTimeUnits(taskExtData.getShort(TASK_DURATION3_UNITS), defaultProjectTimeUnits)));
            task.setDuration(4, MPPUtility.getAdjustedDuration(this.m_file, taskExtData.getInt(TASK_DURATION4), MPPUtility.getDurationTimeUnits(taskExtData.getShort(TASK_DURATION4_UNITS), defaultProjectTimeUnits)));
            task.setDuration(5, MPPUtility.getAdjustedDuration(this.m_file, taskExtData.getInt(TASK_DURATION5), MPPUtility.getDurationTimeUnits(taskExtData.getShort(TASK_DURATION5_UNITS), defaultProjectTimeUnits)));
            task.setDuration(6, MPPUtility.getAdjustedDuration(this.m_file, taskExtData.getInt(TASK_DURATION6), MPPUtility.getDurationTimeUnits(taskExtData.getShort(TASK_DURATION6_UNITS), defaultProjectTimeUnits)));
            task.setDuration(7, MPPUtility.getAdjustedDuration(this.m_file, taskExtData.getInt(TASK_DURATION7), MPPUtility.getDurationTimeUnits(taskExtData.getShort(TASK_DURATION7_UNITS), defaultProjectTimeUnits)));
            task.setDuration(8, MPPUtility.getAdjustedDuration(this.m_file, taskExtData.getInt(TASK_DURATION8), MPPUtility.getDurationTimeUnits(taskExtData.getShort(TASK_DURATION8_UNITS), defaultProjectTimeUnits)));
            task.setDuration(9, MPPUtility.getAdjustedDuration(this.m_file, taskExtData.getInt(TASK_DURATION9), MPPUtility.getDurationTimeUnits(taskExtData.getShort(TASK_DURATION9_UNITS), defaultProjectTimeUnits)));
            task.setDuration(10, MPPUtility.getAdjustedDuration(this.m_file, taskExtData.getInt(TASK_DURATION10), MPPUtility.getDurationTimeUnits(taskExtData.getShort(TASK_DURATION10_UNITS), defaultProjectTimeUnits)));
            task.setEarlyFinish(MPPUtility.getTimestamp(data, 20));
            task.setEarlyStart(MPPUtility.getTimestamp(data, 96));
            task.setEffortDriven((data[17] & 8) != 0);
            task.setFinish(MPPUtility.getTimestamp(data, 20));
            task.setFinish(1, taskExtData.getTimestamp(TASK_FINISH1));
            task.setFinish(2, taskExtData.getTimestamp(TASK_FINISH2));
            task.setFinish(3, taskExtData.getTimestamp(TASK_FINISH3));
            task.setFinish(4, taskExtData.getTimestamp(TASK_FINISH4));
            task.setFinish(5, taskExtData.getTimestamp(TASK_FINISH5));
            task.setFinish(6, taskExtData.getTimestamp(TASK_FINISH6));
            task.setFinish(7, taskExtData.getTimestamp(TASK_FINISH7));
            task.setFinish(8, taskExtData.getTimestamp(TASK_FINISH8));
            task.setFinish(9, taskExtData.getTimestamp(TASK_FINISH9));
            task.setFinish(10, taskExtData.getTimestamp(TASK_FINISH10));
            task.setFixedCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 228) / 100.0));
            task.setFixedCostAccrual(AccrueType.getInstance(MPPUtility.getShort(data, 136)));
            task.setFlag(1, (flags[0] & 2) != 0);
            task.setFlag(2, (flags[0] & 4) != 0);
            task.setFlag(3, (flags[0] & 8) != 0);
            task.setFlag(4, (flags[0] & 0x10) != 0);
            task.setFlag(5, (flags[0] & 0x20) != 0);
            task.setFlag(6, (flags[0] & 0x40) != 0);
            task.setFlag(7, (flags[0] & 0x80) != 0);
            task.setFlag(8, (flags[1] & 1) != 0);
            task.setFlag(9, (flags[1] & 2) != 0);
            task.setFlag(10, (flags[1] & 4) != 0);
            task.setFlag(11, (flags[1] & 8) != 0);
            task.setFlag(12, (flags[1] & 0x10) != 0);
            task.setFlag(13, (flags[1] & 0x20) != 0);
            task.setFlag(14, (flags[1] & 0x40) != 0);
            task.setFlag(15, (flags[1] & 0x80) != 0);
            task.setFlag(16, (flags[2] & 1) != 0);
            task.setFlag(17, (flags[2] & 2) != 0);
            task.setFlag(18, (flags[2] & 4) != 0);
            task.setFlag(19, (flags[2] & 8) != 0);
            task.setFlag(20, (flags[2] & 0x10) != 0);
            task.setHideBar((data[16] & 1) != 0);
            this.processHyperlinkData(task, taskVarData.getByteArray(-1 - taskExtData.getInt(TASK_HYPERLINK)));
            task.setID(id);
            task.setLateFinish(MPPUtility.getTimestamp(data, 160));
            task.setLateStart(MPPUtility.getTimestamp(data, 24));
            task.setLevelAssignments((data[19] & 0x10) != 0);
            task.setLevelingCanSplit((data[19] & 8) != 0);
            task.setLevelingDelay(MPPUtility.getDuration((double)MPPUtility.getInt(data, 90) / 3.0, MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 94), defaultProjectTimeUnits)));
            task.setMarked((data[13] & 2) != 0);
            task.setMilestone((data[12] & 1) != 0);
            task.setName(taskVarData.getUnicodeString(this.getOffset(data, 264)));
            task.setNumber(1, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER1)));
            task.setNumber(2, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER2)));
            task.setNumber(3, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER3)));
            task.setNumber(4, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER4)));
            task.setNumber(5, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER5)));
            task.setNumber(6, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER6)));
            task.setNumber(7, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER7)));
            task.setNumber(8, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER8)));
            task.setNumber(9, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER9)));
            task.setNumber(10, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER10)));
            task.setNumber(11, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER11)));
            task.setNumber(12, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER12)));
            task.setNumber(13, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER13)));
            task.setNumber(14, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER14)));
            task.setNumber(15, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER15)));
            task.setNumber(16, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER16)));
            task.setNumber(17, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER17)));
            task.setNumber(18, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER18)));
            task.setNumber(19, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER19)));
            task.setNumber(20, NumberUtility.getDouble(taskExtData.getDouble(TASK_NUMBER20)));
            task.setOutlineLevel(MPPUtility.getShort(data, 48));
            task.setOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 204) / 100.0));
            task.setPercentageComplete(MPPUtility.getPercentage(data, 130));
            task.setPercentageWorkComplete(MPPUtility.getPercentage(data, 132));
            task.setPreleveledFinish(MPPUtility.getTimestamp(data, 148));
            task.setPreleveledStart(MPPUtility.getTimestamp(data, 144));
            task.setPriority(Priority.getInstance((MPPUtility.getShort(data, 128) + 1) * 100));
            task.setRecurring(MPPUtility.getShort(data, 142) != 0);
            task.setRemainingCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 240) / 100.0));
            task.setRemainingDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 78), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 72), defaultProjectTimeUnits)));
            task.setRemainingOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 216) / 100.0));
            task.setRemainingOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 198) / 100.0, TimeUnit.HOURS));
            task.setRemainingWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 186) / 100.0, TimeUnit.HOURS));
            task.setResume(MPPUtility.getTimestamp(data, 32));
            task.setRollup((data[15] & 4) != 0);
            task.setStart(MPPUtility.getTimestamp(data, 96));
            task.setStart(1, taskExtData.getTimestamp(TASK_START1));
            task.setStart(2, taskExtData.getTimestamp(TASK_START2));
            task.setStart(3, taskExtData.getTimestamp(TASK_START3));
            task.setStart(4, taskExtData.getTimestamp(TASK_START4));
            task.setStart(5, taskExtData.getTimestamp(TASK_START5));
            task.setStart(6, taskExtData.getTimestamp(TASK_START6));
            task.setStart(7, taskExtData.getTimestamp(TASK_START7));
            task.setStart(8, taskExtData.getTimestamp(TASK_START8));
            task.setStart(9, taskExtData.getTimestamp(TASK_START9));
            task.setStart(10, taskExtData.getTimestamp(TASK_START10));
            task.setStop(MPPUtility.getTimestamp(data, 124));
            task.setText(1, taskExtData.getUnicodeString(TASK_TEXT1));
            task.setText(2, taskExtData.getUnicodeString(TASK_TEXT2));
            task.setText(3, taskExtData.getUnicodeString(TASK_TEXT3));
            task.setText(4, taskExtData.getUnicodeString(TASK_TEXT4));
            task.setText(5, taskExtData.getUnicodeString(TASK_TEXT5));
            task.setText(6, taskExtData.getUnicodeString(TASK_TEXT6));
            task.setText(7, taskExtData.getUnicodeString(TASK_TEXT7));
            task.setText(8, taskExtData.getUnicodeString(TASK_TEXT8));
            task.setText(9, taskExtData.getUnicodeString(TASK_TEXT9));
            task.setText(10, taskExtData.getUnicodeString(TASK_TEXT10));
            task.setText(11, taskExtData.getUnicodeString(TASK_TEXT11));
            task.setText(12, taskExtData.getUnicodeString(TASK_TEXT12));
            task.setText(13, taskExtData.getUnicodeString(TASK_TEXT13));
            task.setText(14, taskExtData.getUnicodeString(TASK_TEXT14));
            task.setText(15, taskExtData.getUnicodeString(TASK_TEXT15));
            task.setText(16, taskExtData.getUnicodeString(TASK_TEXT16));
            task.setText(17, taskExtData.getUnicodeString(TASK_TEXT17));
            task.setText(18, taskExtData.getUnicodeString(TASK_TEXT18));
            task.setText(19, taskExtData.getUnicodeString(TASK_TEXT19));
            task.setText(20, taskExtData.getUnicodeString(TASK_TEXT20));
            task.setText(21, taskExtData.getUnicodeString(TASK_TEXT21));
            task.setText(22, taskExtData.getUnicodeString(TASK_TEXT22));
            task.setText(23, taskExtData.getUnicodeString(TASK_TEXT23));
            task.setText(24, taskExtData.getUnicodeString(TASK_TEXT24));
            task.setText(25, taskExtData.getUnicodeString(TASK_TEXT25));
            task.setText(26, taskExtData.getUnicodeString(TASK_TEXT26));
            task.setText(27, taskExtData.getUnicodeString(TASK_TEXT27));
            task.setText(28, taskExtData.getUnicodeString(TASK_TEXT28));
            task.setText(29, taskExtData.getUnicodeString(TASK_TEXT29));
            task.setText(30, taskExtData.getUnicodeString(TASK_TEXT30));
            task.setType(TaskType.getInstance(MPPUtility.getShort(data, 134)));
            task.setUniqueID(uniqueID);
            task.setWBS(taskExtData.getUnicodeString(TASK_WBS));
            task.setWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 168) / 100.0, TimeUnit.HOURS));
            if (recurringData != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(this.m_file);
                }
                recurringTaskReader.processRecurringTask(task, recurringData);
            }
            if ((notes = taskExtData.getString(TASK_NOTES)) != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    notes = RTFUtility.strip(notes);
                }
                task.setNotes(notes);
            }
            if (task.getWBS() != null) {
                autoWBS = false;
            }
            this.m_file.fireTaskReadEvent(task);
        }
        this.m_file.setAutoWBS(autoWBS);
    }

    private void processHyperlinkData(Task task, byte[] data) {
        if (data != null) {
            int offset = 12;
            String hyperlink = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (hyperlink.length() + 1) * 2;
            String address = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (address.length() + 1) * 2;
            String subaddress = MPPUtility.getUnicodeString(data, offset += 12);
            task.setHyperlink(hyperlink);
            task.setHyperlinkAddress(address);
            task.setHyperlinkSubAddress(subaddress);
        }
    }

    private void processConstraintData() throws IOException {
        DirectoryEntry consDir;
        try {
            consDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCons");
        }
        catch (FileNotFoundException ex) {
            consDir = null;
        }
        if (consDir != null) {
            FixFix consFixedData = new FixFix(36, (InputStream)new DocumentInputStream((DocumentEntry)consDir.getEntry("FixFix   0")));
            int count = consFixedData.getItemCount();
            for (int loop = 0; loop < count; ++loop) {
                int taskID2;
                int taskID1;
                byte[] data = consFixedData.getByteArrayValue(loop);
                if (MPPUtility.getInt(data, 28) != 0 || (taskID1 = MPPUtility.getInt(data, 12)) == (taskID2 = MPPUtility.getInt(data, 16))) continue;
                Task task1 = this.m_file.getTaskByUniqueID(taskID1);
                Task task2 = this.m_file.getTaskByUniqueID(taskID2);
                if (task1 == null || task2 == null) continue;
                RelationType type = RelationType.getInstance(MPPUtility.getShort(data, 20));
                TimeUnit durationUnits = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 22));
                Duration lag = MPPUtility.getDuration(MPPUtility.getInt(data, 24), durationUnits);
                Relation relation = task2.addPredecessor(task1, type, lag);
                this.m_file.fireRelationReadEvent(relation);
            }
        }
    }

    private void processResourceData() throws IOException {
        DirectoryEntry rscDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        FixFix rscFixedData = new FixFix(196, (InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("FixFix   0")));
        FixDeferFix rscVarData = null;
        ExtendedData rscExtData = null;
        int resources = rscFixedData.getItemCount();
        for (int loop = 0; loop < resources; ++loop) {
            byte[] data = rscFixedData.getByteArrayValue(loop);
            int id = MPPUtility.getInt(data, 0);
            if (id < 1 || (data[8] & 1) != 0 || MPPUtility.getShort(data, 164) != 0) continue;
            if (rscVarData == null) {
                rscVarData = new FixDeferFix((InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("FixDeferFix   0")));
            }
            rscExtData = new ExtendedData(rscVarData, this.getOffset(data, 192));
            Resource resource = this.m_file.addResource();
            resource.setAccrueAt(AccrueType.getInstance(MPPUtility.getShort(data, 20)));
            resource.setActualCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 114) / 100.0));
            resource.setActualOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 144) / 100.0));
            resource.setActualWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 62) / 100.0, TimeUnit.HOURS));
            resource.setAvailableFrom(MPPUtility.getTimestamp(data, 28));
            resource.setAvailableTo(MPPUtility.getTimestamp(data, 32));
            resource.setBaselineCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 126) / 100.0));
            resource.setBaselineWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 68) / 100.0, TimeUnit.HOURS));
            resource.setCode(rscExtData.getUnicodeString(RESOURCE_CODE));
            resource.setCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 120) / 100.0));
            resource.setCost(1, NumberUtility.getDouble((double)rscExtData.getLong(RESOURCE_COST1) / 100.0));
            resource.setCost(2, NumberUtility.getDouble((double)rscExtData.getLong(RESOURCE_COST2) / 100.0));
            resource.setCost(3, NumberUtility.getDouble((double)rscExtData.getLong(RESOURCE_COST3) / 100.0));
            resource.setCost(4, NumberUtility.getDouble((double)rscExtData.getLong(RESOURCE_COST4) / 100.0));
            resource.setCost(5, NumberUtility.getDouble((double)rscExtData.getLong(RESOURCE_COST5) / 100.0));
            resource.setCost(6, NumberUtility.getDouble((double)rscExtData.getLong(RESOURCE_COST6) / 100.0));
            resource.setCost(7, NumberUtility.getDouble((double)rscExtData.getLong(RESOURCE_COST7) / 100.0));
            resource.setCost(8, NumberUtility.getDouble((double)rscExtData.getLong(RESOURCE_COST8) / 100.0));
            resource.setCost(9, NumberUtility.getDouble((double)rscExtData.getLong(RESOURCE_COST9) / 100.0));
            resource.setCost(10, NumberUtility.getDouble((double)rscExtData.getLong(RESOURCE_COST10) / 100.0));
            resource.setCostPerUse(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 80) / 100.0));
            resource.setDate(1, rscExtData.getTimestamp(RESOURCE_DATE1));
            resource.setDate(2, rscExtData.getTimestamp(RESOURCE_DATE2));
            resource.setDate(3, rscExtData.getTimestamp(RESOURCE_DATE3));
            resource.setDate(4, rscExtData.getTimestamp(RESOURCE_DATE4));
            resource.setDate(5, rscExtData.getTimestamp(RESOURCE_DATE5));
            resource.setDate(6, rscExtData.getTimestamp(RESOURCE_DATE6));
            resource.setDate(7, rscExtData.getTimestamp(RESOURCE_DATE7));
            resource.setDate(8, rscExtData.getTimestamp(RESOURCE_DATE8));
            resource.setDate(9, rscExtData.getTimestamp(RESOURCE_DATE9));
            resource.setDate(10, rscExtData.getTimestamp(RESOURCE_DATE10));
            resource.setDuration(1, MPPUtility.getDuration(rscExtData.getInt(RESOURCE_DURATION1), MPPUtility.getDurationTimeUnits(rscExtData.getShort(RESOURCE_DURATION1_UNITS))));
            resource.setDuration(2, MPPUtility.getDuration(rscExtData.getInt(RESOURCE_DURATION2), MPPUtility.getDurationTimeUnits(rscExtData.getShort(RESOURCE_DURATION2_UNITS))));
            resource.setDuration(3, MPPUtility.getDuration(rscExtData.getInt(RESOURCE_DURATION3), MPPUtility.getDurationTimeUnits(rscExtData.getShort(RESOURCE_DURATION3_UNITS))));
            resource.setDuration(4, MPPUtility.getDuration(rscExtData.getInt(RESOURCE_DURATION4), MPPUtility.getDurationTimeUnits(rscExtData.getShort(RESOURCE_DURATION4_UNITS))));
            resource.setDuration(5, MPPUtility.getDuration(rscExtData.getInt(RESOURCE_DURATION5), MPPUtility.getDurationTimeUnits(rscExtData.getShort(RESOURCE_DURATION5_UNITS))));
            resource.setDuration(6, MPPUtility.getDuration(rscExtData.getInt(RESOURCE_DURATION6), MPPUtility.getDurationTimeUnits(rscExtData.getShort(RESOURCE_DURATION6_UNITS))));
            resource.setDuration(7, MPPUtility.getDuration(rscExtData.getInt(RESOURCE_DURATION7), MPPUtility.getDurationTimeUnits(rscExtData.getShort(RESOURCE_DURATION7_UNITS))));
            resource.setDuration(8, MPPUtility.getDuration(rscExtData.getInt(RESOURCE_DURATION8), MPPUtility.getDurationTimeUnits(rscExtData.getShort(RESOURCE_DURATION8_UNITS))));
            resource.setDuration(9, MPPUtility.getDuration(rscExtData.getInt(RESOURCE_DURATION9), MPPUtility.getDurationTimeUnits(rscExtData.getShort(RESOURCE_DURATION9_UNITS))));
            resource.setDuration(10, MPPUtility.getDuration(rscExtData.getInt(RESOURCE_DURATION10), MPPUtility.getDurationTimeUnits(rscExtData.getShort(RESOURCE_DURATION10_UNITS))));
            resource.setEmailAddress(rscExtData.getUnicodeString(RESOURCE_EMAIL));
            resource.setFinish(1, rscExtData.getTimestamp(RESOURCE_FINISH1));
            resource.setFinish(2, rscExtData.getTimestamp(RESOURCE_FINISH2));
            resource.setFinish(3, rscExtData.getTimestamp(RESOURCE_FINISH3));
            resource.setFinish(4, rscExtData.getTimestamp(RESOURCE_FINISH4));
            resource.setFinish(5, rscExtData.getTimestamp(RESOURCE_FINISH5));
            resource.setFinish(6, rscExtData.getTimestamp(RESOURCE_FINISH6));
            resource.setFinish(7, rscExtData.getTimestamp(RESOURCE_FINISH7));
            resource.setFinish(8, rscExtData.getTimestamp(RESOURCE_FINISH8));
            resource.setFinish(9, rscExtData.getTimestamp(RESOURCE_FINISH9));
            resource.setFinish(10, rscExtData.getTimestamp(RESOURCE_FINISH10));
            resource.setGroup(rscExtData.getUnicodeString(RESOURCE_GROUP));
            resource.setID(MPPUtility.getInt(data, 4));
            resource.setInitials(rscVarData.getUnicodeString(this.getOffset(data, 160)));
            resource.setMaxUnits(NumberUtility.getDouble((double)MPPUtility.getInt(data, 52) / 100.0));
            resource.setName(rscVarData.getUnicodeString(this.getOffset(data, 156)));
            resource.setNumber(1, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER1)));
            resource.setNumber(2, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER2)));
            resource.setNumber(3, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER3)));
            resource.setNumber(4, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER4)));
            resource.setNumber(5, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER5)));
            resource.setNumber(6, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER6)));
            resource.setNumber(7, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER7)));
            resource.setNumber(8, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER8)));
            resource.setNumber(9, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER9)));
            resource.setNumber(10, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER10)));
            resource.setNumber(11, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER11)));
            resource.setNumber(12, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER12)));
            resource.setNumber(13, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER13)));
            resource.setNumber(14, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER14)));
            resource.setNumber(15, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER15)));
            resource.setNumber(16, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER16)));
            resource.setNumber(17, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER17)));
            resource.setNumber(18, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER18)));
            resource.setNumber(19, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER19)));
            resource.setNumber(20, NumberUtility.getDouble(rscExtData.getDouble(RESOURCE_NUMBER20)));
            resource.setOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 138) / 100.0));
            resource.setOvertimeRate(new Rate(MPPUtility.getDouble(data, 44), TimeUnit.HOURS));
            resource.setOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 74) / 100.0, TimeUnit.HOURS));
            resource.setPeakUnits(NumberUtility.getDouble((double)MPPUtility.getInt(data, 110) / 100.0));
            resource.setRegularWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 92) / 100.0, TimeUnit.HOURS));
            resource.setRemainingCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 132) / 100.0));
            resource.setRemainingOvertimeCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 150) / 100.0));
            resource.setRemainingWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 86) / 100.0, TimeUnit.HOURS));
            resource.setStandardRate(new Rate(MPPUtility.getDouble(data, 36), TimeUnit.HOURS));
            resource.setStart(1, rscExtData.getTimestamp(RESOURCE_START1));
            resource.setStart(2, rscExtData.getTimestamp(RESOURCE_START2));
            resource.setStart(3, rscExtData.getTimestamp(RESOURCE_START3));
            resource.setStart(4, rscExtData.getTimestamp(RESOURCE_START4));
            resource.setStart(5, rscExtData.getTimestamp(RESOURCE_START5));
            resource.setStart(6, rscExtData.getTimestamp(RESOURCE_START6));
            resource.setStart(7, rscExtData.getTimestamp(RESOURCE_START7));
            resource.setStart(8, rscExtData.getTimestamp(RESOURCE_START8));
            resource.setStart(9, rscExtData.getTimestamp(RESOURCE_START9));
            resource.setStart(10, rscExtData.getTimestamp(RESOURCE_START10));
            resource.setText(1, rscExtData.getUnicodeString(RESOURCE_TEXT1));
            resource.setText(2, rscExtData.getUnicodeString(RESOURCE_TEXT2));
            resource.setText(3, rscExtData.getUnicodeString(RESOURCE_TEXT3));
            resource.setText(4, rscExtData.getUnicodeString(RESOURCE_TEXT4));
            resource.setText(5, rscExtData.getUnicodeString(RESOURCE_TEXT5));
            resource.setText(6, rscExtData.getUnicodeString(RESOURCE_TEXT6));
            resource.setText(7, rscExtData.getUnicodeString(RESOURCE_TEXT7));
            resource.setText(8, rscExtData.getUnicodeString(RESOURCE_TEXT8));
            resource.setText(9, rscExtData.getUnicodeString(RESOURCE_TEXT9));
            resource.setText(10, rscExtData.getUnicodeString(RESOURCE_TEXT10));
            resource.setText(11, rscExtData.getUnicodeString(RESOURCE_TEXT11));
            resource.setText(12, rscExtData.getUnicodeString(RESOURCE_TEXT12));
            resource.setText(13, rscExtData.getUnicodeString(RESOURCE_TEXT13));
            resource.setText(14, rscExtData.getUnicodeString(RESOURCE_TEXT14));
            resource.setText(15, rscExtData.getUnicodeString(RESOURCE_TEXT15));
            resource.setText(16, rscExtData.getUnicodeString(RESOURCE_TEXT16));
            resource.setText(17, rscExtData.getUnicodeString(RESOURCE_TEXT17));
            resource.setText(18, rscExtData.getUnicodeString(RESOURCE_TEXT18));
            resource.setText(19, rscExtData.getUnicodeString(RESOURCE_TEXT19));
            resource.setText(20, rscExtData.getUnicodeString(RESOURCE_TEXT20));
            resource.setText(21, rscExtData.getUnicodeString(RESOURCE_TEXT21));
            resource.setText(22, rscExtData.getUnicodeString(RESOURCE_TEXT22));
            resource.setText(23, rscExtData.getUnicodeString(RESOURCE_TEXT23));
            resource.setText(24, rscExtData.getUnicodeString(RESOURCE_TEXT24));
            resource.setText(25, rscExtData.getUnicodeString(RESOURCE_TEXT25));
            resource.setText(26, rscExtData.getUnicodeString(RESOURCE_TEXT26));
            resource.setText(27, rscExtData.getUnicodeString(RESOURCE_TEXT27));
            resource.setText(28, rscExtData.getUnicodeString(RESOURCE_TEXT28));
            resource.setText(29, rscExtData.getUnicodeString(RESOURCE_TEXT29));
            resource.setText(30, rscExtData.getUnicodeString(RESOURCE_TEXT30));
            resource.setUniqueID(id);
            resource.setWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 56) / 100.0, TimeUnit.HOURS));
            ProjectCalendar calendar = this.m_calendarMap.get(MPPUtility.getInt(data, 24));
            resource.setResourceCalendar(calendar);
            String notes = rscExtData.getString(RESOURCE_NOTES);
            if (notes != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    notes = RTFUtility.strip(notes);
                }
                resource.setNotes(notes);
            }
            this.m_file.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        DirectoryEntry assnDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        FixFix assnFixedData = new FixFix(204, (InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("FixFix   0")));
        if (assnFixedData.getDiff() != 0 || assnFixedData.getSize() % 238 == 0 && !this.testAssignmentTasks(assnFixedData)) {
            assnFixedData = new FixFix(238, (InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("FixFix   0")));
        }
        int count = assnFixedData.getItemCount();
        FixDeferFix assnVarData = null;
        for (int loop = 0; loop < count; ++loop) {
            if (assnVarData == null) {
                assnVarData = new FixDeferFix((InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("FixDeferFix   0")));
            }
            byte[] data = assnFixedData.getByteArrayValue(loop);
            Task task = this.m_file.getTaskByUniqueID(MPPUtility.getInt(data, 16));
            Resource resource = this.m_file.getResourceByUniqueID(MPPUtility.getInt(data, 20));
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setActualCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 138) / 100.0));
            assignment.setActualWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 96) / 100.0, TimeUnit.HOURS));
            assignment.setCost(NumberUtility.getDouble((double)MPPUtility.getLong6(data, 132) / 100.0));
            assignment.setFinish(MPPUtility.getTimestamp(data, 28));
            assignment.setOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 90) / 100.0, TimeUnit.HOURS));
            assignment.setRemainingWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 114) / 100.0, TimeUnit.HOURS));
            assignment.setStart(MPPUtility.getTimestamp(data, 24));
            assignment.setUniqueID(MPPUtility.getInt(data, 0));
            assignment.setUnits((double)MPPUtility.getShort(data, 80) / 100.0);
            assignment.setWork(MPPUtility.getDuration((double)MPPUtility.getLong6(data, 84) / 100.0, TimeUnit.HOURS));
            this.m_file.fireAssignmentReadEvent(assignment);
        }
    }

    private boolean testAssignmentTasks(FixFix assnFixedData) {
        boolean result = true;
        int count = assnFixedData.getItemCount();
        for (int loop = 0; loop < count; ++loop) {
            byte[] data = assnFixedData.getByteArrayValue(loop);
            Task task = this.m_file.getTaskByUniqueID(MPPUtility.getInt(data, 16));
            Resource resource = this.m_file.getResourceByUniqueID(MPPUtility.getInt(data, 20));
            if (task != null || resource != null) continue;
            result = false;
            break;
        }
        return result;
    }

    private void processViewData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
        FixFix ff = new FixFix(138, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixFix   0")));
        int items = ff.getItemCount();
        for (int loop = 0; loop < items; ++loop) {
            byte[] data = ff.getByteArrayValue(loop);
            View8 view = new View8(this.m_file, data);
            this.m_file.addView(view);
        }
    }

    private void processTableData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
        FixFix ff = new FixFix(126, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixFix   0")));
        FixDeferFix fdf = new FixDeferFix((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixDeferFix   0")));
        int items = ff.getItemCount();
        StringBuilder sb = new StringBuilder();
        for (int loop = 0; loop < items; ++loop) {
            byte[] data = ff.getByteArrayValue(loop);
            Table table = new Table();
            table.setID(MPPUtility.getInt(data, 0));
            String name = MPPUtility.getUnicodeString(data, 4);
            if (name.indexOf(38) != -1) {
                sb.setLength(0);
                for (int index = 0; index < name.length(); ++index) {
                    char c = name.charAt(index);
                    if (c == '&') continue;
                    sb.append(c);
                }
                name = sb.toString();
            }
            table.setName(MPPUtility.removeAmpersands(name));
            this.m_file.addTable(table);
            byte[] extendedData = fdf.getByteArray(this.getOffset(data, 122));
            if (extendedData == null) continue;
            byte[] columnData = fdf.getByteArray(this.getOffset(extendedData, 8));
            this.processColumnData(table, columnData);
        }
    }

    private void processColumnData(Table table, byte[] data) {
        int columnCount = MPPUtility.getShort(data, 4) + 1;
        int index = 8;
        for (int loop = 0; loop < columnCount; ++loop) {
            int alignment;
            Column column = new Column(this.m_file);
            if (loop == 0) {
                if (MPPUtility.getShort(data, index) == 0) {
                    table.setResourceFlag(true);
                } else {
                    table.setResourceFlag(false);
                }
            }
            if (!table.getResourceFlag()) {
                column.setFieldType(MPPTaskField.getInstance(MPPUtility.getShort(data, index)));
            } else {
                column.setFieldType(MPPResourceField.getInstance(MPPUtility.getShort(data, index)));
            }
            column.setWidth(MPPUtility.getByte(data, index + 4));
            int columnTitleOffset = MPPUtility.getShort(data, index + 6);
            if (columnTitleOffset != 0) {
                column.setTitle(MPPUtility.getUnicodeString(data, columnTitleOffset));
            }
            if ((alignment = MPPUtility.getByte(data, index + 8)) == 32) {
                column.setAlignTitle(1);
            } else if (alignment == 33) {
                column.setAlignTitle(2);
            } else {
                column.setAlignTitle(3);
            }
            alignment = MPPUtility.getByte(data, index + 10);
            if (alignment == 32) {
                column.setAlignData(1);
            } else if (alignment == 33) {
                column.setAlignData(2);
            } else {
                column.setAlignData(3);
            }
            table.addColumn(column);
            index += 12;
        }
    }

    private int getOffset(byte[] data, int offset) {
        return -1 - MPPUtility.getInt(data, offset);
    }
}

