/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.MPPTaskField14;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.mpp.ChartPattern;
import net.sf.mpxj.mpp.GanttBarMiddleShape;
import net.sf.mpxj.mpp.GanttBarShowForTasks;
import net.sf.mpxj.mpp.GanttBarStartEndShape;
import net.sf.mpxj.mpp.GanttBarStartEndType;
import net.sf.mpxj.mpp.GanttBarStyle;
import net.sf.mpxj.mpp.GanttBarStyleException;
import net.sf.mpxj.mpp.GanttBarStyleFactory;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;

public class GanttBarStyleFactory14
implements GanttBarStyleFactory {
    private static final Integer DEFAULT_PROPERTIES = 574619656;
    private static final Integer EXCEPTION_PROPERTIES = 574619661;

    @Override
    public GanttBarStyle[] processDefaultStyles(Props props) {
        int barStyleCount;
        GanttBarStyle[] barStyles = null;
        byte[] barStyleData = props.getByteArray(DEFAULT_PROPERTIES);
        if (barStyleData != null && (barStyleCount = MPPUtility.getByte(barStyleData, 2243)) > 0 && barStyleCount < 65535) {
            barStyles = new GanttBarStyle[barStyleCount];
            int styleOffset = 2255;
            for (int loop = 0; loop < barStyleCount; ++loop) {
                GanttBarStyle style;
                barStyles[loop] = style = new GanttBarStyle();
                style.setName(MPPUtility.getUnicodeString(barStyleData, styleOffset + 91));
                style.setLeftText(this.getTaskField(MPPUtility.getShort(barStyleData, styleOffset + 67)));
                style.setRightText(this.getTaskField(MPPUtility.getShort(barStyleData, styleOffset + 71)));
                style.setTopText(this.getTaskField(MPPUtility.getShort(barStyleData, styleOffset + 75)));
                style.setBottomText(this.getTaskField(MPPUtility.getShort(barStyleData, styleOffset + 79)));
                style.setInsideText(this.getTaskField(MPPUtility.getShort(barStyleData, styleOffset + 83)));
                style.setStartShape(GanttBarStartEndShape.getInstance(barStyleData[styleOffset + 15] % 25));
                style.setStartType(GanttBarStartEndType.getInstance(barStyleData[styleOffset + 15] / 25));
                style.setStartColor(MPPUtility.getColor(barStyleData, styleOffset + 16));
                style.setMiddleShape(GanttBarMiddleShape.getInstance(barStyleData[styleOffset]));
                style.setMiddlePattern(ChartPattern.getInstance(barStyleData[styleOffset + 1]));
                style.setMiddleColor(MPPUtility.getColor(barStyleData, styleOffset + 2));
                style.setEndShape(GanttBarStartEndShape.getInstance(barStyleData[styleOffset + 28] % 25));
                style.setEndType(GanttBarStartEndType.getInstance(barStyleData[styleOffset + 28] / 25));
                style.setEndColor(MPPUtility.getColor(barStyleData, styleOffset + 29));
                style.setFromField(this.getTaskField(MPPUtility.getShort(barStyleData, styleOffset + 41)));
                style.setToField(this.getTaskField(MPPUtility.getShort(barStyleData, styleOffset + 45)));
                this.extractFlags(style, GanttBarShowForTasks.NORMAL, MPPUtility.getLong(barStyleData, styleOffset + 49));
                this.extractFlags(style, GanttBarShowForTasks.NOT_NORMAL, MPPUtility.getLong(barStyleData, styleOffset + 57));
                style.setRow(MPPUtility.getShort(barStyleData, styleOffset + 65) + 1);
                styleOffset += 195;
            }
        }
        return barStyles;
    }

    @Override
    public GanttBarStyleException[] processExceptionStyles(Props props) {
        GanttBarStyleException[] barStyle = null;
        byte[] barData = props.getByteArray(EXCEPTION_PROPERTIES);
        if (barData != null) {
            barStyle = new GanttBarStyleException[barData.length / 71];
            int offset = 0;
            for (int loop = 0; loop < barStyle.length; ++loop) {
                GanttBarStyleException style;
                barStyle[loop] = style = new GanttBarStyleException();
                style.setTaskUniqueID(MPPUtility.getInt(barData, offset));
                style.setBarStyleIndex(MPPUtility.getShort(barData, offset + 4) - 1);
                style.setStartShape(GanttBarStartEndShape.getInstance(barData[offset + 20] % 25));
                style.setStartType(GanttBarStartEndType.getInstance(barData[offset + 20] / 25));
                style.setStartColor(MPPUtility.getColor(barData, offset + 21));
                style.setMiddleShape(GanttBarMiddleShape.getInstance(barData[offset + 6]));
                style.setMiddlePattern(ChartPattern.getInstance(barData[offset + 7]));
                style.setMiddleColor(MPPUtility.getColor(barData, offset + 8));
                style.setEndShape(GanttBarStartEndShape.getInstance(barData[offset + 33] % 25));
                style.setEndType(GanttBarStartEndType.getInstance(barData[offset + 33] / 25));
                style.setEndColor(MPPUtility.getColor(barData, offset + 34));
                style.setLeftText(this.getTaskField(MPPUtility.getShort(barData, offset + 49)));
                style.setRightText(this.getTaskField(MPPUtility.getShort(barData, offset + 53)));
                style.setTopText(this.getTaskField(MPPUtility.getShort(barData, offset + 57)));
                style.setBottomText(this.getTaskField(MPPUtility.getShort(barData, offset + 61)));
                style.setInsideText(this.getTaskField(MPPUtility.getShort(barData, offset + 65)));
                offset += 71;
            }
        }
        return barStyle;
    }

    private void extractFlags(GanttBarStyle style, GanttBarShowForTasks baseCriteria, long flagValue) {
        long flag = 1L;
        for (int index = 0; index < 64; ++index) {
            GanttBarShowForTasks enumValue;
            if ((flagValue & flag) != 0L && (enumValue = GanttBarShowForTasks.getInstance(baseCriteria.getValue() + index)) != null) {
                style.addShowForTasks(enumValue);
            }
            flag <<= 1;
        }
    }

    private TaskField getTaskField(int field) {
        TaskField result = MPPTaskField14.getInstance(field);
        if (result != null) {
            switch (result) {
                case START_TEXT: {
                    result = TaskField.START;
                    break;
                }
                case FINISH_TEXT: {
                    result = TaskField.FINISH;
                    break;
                }
                case DURATION_TEXT: {
                    result = TaskField.DURATION;
                    break;
                }
            }
        }
        return result;
    }
}

