/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.utility.NumberUtility;

abstract class FieldMap {
    private ProjectFile m_file;
    protected TimeUnit m_defaultProjectTimeUnits;
    private Map<FieldType, FieldItem> m_map = new HashMap<FieldType, FieldItem>();
    private int[] m_maxFixedDataOffset = new int[2];
    private static final Integer[] TASK_KEYS = new Integer[]{Props.TASK_FIELD_MAP, Props.TASK_FIELD_MAP2};
    private static final Integer[] ENTERPRISE_CUSTOM_KEYS = new Integer[]{Props.ENTERPRISE_CUSTOM_FIELD_MAP};
    private static final Integer[] RESOURCE_KEYS = new Integer[]{Props.RESOURCE_FIELD_MAP, Props.RESOURCE_FIELD_MAP2};
    private static final Integer[] ASSIGNMENT_KEYS = new Integer[]{Props.ASSIGNMENT_FIELD_MAP, Props.ASSIGNMENT_FIELD_MAP2};
    private static final int VALUE_LIST_MASK = 1792;
    private static final int MAX_FIXED_DATA_BLOCKS = 2;

    public FieldMap(ProjectFile file) {
        this.m_file = file;
        this.m_defaultProjectTimeUnits = this.m_file.getProjectHeader().getDefaultDurationUnits();
    }

    private void createFieldMap(byte[] data) {
        int lastDataBlockOffset = 0;
        int dataBlockIndex = 0;
        for (int index = 0; index < data.length; index += 28) {
            int varDataKey;
            FieldType type = this.getFieldType(MPPUtility.getInt(data, index + 12));
            int dataBlockOffset = MPPUtility.getShort(data, index + 4);
            int mask = MPPUtility.getInt(data, index + 0);
            if (this.useTypeAsVarDataKey()) {
                Integer substitute = this.substituteVarDataKey(type);
                if (substitute == null) {
                    varDataKey = MPPUtility.getInt(data, index + 12) & 0xFFFF;
                } else {
                    varDataKey = substitute;
                    mask = 0;
                }
            } else {
                varDataKey = MPPUtility.getByte(data, index + 6);
            }
            FieldLocation location = dataBlockOffset != 65535 ? FieldLocation.FIXED_DATA : (mask != 0 ? FieldLocation.META_DATA : (varDataKey != 0 ? FieldLocation.VAR_DATA : FieldLocation.UNKNOWN));
            if (location == FieldLocation.FIXED_DATA) {
                if (dataBlockOffset < lastDataBlockOffset) {
                    ++dataBlockIndex;
                }
                lastDataBlockOffset = dataBlockOffset;
                if (dataBlockOffset > this.m_maxFixedDataOffset[dataBlockIndex]) {
                    this.m_maxFixedDataOffset[dataBlockIndex] = dataBlockOffset;
                }
            }
            if (type == null) continue;
            this.m_map.put(type, new FieldItem(type, location, dataBlockIndex, dataBlockOffset, varDataKey));
        }
    }

    protected abstract boolean useTypeAsVarDataKey();

    protected abstract FieldItem[] getDefaultTaskData();

    protected abstract FieldItem[] getDefaultResourceData();

    protected abstract FieldItem[] getDefaultAssignmentData();

    protected abstract FieldType getFieldType(int var1);

    protected abstract Integer substituteVarDataKey(FieldType var1);

    public void createTaskFieldMap(Props props) {
        Integer key;
        byte[] fieldMapData = null;
        Integer[] arr$ = TASK_KEYS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (fieldMapData = props.getByteArray(key = arr$[i$])) == null; ++i$) {
        }
        if (fieldMapData == null) {
            this.populateDefaultData(this.getDefaultTaskData());
        } else {
            this.createFieldMap(fieldMapData);
        }
    }

    public void createEnterpriseCustomFieldMap(Props props, Class<?> c) {
        Integer key;
        byte[] fieldMapData = null;
        Integer[] arr$ = ENTERPRISE_CUSTOM_KEYS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (fieldMapData = props.getByteArray(key = arr$[i$])) == null; ++i$) {
        }
        if (fieldMapData != null) {
            for (int index = 4; index < fieldMapData.length; index += 4) {
                int typeValue = MPPUtility.getInt(fieldMapData, index);
                FieldType type = this.getFieldType(typeValue);
                if (type == null || type.getClass() != c || !type.toString().startsWith("Enterprise Custom Field")) continue;
                int varDataKey = typeValue & 0xFFFF;
                this.m_map.put(type, new FieldItem(type, FieldLocation.VAR_DATA, 0, 0, varDataKey));
            }
        }
    }

    public void createResourceFieldMap(Props props) {
        Integer key;
        byte[] fieldMapData = null;
        Integer[] arr$ = RESOURCE_KEYS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (fieldMapData = props.getByteArray(key = arr$[i$])) == null; ++i$) {
        }
        if (fieldMapData == null) {
            this.populateDefaultData(this.getDefaultResourceData());
        } else {
            this.createFieldMap(fieldMapData);
        }
    }

    public void createAssignmentFieldMap(Props props) {
        Integer key;
        byte[] fieldMapData = null;
        Integer[] arr$ = ASSIGNMENT_KEYS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (fieldMapData = props.getByteArray(key = arr$[i$])) == null; ++i$) {
        }
        if (fieldMapData == null) {
            this.populateDefaultData(this.getDefaultAssignmentData());
        } else {
            this.createFieldMap(fieldMapData);
        }
    }

    private void populateDefaultData(FieldItem[] defaultData) {
        for (FieldItem item : defaultData) {
            this.m_map.put(item.getType(), item);
        }
    }

    public void populateContainer(FieldContainer container, Integer id, byte[][] fixedData, Var2Data varData) {
        for (FieldItem item : this.m_map.values()) {
            Object value = item.read(id, fixedData, varData);
            container.set(item.getType(), value);
        }
    }

    public int getMaxFixedDataOffset(int blockIndex) {
        return this.m_maxFixedDataOffset[blockIndex];
    }

    public int getFixedDataOffset(FieldType type) {
        FieldItem item = this.m_map.get(type);
        int result = item != null ? item.getFixedDataOffset() : -1;
        return result;
    }

    public Integer getVarDataKey(FieldType type) {
        Integer result = null;
        FieldItem item = this.m_map.get(type);
        if (item != null) {
            result = item.getVarDataKey();
        }
        return result;
    }

    public FieldType getFieldTypeFromVarDataKey(Integer key) {
        FieldType result = null;
        for (Map.Entry<FieldType, FieldItem> entry : this.m_map.entrySet()) {
            if (entry.getValue().getFieldLocation() != FieldLocation.VAR_DATA || !entry.getValue().getVarDataKey().equals(key)) continue;
            result = entry.getKey();
            break;
        }
        return result;
    }

    public FieldLocation getFieldLocation(FieldType type) {
        FieldLocation result = null;
        FieldItem item = this.m_map.get(type);
        if (item != null) {
            result = item.getFieldLocation();
        }
        return result;
    }

    protected Object getFieldData(Integer id, FieldType type, byte[][] fixedData, Var2Data varData) {
        Object result = null;
        FieldItem item = this.m_map.get(type);
        if (item != null) {
            result = item.read(id, fixedData, varData);
        }
        return result;
    }

    protected ProjectFile getProjectFile() {
        return this.m_file;
    }

    public void clear() {
        this.m_map.clear();
        Arrays.fill(this.m_maxFixedDataOffset, 0);
    }

    public void dumpKnownFieldMaps(Props props) {
        for (int key = 50331668; key < 50331674; ++key) {
            byte[] fieldMapData = props.getByteArray(key);
            if (fieldMapData == null) continue;
            System.out.println("KEY: " + key);
            this.createFieldMap(fieldMapData);
            System.out.println(this.toString());
            this.clear();
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ArrayList<FieldItem> items = new ArrayList<FieldItem>(this.m_map.values());
        Collections.sort(items);
        pw.println("[FieldMap");
        for (int loop = 0; loop < this.m_maxFixedDataOffset.length; ++loop) {
            pw.print(" MaxFixedOffset (block ");
            pw.print(loop);
            pw.print(")=");
            pw.println(this.m_maxFixedDataOffset[loop]);
        }
        for (FieldItem item : items) {
            pw.print(" ");
            pw.println(item);
        }
        pw.println("]");
        pw.close();
        return sw.toString();
    }

    public class FieldItem
    implements Comparable<FieldItem> {
        private FieldType m_type;
        private FieldLocation m_location;
        private int m_fixedDataBlockIndex;
        private int m_fixedDataOffset;
        private Integer m_varDataKey;

        FieldItem(FieldType type, FieldLocation location, int fixedDataBlockIndex, int fixedDataOffset, int varDataKey) {
            this.m_type = type;
            this.m_location = location;
            this.m_fixedDataBlockIndex = fixedDataBlockIndex;
            this.m_fixedDataOffset = fixedDataOffset;
            this.m_varDataKey = varDataKey;
        }

        public Object read(Integer id, byte[][] fixedData, Var2Data varData) {
            Object result = null;
            switch (this.m_location) {
                case FIXED_DATA: {
                    result = this.readFixedData(id, fixedData, varData);
                    break;
                }
                case VAR_DATA: {
                    result = this.readVarData(id, fixedData, varData);
                    break;
                }
                case META_DATA: {
                    break;
                }
            }
            return result;
        }

        private Object readFixedData(Integer id, byte[][] fixedData, Var2Data varData) {
            byte[] data;
            Object result = null;
            if (this.m_fixedDataBlockIndex < fixedData.length && (data = fixedData[this.m_fixedDataBlockIndex]) != null && this.m_fixedDataOffset < data.length) {
                switch (this.m_type.getDataType()) {
                    case DATE: {
                        result = MPPUtility.getTimestamp(data, this.m_fixedDataOffset);
                        break;
                    }
                    case INTEGER: {
                        result = MPPUtility.getInt(data, this.m_fixedDataOffset);
                        break;
                    }
                    case DURATION: {
                        FieldType unitsType = this.m_type.getUnitsType();
                        TimeUnit units = (TimeUnit)FieldMap.this.getFieldData(id, unitsType, fixedData, varData);
                        if (units == null) {
                            units = FieldMap.this.getProjectFile().getProjectHeader().getDefaultDurationUnits();
                        }
                        result = MPPUtility.getAdjustedDuration(FieldMap.this.getProjectFile(), MPPUtility.getInt(data, this.m_fixedDataOffset), units);
                        break;
                    }
                    case TIME_UNITS: {
                        result = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, this.m_fixedDataOffset), FieldMap.this.m_defaultProjectTimeUnits);
                        break;
                    }
                    case CONSTRAINT: {
                        result = ConstraintType.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case PRIORITY: {
                        result = Priority.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case PERCENTAGE: {
                        result = MPPUtility.getPercentage(data, this.m_fixedDataOffset);
                        break;
                    }
                    case TASK_TYPE: {
                        result = TaskType.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case ACCRUE: {
                        result = AccrueType.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case CURRENCY: 
                    case UNITS: {
                        result = NumberUtility.getDouble(MPPUtility.getDouble(data, this.m_fixedDataOffset) / 100.0);
                        break;
                    }
                    case RATE: {
                        result = new Rate(MPPUtility.getDouble(data, this.m_fixedDataOffset), TimeUnit.HOURS);
                        break;
                    }
                    case WORK: {
                        result = Duration.getInstance(MPPUtility.getDouble(data, this.m_fixedDataOffset) / 60000.0, TimeUnit.HOURS);
                        break;
                    }
                    case SHORT: {
                        result = MPPUtility.getShort(data, this.m_fixedDataOffset);
                        break;
                    }
                    case BOOLEAN: {
                        result = MPPUtility.getShort(data, this.m_fixedDataOffset) != 0;
                        break;
                    }
                    case DELAY: {
                        result = MPPUtility.getDuration(MPPUtility.getShort(data, this.m_fixedDataOffset), TimeUnit.HOURS);
                        break;
                    }
                    case WORK_UNITS: {
                        int variableRateUnitsValue = MPPUtility.getByte(data, this.m_fixedDataOffset);
                        result = variableRateUnitsValue == 0 ? null : MPPUtility.getWorkTimeUnits(variableRateUnitsValue);
                        break;
                    }
                    case WORKGROUP: {
                        result = WorkGroup.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case RATE_UNITS: {
                        result = TimeUnit.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset) - 1);
                        break;
                    }
                    case GUID: {
                        result = MPPUtility.getGUID(data, this.m_fixedDataOffset);
                        break;
                    }
                }
            }
            return result;
        }

        private Object readVarData(Integer id, byte[][] fixedData, Var2Data varData) {
            Object result = null;
            switch (this.m_type.getDataType()) {
                case DURATION: {
                    FieldType unitsType = this.m_type.getUnitsType();
                    TimeUnit units = (TimeUnit)FieldMap.this.getFieldData(id, unitsType, fixedData, varData);
                    if (units == null) {
                        units = TimeUnit.HOURS;
                    }
                    result = this.getCustomFieldDurationValue(varData, id, this.m_varDataKey, units);
                    break;
                }
                case TIME_UNITS: {
                    result = MPPUtility.getDurationTimeUnits(varData.getShort(id, this.m_varDataKey), FieldMap.this.m_defaultProjectTimeUnits);
                    break;
                }
                case CURRENCY: {
                    result = NumberUtility.getDouble(varData.getDouble(id, this.m_varDataKey) / 100.0);
                    break;
                }
                case STRING: {
                    result = this.getCustomFieldUnicodeStringValue(varData, id, this.m_varDataKey);
                    break;
                }
                case DATE: {
                    result = this.getCustomFieldTimestampValue(varData, id, this.m_varDataKey);
                    break;
                }
                case NUMERIC: {
                    result = this.getCustomFieldDoubleValue(varData, id, this.m_varDataKey);
                    break;
                }
                case INTEGER: {
                    result = varData.getInt(id, this.m_varDataKey);
                    break;
                }
                case WORK: {
                    result = Duration.getInstance(varData.getDouble(id, this.m_varDataKey) / 60000.0, TimeUnit.HOURS);
                    break;
                }
                case ASCII_STRING: {
                    result = varData.getString(id, this.m_varDataKey);
                    break;
                }
                case DELAY: {
                    result = MPPUtility.getDuration(varData.getShort(id, this.m_varDataKey), TimeUnit.HOURS);
                    break;
                }
                case WORK_UNITS: {
                    int variableRateUnitsValue = varData.getByte(id, this.m_varDataKey);
                    result = variableRateUnitsValue == 0 ? null : MPPUtility.getWorkTimeUnits(variableRateUnitsValue);
                    break;
                }
                case RATE_UNITS: {
                    result = TimeUnit.getInstance(varData.getShort(id, this.m_varDataKey) - 1);
                    break;
                }
                case ACCRUE: {
                    result = AccrueType.getInstance(varData.getShort(id, this.m_varDataKey));
                    break;
                }
                case SHORT: {
                    result = varData.getShort(id, this.m_varDataKey);
                    break;
                }
                case BOOLEAN: {
                    result = varData.getShort(id, this.m_varDataKey) != 0;
                    break;
                }
                case WORKGROUP: {
                    result = WorkGroup.getInstance(varData.getShort(id, this.m_varDataKey));
                    break;
                }
                case GUID: {
                    result = MPPUtility.getGUID(varData.getByteArray(id, this.m_varDataKey), 0);
                    break;
                }
                case BINARY: {
                    break;
                }
            }
            return result;
        }

        private Object getCustomFieldTimestampValue(Var2Data varData, Integer id, Integer type) {
            Object result = null;
            int mask = varData.getShort(id, type);
            if ((mask & 0xFF00) != 1792) {
                byte[] data = varData.getByteArray(id, type);
                if (data != null) {
                    if (data.length == 512) {
                        result = MPPUtility.getUnicodeString(data);
                    } else if (data.length >= 4) {
                        result = MPPUtility.getTimestamp(data);
                    }
                }
            } else {
                int uniqueId = varData.getInt(id, 2, type);
                CustomFieldValueItem item = FieldMap.this.getProjectFile().getCustomFieldValueItem(uniqueId);
                if (item != null && item.getValue() != null) {
                    result = MPPUtility.getTimestamp(item.getValue());
                }
            }
            return result;
        }

        private Object getCustomFieldDurationValue(Var2Data varData, Integer id, Integer type, TimeUnit units) {
            Object result = null;
            byte[] data = varData.getByteArray(id, type);
            if (data != null) {
                if (data.length == 512) {
                    result = MPPUtility.getUnicodeString(data);
                } else if (data.length >= 4) {
                    int duration = MPPUtility.getInt(data);
                    result = MPPUtility.getAdjustedDuration(FieldMap.this.getProjectFile(), duration, units);
                }
            }
            return result;
        }

        private Double getCustomFieldDoubleValue(Var2Data varData, Integer id, Integer type) {
            double result = 0.0;
            int mask = varData.getShort(id, type);
            if ((mask & 0xFF00) != 1792) {
                result = varData.getDouble(id, type);
            } else {
                int uniqueId = varData.getInt(id, 2, type);
                CustomFieldValueItem item = FieldMap.this.getProjectFile().getCustomFieldValueItem(uniqueId);
                if (item != null && item.getValue() != null) {
                    result = MPPUtility.getDouble(item.getValue());
                }
            }
            return NumberUtility.getDouble(result);
        }

        private String getCustomFieldUnicodeStringValue(Var2Data varData, Integer id, Integer type) {
            String result = null;
            int mask = varData.getShort(id, type);
            if ((mask & 0xFF00) != 1792) {
                result = varData.getUnicodeString(id, type);
            } else {
                int uniqueId = varData.getInt(id, 2, type);
                CustomFieldValueItem item = FieldMap.this.getProjectFile().getCustomFieldValueItem(uniqueId);
                if (item != null && item.getValue() != null) {
                    result = MPPUtility.getUnicodeString(item.getValue());
                }
            }
            return result;
        }

        public FieldType getType() {
            return this.m_type;
        }

        public int getFixedDataBlockIndex() {
            return this.m_fixedDataBlockIndex;
        }

        public int getFixedDataOffset() {
            return this.m_fixedDataOffset;
        }

        public Integer getVarDataKey() {
            return this.m_varDataKey;
        }

        public FieldLocation getFieldLocation() {
            return this.m_location;
        }

        @Override
        public int compareTo(FieldItem item) {
            int result = this.m_location.compareTo(item.m_location);
            if (result == 0) {
                switch (this.m_location) {
                    case FIXED_DATA: {
                        result = this.m_fixedDataBlockIndex - item.m_fixedDataBlockIndex;
                        if (result != 0) break;
                        result = this.m_fixedDataOffset - item.m_fixedDataOffset;
                        break;
                    }
                    case VAR_DATA: {
                        result = this.m_varDataKey - item.m_varDataKey;
                        break;
                    }
                }
            }
            return result;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[FieldItem type=");
            buffer.append(this.m_type);
            buffer.append(" location=");
            buffer.append((Object)this.m_location);
            switch (this.m_location) {
                case FIXED_DATA: {
                    buffer.append(" fixedDataBlockIndex=");
                    buffer.append(this.m_fixedDataBlockIndex);
                    buffer.append(" fixedDataBlockOffset=");
                    buffer.append(this.m_fixedDataOffset);
                    break;
                }
                case VAR_DATA: {
                    buffer.append(" varDataKey=");
                    buffer.append(this.m_varDataKey);
                    break;
                }
            }
            buffer.append("]");
            return buffer.toString();
        }
    }

    static enum FieldLocation {
        FIXED_DATA,
        VAR_DATA,
        META_DATA,
        UNKNOWN;

    }
}

