/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.List;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class MppResourceTest
extends MPXJTestCase {
    public void testMpp9Resource() throws Exception {
        MPPReader reader = new MPPReader();
        reader.setPreserveNoteFormatting(false);
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp9resource.mpp");
        this.testResources(mpp);
        this.testNotes(mpp);
        this.testResourceAssignments(mpp);
        this.testResourceOutlineCodes(mpp);
    }

    public void testMpp9ResourceFrom12() throws Exception {
        MPPReader reader = new MPPReader();
        reader.setPreserveNoteFormatting(false);
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp9resource-from12.mpp");
        this.testResources(mpp);
        this.testNotes(mpp);
        this.testResourceAssignments(mpp);
        this.testResourceOutlineCodes(mpp);
    }

    public void testMpp9ResourceFrom14() throws Exception {
        MPPReader reader = new MPPReader();
        reader.setPreserveNoteFormatting(false);
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp9resource-from14.mpp");
        this.testResources(mpp);
        this.testNotes(mpp);
        this.testResourceAssignments(mpp);
        this.testResourceOutlineCodes(mpp);
    }

    public void testMpp12Resource() throws Exception {
        MPPReader reader = new MPPReader();
        reader.setPreserveNoteFormatting(false);
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp12resource.mpp");
        this.testResources(mpp);
        this.testNotes(mpp);
        this.testResourceAssignments(mpp);
        this.testResourceOutlineCodes(mpp);
    }

    public void testMpp12ResourceFrom14() throws Exception {
        MPPReader reader = new MPPReader();
        reader.setPreserveNoteFormatting(false);
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp12resource-from14.mpp");
        this.testResources(mpp);
        this.testNotes(mpp);
        this.testResourceAssignments(mpp);
        this.testResourceOutlineCodes(mpp);
    }

    public void testMpp14Resource() throws Exception {
        MPPReader reader = new MPPReader();
        reader.setPreserveNoteFormatting(false);
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp14resource.mpp");
        this.testResources(mpp);
        this.testNotes(mpp);
        this.testResourceAssignments(mpp);
        this.testResourceOutlineCodes(mpp);
    }

    public void testMspdiResource() throws Exception {
        MSPDIReader reader = new MSPDIReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mspdiresource.xml");
        this.testResources(mpp);
        this.testNotes(mpp);
        this.testResourceAssignments(mpp);
    }

    public void testMpd9Resource() throws Exception {
        block2: {
            try {
                MPDDatabaseReader reader = new MPDDatabaseReader();
                reader.setPreserveNoteFormatting(false);
                ProjectFile mpp = reader.read(this.m_basedir + "/mpp9resource.mpd");
                this.testResources(mpp);
                this.testNotes(mpp);
                this.testResourceAssignments(mpp);
                this.testResourceOutlineCodes(mpp);
            }
            catch (Exception ex) {
                if (this.m_ikvm) break block2;
                throw ex;
            }
        }
    }

    private void testResources(ProjectFile mpp) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        List<Resource> listAllResources = mpp.getAllResources();
        MppResourceTest.assertTrue((listAllResources != null ? 1 : 0) != 0);
        Resource resourceWade = mpp.getResourceByID(1);
        Resource resourceJon = mpp.getResourceByID(2);
        Resource resourceBrian = mpp.getResourceByID(3);
        Resource resourceConcrete = mpp.getResourceByID(4);
        MppResourceTest.assertEquals((String)"Wade Golden", (String)resourceWade.getName());
        MppResourceTest.assertEquals((String)"Jon Iles", (String)resourceJon.getName());
        MppResourceTest.assertEquals((String)"Brian Leach", (String)resourceBrian.getName());
        MppResourceTest.assertEquals((String)"Concrete", (String)resourceConcrete.getName());
        MppResourceTest.assertEquals((Object)ResourceType.WORK, (Object)resourceWade.getType());
        MppResourceTest.assertEquals((Object)ResourceType.MATERIAL, (Object)resourceConcrete.getType());
        MppResourceTest.assertEquals((String)"WG", (String)resourceWade.getInitials());
        MppResourceTest.assertEquals((String)"Steelray", (String)resourceWade.getGroup());
        MppResourceTest.assertEquals((String)"Tapsterrock", (String)resourceJon.getGroup());
        MppResourceTest.assertEquals((String)"Steelray", (String)resourceBrian.getGroup());
        MppResourceTest.assertEquals((String)"Mat", (String)resourceConcrete.getGroup());
        MppResourceTest.assertEquals((Object)100.0, (Object)resourceWade.getMaxUnits());
        Rate rate = new Rate(50.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceWade.getStandardRate());
        rate = new Rate(75.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceJon.getStandardRate());
        rate = new Rate(100.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceBrian.getStandardRate());
        rate = new Rate(100.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceWade.getOvertimeRate());
        rate = new Rate(150.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceJon.getOvertimeRate());
        rate = new Rate(200.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceBrian.getOvertimeRate());
        MppResourceTest.assertEquals((Object)500.0, (Object)resourceConcrete.getCostPerUse());
        MppResourceTest.assertEquals((Object)AccrueType.END, (Object)resourceWade.getAccrueAt());
        MppResourceTest.assertEquals((Object)AccrueType.PRORATED, (Object)resourceJon.getAccrueAt());
        MppResourceTest.assertEquals((Object)AccrueType.START, (Object)resourceConcrete.getAccrueAt());
        MppResourceTest.assertEquals((String)"10", (String)resourceWade.getCode());
        MppResourceTest.assertEquals((String)"20", (String)resourceJon.getCode());
        MppResourceTest.assertEquals((String)"30", (String)resourceBrian.getCode());
        MppResourceTest.assertEquals((int)1, (int)resourceWade.getCost(1).intValue());
        MppResourceTest.assertEquals((int)2, (int)resourceWade.getCost(2).intValue());
        MppResourceTest.assertEquals((int)3, (int)resourceWade.getCost(3).intValue());
        MppResourceTest.assertEquals((int)4, (int)resourceWade.getCost(4).intValue());
        MppResourceTest.assertEquals((int)5, (int)resourceWade.getCost(5).intValue());
        MppResourceTest.assertEquals((int)6, (int)resourceWade.getCost(6).intValue());
        MppResourceTest.assertEquals((int)7, (int)resourceWade.getCost(7).intValue());
        MppResourceTest.assertEquals((int)8, (int)resourceWade.getCost(8).intValue());
        MppResourceTest.assertEquals((int)9, (int)resourceWade.getCost(9).intValue());
        MppResourceTest.assertEquals((int)10, (int)resourceWade.getCost(10).intValue());
        MppResourceTest.assertEquals((String)"wade.golden@steelray.com", (String)resourceWade.getEmailAddress());
        MppResourceTest.assertEquals((String)"01/01/2006", (String)df.format(resourceWade.getDate(1)));
        MppResourceTest.assertEquals((String)"02/01/2006", (String)df.format(resourceWade.getDate(2)));
        MppResourceTest.assertEquals((String)"03/01/2006", (String)df.format(resourceWade.getDate(3)));
        MppResourceTest.assertEquals((String)"04/01/2006", (String)df.format(resourceWade.getDate(4)));
        MppResourceTest.assertEquals((String)"05/01/2006", (String)df.format(resourceWade.getDate(5)));
        MppResourceTest.assertEquals((String)"06/01/2006", (String)df.format(resourceWade.getDate(6)));
        MppResourceTest.assertEquals((String)"07/01/2006", (String)df.format(resourceWade.getDate(7)));
        MppResourceTest.assertEquals((String)"08/01/2006", (String)df.format(resourceWade.getDate(8)));
        MppResourceTest.assertEquals((String)"09/01/2006", (String)df.format(resourceWade.getDate(9)));
        MppResourceTest.assertEquals((String)"10/01/2006", (String)df.format(resourceWade.getDate(10)));
        MppResourceTest.assertEquals((String)"01/02/2006", (String)df.format(resourceWade.getStart(1)));
        MppResourceTest.assertEquals((String)"02/02/2006", (String)df.format(resourceWade.getStart(2)));
        MppResourceTest.assertEquals((String)"03/02/2006", (String)df.format(resourceWade.getStart(3)));
        MppResourceTest.assertEquals((String)"04/02/2006", (String)df.format(resourceWade.getStart(4)));
        MppResourceTest.assertEquals((String)"05/02/2006", (String)df.format(resourceWade.getStart(5)));
        MppResourceTest.assertEquals((String)"06/02/2006", (String)df.format(resourceWade.getStart(6)));
        MppResourceTest.assertEquals((String)"07/02/2006", (String)df.format(resourceWade.getStart(7)));
        MppResourceTest.assertEquals((String)"08/02/2006", (String)df.format(resourceWade.getStart(8)));
        MppResourceTest.assertEquals((String)"09/02/2006", (String)df.format(resourceWade.getStart(9)));
        MppResourceTest.assertEquals((String)"10/02/2006", (String)df.format(resourceWade.getStart(10)));
        MppResourceTest.assertEquals((String)"01/03/2006", (String)df.format(resourceWade.getFinish(1)));
        MppResourceTest.assertEquals((String)"02/03/2006", (String)df.format(resourceWade.getFinish(2)));
        MppResourceTest.assertEquals((String)"03/03/2006", (String)df.format(resourceWade.getFinish(3)));
        MppResourceTest.assertEquals((String)"04/03/2006", (String)df.format(resourceWade.getFinish(4)));
        MppResourceTest.assertEquals((String)"05/03/2006", (String)df.format(resourceWade.getFinish(5)));
        MppResourceTest.assertEquals((String)"06/03/2006", (String)df.format(resourceWade.getFinish(6)));
        MppResourceTest.assertEquals((String)"07/03/2006", (String)df.format(resourceWade.getFinish(7)));
        MppResourceTest.assertEquals((String)"08/03/2006", (String)df.format(resourceWade.getFinish(8)));
        MppResourceTest.assertEquals((String)"09/03/2006", (String)df.format(resourceWade.getFinish(9)));
        MppResourceTest.assertEquals((String)"10/03/2006", (String)df.format(resourceWade.getFinish(10)));
        MppResourceTest.assertEquals((int)1, (int)((int)resourceWade.getDuration(1).getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration(1).getUnits());
        MppResourceTest.assertEquals((int)2, (int)((int)resourceWade.getDuration(2).getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration(2).getUnits());
        MppResourceTest.assertEquals((int)3, (int)((int)resourceWade.getDuration(3).getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration(3).getUnits());
        MppResourceTest.assertEquals((int)4, (int)((int)resourceWade.getDuration(4).getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration(4).getUnits());
        MppResourceTest.assertEquals((int)5, (int)((int)resourceWade.getDuration(5).getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration(5).getUnits());
        MppResourceTest.assertEquals((int)6, (int)((int)resourceWade.getDuration(6).getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration(6).getUnits());
        MppResourceTest.assertEquals((int)7, (int)((int)resourceWade.getDuration(7).getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration(7).getUnits());
        MppResourceTest.assertEquals((int)8, (int)((int)resourceWade.getDuration(8).getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration(8).getUnits());
        MppResourceTest.assertEquals((int)9, (int)((int)resourceWade.getDuration(9).getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration(9).getUnits());
        MppResourceTest.assertEquals((int)10, (int)((int)resourceWade.getDuration(10).getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration(10).getUnits());
        MppResourceTest.assertEquals((int)1, (int)resourceWade.getNumber(1).intValue());
        MppResourceTest.assertEquals((int)2, (int)resourceWade.getNumber(2).intValue());
        MppResourceTest.assertEquals((int)3, (int)resourceWade.getNumber(3).intValue());
        MppResourceTest.assertEquals((int)4, (int)resourceWade.getNumber(4).intValue());
        MppResourceTest.assertEquals((int)5, (int)resourceWade.getNumber(5).intValue());
        MppResourceTest.assertEquals((int)6, (int)resourceWade.getNumber(6).intValue());
        MppResourceTest.assertEquals((int)7, (int)resourceWade.getNumber(7).intValue());
        MppResourceTest.assertEquals((int)8, (int)resourceWade.getNumber(8).intValue());
        MppResourceTest.assertEquals((int)9, (int)resourceWade.getNumber(9).intValue());
        MppResourceTest.assertEquals((int)10, (int)resourceWade.getNumber(10).intValue());
        MppResourceTest.assertEquals((int)11, (int)resourceWade.getNumber(11).intValue());
        MppResourceTest.assertEquals((int)12, (int)resourceWade.getNumber(12).intValue());
        MppResourceTest.assertEquals((int)13, (int)resourceWade.getNumber(13).intValue());
        MppResourceTest.assertEquals((int)14, (int)resourceWade.getNumber(14).intValue());
        MppResourceTest.assertEquals((int)15, (int)resourceWade.getNumber(15).intValue());
        MppResourceTest.assertEquals((int)16, (int)resourceWade.getNumber(16).intValue());
        MppResourceTest.assertEquals((int)17, (int)resourceWade.getNumber(17).intValue());
        MppResourceTest.assertEquals((int)18, (int)resourceWade.getNumber(18).intValue());
        MppResourceTest.assertEquals((int)19, (int)resourceWade.getNumber(19).intValue());
        MppResourceTest.assertEquals((int)20, (int)resourceWade.getNumber(20).intValue());
        MppResourceTest.assertEquals((String)"1", (String)resourceWade.getText(1));
        MppResourceTest.assertEquals((String)"2", (String)resourceWade.getText(2));
        MppResourceTest.assertEquals((String)"3", (String)resourceWade.getText(3));
        MppResourceTest.assertEquals((String)"4", (String)resourceWade.getText(4));
        MppResourceTest.assertEquals((String)"5", (String)resourceWade.getText(5));
        MppResourceTest.assertEquals((String)"6", (String)resourceWade.getText(6));
        MppResourceTest.assertEquals((String)"7", (String)resourceWade.getText(7));
        MppResourceTest.assertEquals((String)"8", (String)resourceWade.getText(8));
        MppResourceTest.assertEquals((String)"9", (String)resourceWade.getText(9));
        MppResourceTest.assertEquals((String)"10", (String)resourceWade.getText(10));
        MppResourceTest.assertEquals((String)"11", (String)resourceWade.getText(11));
        MppResourceTest.assertEquals((String)"12", (String)resourceWade.getText(12));
        MppResourceTest.assertEquals((String)"13", (String)resourceWade.getText(13));
        MppResourceTest.assertEquals((String)"14", (String)resourceWade.getText(14));
        MppResourceTest.assertEquals((String)"15", (String)resourceWade.getText(15));
        MppResourceTest.assertEquals((String)"16", (String)resourceWade.getText(16));
        MppResourceTest.assertEquals((String)"17", (String)resourceWade.getText(17));
        MppResourceTest.assertEquals((String)"18", (String)resourceWade.getText(18));
        MppResourceTest.assertEquals((String)"19", (String)resourceWade.getText(19));
        MppResourceTest.assertEquals((String)"20", (String)resourceWade.getText(20));
        MppResourceTest.assertEquals((String)"21", (String)resourceWade.getText(21));
        MppResourceTest.assertEquals((String)"22", (String)resourceWade.getText(22));
        MppResourceTest.assertEquals((String)"23", (String)resourceWade.getText(23));
        MppResourceTest.assertEquals((String)"24", (String)resourceWade.getText(24));
        MppResourceTest.assertEquals((String)"25", (String)resourceWade.getText(25));
        MppResourceTest.assertEquals((String)"26", (String)resourceWade.getText(26));
        MppResourceTest.assertEquals((String)"27", (String)resourceWade.getText(27));
        MppResourceTest.assertEquals((String)"28", (String)resourceWade.getText(28));
        MppResourceTest.assertEquals((String)"29", (String)resourceWade.getText(29));
        MppResourceTest.assertEquals((String)"30", (String)resourceWade.getText(30));
    }

    private void testResourceOutlineCodes(ProjectFile mpp) throws Exception {
        Resource resourceWade = mpp.getResourceByID(1);
        MppResourceTest.assertEquals((String)"AAA", (String)resourceWade.getOutlineCode1());
        MppResourceTest.assertEquals((String)"BBB", (String)resourceWade.getOutlineCode2());
        MppResourceTest.assertEquals((String)"CCC", (String)resourceWade.getOutlineCode3());
        MppResourceTest.assertEquals((String)"DDD", (String)resourceWade.getOutlineCode4());
        MppResourceTest.assertEquals((String)"EEE", (String)resourceWade.getOutlineCode5());
        MppResourceTest.assertEquals((String)"FFF", (String)resourceWade.getOutlineCode6());
        MppResourceTest.assertEquals((String)"GGG", (String)resourceWade.getOutlineCode7());
        MppResourceTest.assertEquals((String)"HHH", (String)resourceWade.getOutlineCode8());
        MppResourceTest.assertEquals((String)"III", (String)resourceWade.getOutlineCode9());
        MppResourceTest.assertEquals((String)"JJJ", (String)resourceWade.getOutlineCode10());
    }

    private void testResourceAssignments(ProjectFile mpp) {
        Integer intOne = 1;
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        List<ResourceAssignment> listResourceAssignments = mpp.getAllResourceAssignments();
        ResourceAssignment ra = listResourceAssignments.get(0);
        MppResourceTest.assertEquals((Object)intOne, (Object)ra.getResource().getID());
        MppResourceTest.assertEquals((Object)intOne, (Object)ra.getResourceUniqueID());
        MppResourceTest.assertEquals((String)"25/08/2006", (String)df.format(ra.getStart()));
        MppResourceTest.assertEquals((String)"29/08/2006", (String)df.format(ra.getFinish()));
        Task task = ra.getTask();
        MppResourceTest.assertEquals((Object)intOne, (Object)task.getID());
        MppResourceTest.assertEquals((Object)2, (Object)task.getUniqueID());
        MppResourceTest.assertEquals((String)"Task A", (String)task.getName());
        MppResourceTest.assertEquals((Object)100.0, (Object)ra.getUnits());
        Duration dur24Hours = Duration.getInstance(24, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)dur24Hours, (Object)ra.getWork());
        MppResourceTest.assertEquals((Object)dur24Hours, (Object)ra.getRemainingWork());
        MppResourceTest.assertEquals((String)"01/01/2006", (String)df.format(ra.getBaselineStart()));
        MppResourceTest.assertEquals((String)"02/01/2006", (String)df.format(ra.getBaselineFinish()));
        MppResourceTest.assertEquals((int)1, (int)ra.getBaselineCost().intValue());
        MppResourceTest.assertEquals((String)"2.0h", (String)ra.getBaselineWork().toString());
        ResourceAssignment ra2 = listResourceAssignments.get(3);
        MppResourceTest.assertEquals((Object)WorkContour.TURTLE, (Object)ra2.getWorkContour());
        task = mpp.getTaskByUniqueID(4);
        MppResourceTest.assertEquals((String)"Completed Task", (String)task.getName());
        ResourceAssignment ra3 = task.getResourceAssignments().get(0);
        MppResourceTest.assertEquals((String)"26/08/2006", (String)df.format(ra3.getActualStart()));
        MppResourceTest.assertEquals((String)"29/08/2006", (String)df.format(ra3.getActualFinish()));
        MppResourceTest.assertEquals((String)"16.0h", (String)ra3.getActualWork().toString());
        MppResourceTest.assertEquals((int)800, (int)ra3.getActualCost().intValue());
    }

    private void testNotes(ProjectFile file) {
        for (Resource resource : file.getAllResources()) {
            int id = resource.getID();
            if (id == 0) continue;
            MppResourceTest.assertEquals((String)("Resource Notes " + id), (String)resource.getNotes().trim());
        }
    }
}

