/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.util.List;
import net.sf.mpxj.Filter;
import net.sf.mpxj.GenericCriteria;
import net.sf.mpxj.GenericCriteriaPrompt;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TestOperator;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;

public class MppFilterTest
extends MPXJTestCase {
    public void testMpp9Filters() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9filter.mpp");
        this.executeTests(mpp);
    }

    public void testMpp9FiltersFrom12() throws Exception {
    }

    public void testMpp9FiltersFrom14() throws Exception {
    }

    public void testMpp12Filters() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12filter.mpp");
        this.executeTests(mpp);
    }

    public void testMpp12FiltersFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12filter-from14.mpp");
        this.executeTests(mpp);
    }

    public void testMpp14Filters() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp14filter.mpp");
        this.executeTests(mpp);
    }

    private void executeTests(ProjectFile mpp) {
        this.testFilters(mpp);
        this.testFilterEvaluation(mpp);
        this.testLogicalOperatorEvaluation(mpp);
        this.testParameters(mpp);
    }

    private void testFilters(ProjectFile mpp) {
        Filter filter = mpp.getFilterByName("Filter 1");
        MppFilterTest.assertEquals((String)"(Duration1 EQUALS 9.0w)", (String)filter.getCriteria().toString());
        filter = mpp.getFilterByName("Filter 2");
        MppFilterTest.assertEquals((String)"(Number1 EQUALS 99.0)", (String)filter.getCriteria().toString());
        filter = mpp.getFilterByName("Filter 3");
        MppFilterTest.assertEquals((String)"(% Complete EQUALS 10.0)", (String)filter.getCriteria().toString());
        filter = mpp.getFilterByName("Filter 4");
        MppFilterTest.assertEquals((String)"(Cost1 EQUALS 99.0)", (String)filter.getCriteria().toString());
        filter = mpp.getFilterByName("Filter 5");
        MppFilterTest.assertEquals((String)"(Text1 EQUALS Hello)", (String)filter.getCriteria().toString());
        filter = mpp.getFilterByName("Filter 6");
        MppFilterTest.assertEquals((String)"(Flag1 EQUALS true)", (String)filter.getCriteria().toString());
        filter = mpp.getFilterByName("Filter 7");
        MppFilterTest.assertEquals((String)"(Date1 EQUALS Tue Jul 18 00:00:00 BST 2006)", (String)filter.getCriteria().toString());
        filter = mpp.getFilterByName("Filter 8");
        MppFilterTest.assertEquals((String)"((Number1 EQUALS 10.0) AND (Number2 DOES_NOT_EQUAL 10.0) AND (Number3 IS_GREATER_THAN 10.0) AND (Number4 IS_GREATER_THAN_OR_EQUAL_TO 10.0) AND (Number5 IS_LESS_THAN 10.0) AND (Number6 IS_LESS_THAN_OR_EQUAL_TO 10.0) AND (Number7 IS_WITHIN 10.0,20.0) AND (Number8 IS_NOT_WITHIN 10.0,20.0))", (String)filter.getCriteria().toString());
    }

    private void testFilterEvaluation(ProjectFile mpp) {
        Task task1 = mpp.getTaskByID(1);
        Task task2 = mpp.getTaskByID(2);
        Filter filter = mpp.getFilterByName("Filter 1");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2, null));
        filter = mpp.getFilterByName("Filter 2");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2, null));
        filter = mpp.getFilterByName("Filter 3");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2, null));
        filter = mpp.getFilterByName("Filter 4");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2, null));
        filter = mpp.getFilterByName("Filter 5");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2, null));
        filter = mpp.getFilterByName("Filter 6");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2, null));
        filter = mpp.getFilterByName("Filter 7");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2, null));
        Task task3 = mpp.getTaskByID(3);
        Task task4 = mpp.getTaskByID(4);
        Task task5 = mpp.getTaskByID(5);
        Task task6 = mpp.getTaskByID(6);
        Task task7 = mpp.getTaskByID(7);
        filter = mpp.getFilterByName("Filter 9");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task3, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5, null));
        filter = mpp.getFilterByName("Filter 10");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task3, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5, null));
        filter = mpp.getFilterByName("Filter 11");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task3, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task4, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5, null));
        filter = mpp.getFilterByName("Filter 12");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task3, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task5, null));
        filter = mpp.getFilterByName("Filter 13");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task3, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task4, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task5, null));
        filter = mpp.getFilterByName("Filter 14");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task3, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task4, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task6, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task7, null));
        filter = mpp.getFilterByName("Filter 15");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task3, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task5, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task6, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7, null));
        filter = mpp.getFilterByName("Filter 16");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task3, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task6, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task7, null));
        filter = mpp.getFilterByName("Filter 17");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task3, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task4, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task5, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task6, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7, null));
        filter = mpp.getFilterByName("Filter 18");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task3, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task6, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task7, null));
        filter = new Filter();
        GenericCriteria criteria = new GenericCriteria(mpp);
        filter.setCriteria(criteria);
        criteria.setLeftValue(TaskField.DEADLINE);
        criteria.setOperator(TestOperator.IS_ANY_VALUE);
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1, null));
        filter = new Filter();
        criteria = new GenericCriteria(mpp);
        filter.setCriteria(criteria);
        criteria.setLeftValue(TaskField.FLAG1);
        criteria.setOperator(TestOperator.EQUALS);
        criteria.setRightValue(0, Boolean.TRUE);
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1, null));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2, null));
    }

    private void testLogicalOperatorEvaluation(ProjectFile mpp) {
        Task task6 = mpp.getTaskByID(6);
        Task task7 = mpp.getTaskByID(7);
        Filter filter = mpp.getFilterByName("Filter 19");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task6, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7, null));
        filter = mpp.getFilterByName("Filter 20");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task6, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7, null));
        filter = mpp.getFilterByName("Filter 21");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task6, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7, null));
        filter = mpp.getFilterByName("Filter 22");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task6, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7, null));
        filter = mpp.getFilterByName("Filter 23");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task6, null));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7, null));
    }

    private void testParameters(ProjectFile mpp) {
        Filter filter = mpp.getFilterByName("Filter 24");
        MppFilterTest.assertNotNull((Object)filter);
        List<GenericCriteriaPrompt> prompts = filter.getPrompts();
        MppFilterTest.assertEquals((String)"Duration1", (String)prompts.get(0).getPrompt());
        MppFilterTest.assertEquals((String)"Number1", (String)prompts.get(1).getPrompt());
        MppFilterTest.assertEquals((String)"%Complete", (String)prompts.get(2).getPrompt());
        MppFilterTest.assertEquals((String)"Cost1", (String)prompts.get(3).getPrompt());
        MppFilterTest.assertEquals((String)"Text1", (String)prompts.get(4).getPrompt());
        MppFilterTest.assertEquals((String)"Flag1", (String)prompts.get(5).getPrompt());
        MppFilterTest.assertEquals((String)"Date1", (String)prompts.get(6).getPrompt());
        MppFilterTest.assertEquals((String)"LHS", (String)prompts.get(7).getPrompt());
        MppFilterTest.assertEquals((String)"RHS", (String)prompts.get(8).getPrompt());
        MppFilterTest.assertEquals((String)"LHS", (String)prompts.get(9).getPrompt());
        MppFilterTest.assertEquals((String)"RHS", (String)prompts.get(10).getPrompt());
    }

    public void testNullValueTestOperators() {
        TestOperator operator = TestOperator.CONTAINS;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, null));
        MppFilterTest.assertFalse((boolean)operator.evaluate("", null));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, ""));
        operator = TestOperator.CONTAINS_EXACTLY;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, null));
        MppFilterTest.assertFalse((boolean)operator.evaluate("", null));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, ""));
        operator = TestOperator.DOES_NOT_CONTAIN;
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, null));
        MppFilterTest.assertTrue((boolean)operator.evaluate("", null));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, ""));
        operator = TestOperator.DOES_NOT_EQUAL;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, null));
        MppFilterTest.assertTrue((boolean)operator.evaluate("", null));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, ""));
        operator = TestOperator.EQUALS;
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, null));
        MppFilterTest.assertFalse((boolean)operator.evaluate("", null));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, ""));
        operator = TestOperator.IS_GREATER_THAN;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, null));
        MppFilterTest.assertFalse((boolean)operator.evaluate("", null));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, ""));
        operator = TestOperator.IS_GREATER_THAN_OR_EQUAL_TO;
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, null));
        MppFilterTest.assertFalse((boolean)operator.evaluate("", null));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, ""));
        operator = TestOperator.IS_LESS_THAN;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, null));
        MppFilterTest.assertTrue((boolean)operator.evaluate("", null));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, ""));
        operator = TestOperator.IS_LESS_THAN_OR_EQUAL_TO;
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, null));
        MppFilterTest.assertTrue((boolean)operator.evaluate("", null));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, ""));
        Object[] allNull = new Object[]{null, null};
        Object[] lhsNull = new Object[]{null, 10};
        Object[] rhsNull = new Object[]{1, null};
        operator = TestOperator.IS_NOT_WITHIN;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, allNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, lhsNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, rhsNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(5, allNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(5, lhsNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(5, rhsNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(allNull, 5));
        MppFilterTest.assertTrue((boolean)operator.evaluate(lhsNull, 5));
        MppFilterTest.assertTrue((boolean)operator.evaluate(rhsNull, 5));
        operator = TestOperator.IS_WITHIN;
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, allNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, lhsNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, rhsNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(5, allNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(5, lhsNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(5, rhsNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(allNull, 5));
        MppFilterTest.assertFalse((boolean)operator.evaluate(lhsNull, 5));
        MppFilterTest.assertFalse((boolean)operator.evaluate(rhsNull, 5));
    }
}

