/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import net.sf.mpxj.Filter;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.GanttChartView;
import net.sf.mpxj.mpp.MPPReader;

public class MppAutoFilterTest
extends MPXJTestCase {
    public void testMpp9Filters() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9autofilter.mpp");
        this.testFilters(mpp);
    }

    public void testMpp9FiltersFrom12() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9autofilter-from12.mpp");
        this.testFilters(mpp);
    }

    public void testMpp9FiltersFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9autofilter-from14.mpp");
        this.testFilters(mpp);
    }

    public void testMpp12Filters() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12autofilter.mpp");
        this.testFilters(mpp);
    }

    public void testMpp12FiltersFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12autofilter-from14.mpp");
        this.testFilters(mpp);
    }

    public void testMpp14Filters() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp14autofilter.mpp");
        this.testFilters(mpp);
    }

    private void testFilters(ProjectFile mpp) {
        GanttChartView view = (GanttChartView)mpp.getViews().get(0);
        MppAutoFilterTest.assertEquals((String)"Gantt Chart", (String)view.getName());
        Filter filter = view.getAutoFilterByType(TaskField.DURATION);
        MppAutoFilterTest.assertEquals((String)"((Duration EQUALS 9.0d) AND (Duration EQUALS 99.0d))", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.NUMBER1);
        MppAutoFilterTest.assertEquals((String)"((Number1 EQUALS 9.0) OR (Number1 EQUALS 99.0))", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.PERCENT_COMPLETE);
        MppAutoFilterTest.assertEquals((String)"((% Complete EQUALS 9.0) OR (% Complete EQUALS 99.0))", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.COST1);
        MppAutoFilterTest.assertEquals((String)"((Cost1 EQUALS 9.0) OR (Cost1 EQUALS 99.0))", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.TEXT1);
        MppAutoFilterTest.assertEquals((String)"((Text1 EQUALS 9) OR (Text1 EQUALS 99))", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.FLAG1);
        MppAutoFilterTest.assertEquals((String)"((Flag1 EQUALS true) OR (Flag1 EQUALS false))", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.DATE1);
        MppAutoFilterTest.assertEquals((String)"((Date1 EQUALS Thu Sep 09 00:00:00 BST 1999) OR (Date1 EQUALS Wed Sep 09 00:00:00 BST 2009))", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.NUMBER2);
        MppAutoFilterTest.assertEquals((String)"(Number2 DOES_NOT_EQUAL 1.0)", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.NUMBER3);
        MppAutoFilterTest.assertEquals((String)"(Number3 IS_GREATER_THAN 1.0)", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.NUMBER4);
        MppAutoFilterTest.assertEquals((String)"(Number4 IS_GREATER_THAN_OR_EQUAL_TO 1.0)", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.NUMBER5);
        MppAutoFilterTest.assertEquals((String)"(Number5 IS_LESS_THAN 1.0)", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.NUMBER6);
        MppAutoFilterTest.assertEquals((String)"(Number6 IS_LESS_THAN_OR_EQUAL_TO 1.0)", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.NUMBER7);
        MppAutoFilterTest.assertEquals((String)"(Number7 IS_WITHIN 1.0,2.0)", (String)filter.getCriteria().toString());
        filter = view.getAutoFilterByType(TaskField.NUMBER8);
        MppAutoFilterTest.assertEquals((String)"(Number8 IS_NOT_WITHIN 1.0,2.0)", (String)filter.getCriteria().toString());
    }
}

