/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class CostRateTableTest
extends MPXJTestCase {
    private DateFormat m_df = new SimpleDateFormat("dd/MM/yyyy HH:mm");

    public void testMpp9() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9costratetable.mpp");
        this.testCostRateTable(file);
    }

    public void testMpp9From12() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9costratetable-from12.mpp");
        this.testCostRateTable(file);
    }

    public void testMpp9From14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9costratetable-from14.mpp");
        this.testCostRateTable(file);
    }

    public void testMpp12() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp12costratetable.mpp");
        this.testCostRateTable(file);
    }

    public void testMpp12From14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp12costratetable-from14.mpp");
        this.testCostRateTable(file);
    }

    public void testMpp14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp14costratetable.mpp");
        this.testCostRateTable(file);
    }

    public void testMspdi() throws Exception {
        ProjectFile file = new MSPDIReader().read(this.m_basedir + "/mspdicostratetable.xml");
        this.testCostRateTable(file);
    }

    private void testCostRateTable(ProjectFile file) throws Exception {
        Resource resource = file.getResourceByID(1);
        CostRateTableTest.assertEquals((String)"Resource One", (String)resource.getName());
        CostRateTable table = resource.getCostRateTable(0);
        CostRateTableTest.assertEquals((int)1, (int)table.size());
        this.assertEquals(0.0, TimeUnit.HOURS, 0.0, TimeUnit.HOURS, 0.0, "31/12/2049 23:59", table, 0);
        table = resource.getCostRateTable(1);
        CostRateTableTest.assertEquals((int)1, (int)table.size());
        this.assertEquals(0.0, TimeUnit.HOURS, 0.0, TimeUnit.HOURS, 0.0, "31/12/2049 23:59", table, 0);
        table = resource.getCostRateTable(2);
        CostRateTableTest.assertEquals((int)1, (int)table.size());
        this.assertEquals(0.0, TimeUnit.HOURS, 0.0, TimeUnit.HOURS, 0.0, "31/12/2049 23:59", table, 0);
        table = resource.getCostRateTable(3);
        CostRateTableTest.assertEquals((int)1, (int)table.size());
        this.assertEquals(0.0, TimeUnit.HOURS, 0.0, TimeUnit.HOURS, 0.0, "31/12/2049 23:59", table, 0);
        table = resource.getCostRateTable(4);
        CostRateTableTest.assertEquals((int)1, (int)table.size());
        this.assertEquals(0.0, TimeUnit.HOURS, 0.0, TimeUnit.HOURS, 0.0, "31/12/2049 23:59", table, 0);
        resource = file.getResourceByID(2);
        CostRateTableTest.assertEquals((String)"Resource Two", (String)resource.getName());
        table = resource.getCostRateTable(0);
        CostRateTableTest.assertEquals((int)1, (int)table.size());
        this.assertEquals(5.0, TimeUnit.HOURS, 10.0, TimeUnit.HOURS, 15.0, "31/12/2049 23:59", table, 0);
        table = resource.getCostRateTable(1);
        CostRateTableTest.assertEquals((int)1, (int)table.size());
        this.assertEquals(20.0, TimeUnit.HOURS, 25.0, TimeUnit.HOURS, 30.0, "31/12/2049 23:59", table, 0);
        table = resource.getCostRateTable(2);
        CostRateTableTest.assertEquals((int)1, (int)table.size());
        this.assertEquals(35.0, TimeUnit.HOURS, 40.0, TimeUnit.HOURS, 45.0, "31/12/2049 23:59", table, 0);
        table = resource.getCostRateTable(3);
        CostRateTableTest.assertEquals((int)1, (int)table.size());
        this.assertEquals(50.0, TimeUnit.HOURS, 55.0, TimeUnit.HOURS, 60.0, "31/12/2049 23:59", table, 0);
        table = resource.getCostRateTable(4);
        CostRateTableTest.assertEquals((int)1, (int)table.size());
        this.assertEquals(65.0, TimeUnit.HOURS, 70.0, TimeUnit.HOURS, 75.0, "31/12/2049 23:59", table, 0);
        resource = file.getResourceByID(3);
        CostRateTableTest.assertEquals((String)"Resource Three", (String)resource.getName());
        table = resource.getCostRateTable(0);
        CostRateTableTest.assertEquals((int)2, (int)table.size());
        this.assertEquals(5.0, TimeUnit.HOURS, 10.0, TimeUnit.HOURS, 15.0, "15/06/2009 08:00", table, 0);
        this.assertEquals(1200.0, TimeUnit.MINUTES, 25.0, TimeUnit.HOURS, 30.0, "31/12/2049 23:59", table, 1);
        table = resource.getCostRateTable(1);
        CostRateTableTest.assertEquals((int)2, (int)table.size());
        this.assertEquals(35.0, TimeUnit.HOURS, 40.0, TimeUnit.HOURS, 45.0, "16/06/2009 08:00", table, 0);
        this.assertEquals(6.25, TimeUnit.DAYS, 1.375, TimeUnit.WEEKS, 60.0, "31/12/2049 23:59", table, 1);
        table = resource.getCostRateTable(2);
        CostRateTableTest.assertEquals((int)2, (int)table.size());
        this.assertEquals(65.0, TimeUnit.HOURS, 70.0, TimeUnit.HOURS, 75.0, "17/06/2009 08:00", table, 0);
        this.assertEquals(0.5, TimeUnit.MONTHS, 0.04, TimeUnit.YEARS, 90.0, "31/12/2049 23:59", table, 1);
        table = resource.getCostRateTable(3);
        CostRateTableTest.assertEquals((int)2, (int)table.size());
        this.assertEquals(95.0, TimeUnit.HOURS, 100.0, TimeUnit.HOURS, 105.0, "18/06/2009 08:00", table, 0);
        this.assertEquals(110.0, TimeUnit.HOURS, 115.0, TimeUnit.HOURS, 120.0, "31/12/2049 23:59", table, 1);
        table = resource.getCostRateTable(4);
        CostRateTableTest.assertEquals((int)2, (int)table.size());
        this.assertEquals(125.0, TimeUnit.HOURS, 130.0, TimeUnit.HOURS, 135.0, "19/06/2009 08:00", table, 0);
        this.assertEquals(140.0, TimeUnit.HOURS, 145.0, TimeUnit.HOURS, 150.0, "31/12/2049 23:59", table, 1);
        CostRateTableEntry entry = table.getEntryByDate(this.m_df.parse("18/06/2009 07:00"));
        this.assertEquals(125.0, TimeUnit.HOURS, 130.0, TimeUnit.HOURS, 135.0, "19/06/2009 08:00", entry);
        entry = table.getEntryByDate(this.m_df.parse("19/06/2009 10:00"));
        this.assertEquals(140.0, TimeUnit.HOURS, 145.0, TimeUnit.HOURS, 150.0, "31/12/2049 23:59", entry);
    }

    private void assertEquals(double standardRate, TimeUnit standardRateFormat, double overtimeRate, TimeUnit overtimeRateFormat, double perUseRate, String endDate, CostRateTable table, int index) {
        CostRateTableEntry entry = (CostRateTableEntry)table.get(index);
        this.assertEquals(standardRate, standardRateFormat, overtimeRate, overtimeRateFormat, perUseRate, endDate, entry);
    }

    private void assertEquals(double standardRate, TimeUnit standardRateFormat, double overtimeRate, TimeUnit overtimeRateFormat, double costPerUse, String endDate, CostRateTableEntry entry) {
        CostRateTableTest.assertEquals((double)standardRate, (double)entry.getStandardRate().getAmount(), (double)0.009);
        CostRateTableTest.assertEquals((double)overtimeRate, (double)entry.getOvertimeRate().getAmount(), (double)0.009);
        CostRateTableTest.assertEquals((double)costPerUse, (double)entry.getCostPerUse().doubleValue(), (double)0.0);
        CostRateTableTest.assertEquals((String)endDate, (String)this.m_df.format(entry.getEndDate()));
        CostRateTableTest.assertEquals((Object)standardRateFormat, (Object)entry.getStandardRateFormat());
        CostRateTableTest.assertEquals((Object)overtimeRateFormat, (Object)entry.getOvertimeRateFormat());
    }
}

