/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import net.sf.mpxj.Availability;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class AvailabilityTest
extends MPXJTestCase {
    private DateFormat m_df = new SimpleDateFormat("dd/MM/yyyy HH:mm");

    public void testMpp9() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9availability.mpp");
        this.testAvailability(file);
    }

    public void testMpp9From12() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9availability-from12.mpp");
        this.testAvailability(file);
    }

    public void testMpp9From14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9availability-from14.mpp");
        this.testAvailability(file);
    }

    public void testMpp12() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp12availability.mpp");
        this.testAvailability(file);
    }

    public void testMpp12From14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp12availability-from14.mpp");
        this.testAvailability(file);
    }

    public void testMpp14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp14availability.mpp");
        this.testAvailability(file);
    }

    public void testMspdi() throws Exception {
        ProjectFile file = new MSPDIReader().read(this.m_basedir + "/mspdiavailability.xml");
        this.testAvailability(file);
    }

    private void testAvailability(ProjectFile file) throws Exception {
        Resource resource = file.getResourceByID(1);
        AvailabilityTest.assertEquals((String)"Resource One", (String)resource.getName());
        AvailabilityTable table = resource.getAvailability();
        AvailabilityTest.assertEquals((int)0, (int)table.size());
        resource = file.getResourceByID(2);
        AvailabilityTest.assertEquals((String)"Resource Two", (String)resource.getName());
        table = resource.getAvailability();
        AvailabilityTest.assertEquals((int)3, (int)table.size());
        this.assertEquals("01/06/2009 00:00", "01/07/2009 23:59", 100.0, table, 0);
        this.assertEquals("02/07/2009 00:00", "01/08/2009 23:59", 60.0, table, 1);
        this.assertEquals("20/08/2009 00:00", "30/08/2009 23:59", 75.0, table, 2);
        Availability entry = table.getEntryByDate(this.m_df.parse("01/05/2009 12:00"));
        AvailabilityTest.assertNull((Object)entry);
        entry = table.getEntryByDate(this.m_df.parse("03/07/2009 12:00"));
        this.assertEquals("02/07/2009 00:00", "01/08/2009 23:59", 60.0, table, 1);
        entry = table.getEntryByDate(this.m_df.parse("02/08/2009 12:00"));
        AvailabilityTest.assertNull((Object)entry);
        entry = table.getEntryByDate(this.m_df.parse("21/08/2009 12:00"));
        this.assertEquals("20/08/2009 00:00", "30/08/2009 23:59", 75.0, table, 2);
        entry = table.getEntryByDate(this.m_df.parse("01/09/2009 12:00"));
        AvailabilityTest.assertNull((Object)entry);
    }

    private void assertEquals(String startDate, String endDate, double units, AvailabilityTable table, int index) {
        Availability entry = (Availability)table.get(index);
        this.assertEquals(startDate, endDate, units, entry);
    }

    private void assertEquals(String startDate, String endDate, double units, Availability entry) {
        DateRange range = entry.getRange();
        AvailabilityTest.assertEquals((String)startDate, (String)this.m_df.format(range.getStart()));
        AvailabilityTest.assertEquals((String)endDate, (String)this.m_df.format(range.getEnd()));
        AvailabilityTest.assertEquals((double)units, (double)entry.getUnits().doubleValue(), (double)0.0);
    }
}

