/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

public enum RelationType implements MpxjEnum
{
    FINISH_FINISH(0, "FF"),
    FINISH_START(1, "FS"),
    START_FINISH(2, "SF"),
    START_START(3, "SS");

    private static final RelationType[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private RelationType(int type, String name) {
        this.m_value = type;
        this.m_name = name;
    }

    public static RelationType getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = FINISH_START.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static RelationType getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return RelationType.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String toString() {
        return this.m_name;
    }

    static {
        TYPE_VALUES = (RelationType[])EnumUtility.createTypeArray(RelationType.class);
    }
}

