/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

public enum EarnedValueMethod implements MpxjEnum
{
    PERCENT_COMPLETE(0),
    PHYSICAL_PERCENT_COMPLETE(1);

    private static final EarnedValueMethod[] TYPE_VALUES;
    private int m_value;

    private EarnedValueMethod(int type) {
        this.m_value = type;
    }

    public static EarnedValueMethod getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = PHYSICAL_PERCENT_COMPLETE.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static EarnedValueMethod getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return EarnedValueMethod.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    static {
        TYPE_VALUES = (EarnedValueMethod[])EnumUtility.createTypeArray(EarnedValueMethod.class);
    }
}

