/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import net.sf.mpxj.Rate;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

public class CostRateTableEntry
implements Comparable<CostRateTableEntry> {
    private Date m_endDate;
    private Rate m_standardRate;
    private TimeUnit m_standardRateFormat;
    private Rate m_overtimeRate;
    private TimeUnit m_overtimeRateFormat;
    private Number m_costPerUse;
    public static final CostRateTableEntry DEFAULT_ENTRY = new CostRateTableEntry();

    private CostRateTableEntry() {
        this.m_endDate = DateUtility.LAST_DATE;
        this.m_standardRate = new Rate(0.0, TimeUnit.HOURS);
        this.m_standardRateFormat = TimeUnit.HOURS;
        this.m_overtimeRate = this.m_standardRate;
        this.m_overtimeRateFormat = TimeUnit.HOURS;
        this.m_costPerUse = NumberUtility.getDouble(0.0);
    }

    public CostRateTableEntry(Rate standardRate, TimeUnit standardRateFormat, Rate overtimeRate, TimeUnit overtimeRateFormat, Number costPerUse, Date endDate) {
        this.m_endDate = endDate;
        this.m_standardRate = standardRate;
        this.m_standardRateFormat = standardRateFormat;
        this.m_overtimeRate = overtimeRate;
        this.m_overtimeRateFormat = overtimeRateFormat;
        this.m_costPerUse = costPerUse;
    }

    public Date getEndDate() {
        return this.m_endDate;
    }

    public Rate getStandardRate() {
        return this.m_standardRate;
    }

    public TimeUnit getStandardRateFormat() {
        return this.m_standardRateFormat;
    }

    public Rate getOvertimeRate() {
        return this.m_overtimeRate;
    }

    public TimeUnit getOvertimeRateFormat() {
        return this.m_overtimeRateFormat;
    }

    public Number getCostPerUse() {
        return this.m_costPerUse;
    }

    @Override
    public int compareTo(CostRateTableEntry o) {
        return DateUtility.compare(this.m_endDate, o.m_endDate);
    }

    public String toString() {
        return "[CostRateTableEntry standardRate=" + this.m_standardRate + " overtimeRate=" + this.m_overtimeRate + " costPerUse=" + this.m_costPerUse + " endDate=" + this.m_endDate + "]";
    }
}

