/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.util.logging.Level;
import org.bardsoftware.eclipsito.Boot;
import org.bardsoftware.impl.eclipsito.BundleImpl;
import org.bardsoftware.impl.eclipsito.DependencyResolver;
import org.bardsoftware.impl.eclipsito.ExtensionRegistryImpl;
import org.bardsoftware.impl.eclipsito.ExtensionsProcessor;
import org.bardsoftware.impl.eclipsito.JobManagerImpl;
import org.bardsoftware.impl.eclipsito.PluginDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class PlatformImpl
extends Platform {
    private IExtensionRegistry myExtensionRegistry;
    private Bundle[] myBundles;

    protected PlatformImpl() {
        PlatformImpl.setInstance(this);
    }

    protected void setup(PluginDescriptor[] descriptors) {
        PluginDescriptor[] resolved = new DependencyResolver(descriptors).resolveAll();
        this.myBundles = this.createBundles(resolved);
        IExtensionPoint[] points = ExtensionsProcessor.resolveExtensionPoints(resolved);
        this.myExtensionRegistry = new ExtensionRegistryImpl(points);
    }

    public void start() {
        for (int i = 0; this.myBundles != null && i < this.myBundles.length; ++i) {
            try {
                int state = this.myBundles[i].getState();
                if (state != 2 && state != 4) continue;
                this.myBundles[i].start();
                continue;
            }
            catch (BundleException e) {
                Boot.LOG.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public void stop() {
        for (int i = 0; this.myBundles != null && i < this.myBundles.length; ++i) {
            try {
                if (this.myBundles[i].getState() != 32) continue;
                this.myBundles[i].stop();
                continue;
            }
            catch (BundleException e) {
                Boot.LOG.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    protected IExtensionRegistry getExtensionRegistryImpl() {
        return this.myExtensionRegistry;
    }

    protected Bundle getBundleImpl(String symbolicName) {
        Bundle result = null;
        for (int i = 0; this.myBundles != null && i < this.myBundles.length; ++i) {
            if (!this.myBundles[i].getSymbolicName().equals(symbolicName)) continue;
            if (this.myBundles[i].getState() == 2) {
                try {
                    this.myBundles[i].start();
                }
                catch (BundleException e) {
                    Boot.LOG.log(Level.WARNING, e.getMessage(), e);
                }
            }
            result = this.myBundles[i];
            break;
        }
        return result;
    }

    private Bundle[] createBundles(PluginDescriptor[] descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException("Could not create Bundles if there are no descriptors");
        }
        Bundle[] result = new Bundle[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            result[i] = new BundleImpl(descriptors[i]);
        }
        return result;
    }

    protected IJobManager getJobManagerImpl() {
        return JobManagerImpl.getInstance();
    }

    protected IPreferencesService getPreferencesServiceImpl() {
        IConfigurationElement[] prefServices = this.myExtensionRegistry.getConfigurationElementsFor(IPreferencesService.class.getName());
        if (prefServices == null || prefServices.length == 0) {
            return null;
        }
        try {
            Object result = prefServices[0].createExecutableExtension("class");
            assert (result instanceof IPreferencesService);
            return (IPreferencesService)result;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

