/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.bardsoftware.impl.eclipsito.DescriptorParser;
import org.bardsoftware.impl.eclipsito.PluginDescriptor;

public class ModulesDirectoryProcessor {
    public static PluginDescriptor[] process(File pluginDir, String descriptorPattern) {
        return ModulesDirectoryProcessor.processDescriptors(ModulesDirectoryProcessor.findModuleDescriptors(pluginDir, descriptorPattern));
    }

    protected static PluginDescriptor[] processDescriptors(URL[] moduleDescriptorUris) {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        for (int i = 0; i < moduleDescriptorUris.length; ++i) {
            PluginDescriptor pluginDescriptor = DescriptorParser.parse(moduleDescriptorUris[i]);
            if (pluginDescriptor == null) continue;
            result.add(pluginDescriptor);
        }
        return result.toArray(new PluginDescriptor[result.size()]);
    }

    protected static URL[] findModuleDescriptors(File pluginDir, String descriptorPattern) {
        ArrayList<URL> result = new ArrayList<URL>();
        File[] directories = ModulesDirectoryProcessor.findSubdirectories(pluginDir);
        for (int i = 0; descriptorPattern != null && i < directories.length; ++i) {
            File descriptorFile = new File(directories[i], descriptorPattern);
            if (!descriptorFile.exists() || !descriptorFile.isFile()) continue;
            try {
                result.add(descriptorFile.toURL());
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return result.toArray(new URL[result.size()]);
    }

    private static File[] findSubdirectories(File pluginDir) {
        Object[] result = pluginDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (result == null) {
            result = new File[]{};
        }
        Arrays.sort(result);
        return result;
    }
}

