/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.util.ArrayList;
import org.bardsoftware.impl.eclipsito.ApplicationLauncher;
import org.bardsoftware.impl.eclipsito.ExtensionPointImpl;
import org.bardsoftware.impl.eclipsito.PluginDescriptor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class ExtensionsProcessor {
    public static IExtensionPoint[] resolveExtensionPoints(PluginDescriptor[] pluginDescriptors) {
        ArrayList<ExtensionPointImpl> allPoints = new ArrayList<ExtensionPointImpl>();
        allPoints.add(new ExtensionPointImpl(ApplicationLauncher.ourRuntimeApplicationExtensionPoint, ExtensionsProcessor.collectPointExtensions(ApplicationLauncher.ourAppsPointId, pluginDescriptors)));
        for (int i = 0; pluginDescriptors != null && i < pluginDescriptors.length; ++i) {
            PluginDescriptor.ExtensionPointDescriptor[] extensionPointDescriptors = pluginDescriptors[i].getExtensionPointDescriptors();
            for (int j = 0; extensionPointDescriptors != null && j < extensionPointDescriptors.length; ++j) {
                IExtension[] extensions = ExtensionsProcessor.collectPointExtensions(extensionPointDescriptors[j].getId(), pluginDescriptors);
                ExtensionPointImpl point = new ExtensionPointImpl(extensionPointDescriptors[j], extensions);
                allPoints.add(point);
            }
        }
        return allPoints.toArray(new IExtensionPoint[0]);
    }

    protected static IExtension[] collectPointExtensions(String pointId, PluginDescriptor[] pluginDescriptors) {
        if (pointId == null) {
            throw new IllegalArgumentException("Don't pass me null extension point id!");
        }
        ArrayList<IExtension> result = new ArrayList<IExtension>();
        for (int i = 0; pluginDescriptors != null && i < pluginDescriptors.length; ++i) {
            IExtension[] extensions = pluginDescriptors[i].getExtensions();
            for (int j = 0; extensions != null && j < extensions.length; ++j) {
                if (!pointId.equals(extensions[j].getExtensionPointUniqueIdentifier())) continue;
                result.add(extensions[j]);
            }
        }
        return result.toArray(new IExtension[result.size()]);
    }
}

