/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.net.URL;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.bardsoftware.eclipsito.Boot;
import org.bardsoftware.impl.eclipsito.PluginDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DescriptorParser {
    private static DocumentBuilder myDocumentBuilder;

    public static PluginDescriptor parse(URL pluginDescriptorUrl) {
        PluginDescriptor result = null;
        try {
            System.err.println("[DescriptorParser] parse(): plugin descriptor url=" + pluginDescriptorUrl);
            Element root = myDocumentBuilder.parse(pluginDescriptorUrl.openStream()).getDocumentElement();
            result = DescriptorParser.constructPluginDescriptor(root, pluginDescriptorUrl);
        }
        catch (Exception e) {
            Boot.LOG.log(Level.WARNING, "Exception happened while parsing " + pluginDescriptorUrl + ", ignoring this plugin", e);
        }
        return result;
    }

    protected static PluginDescriptor constructPluginDescriptor(Element pluginElement, URL pluginDescriptorUrl) {
        PluginDescriptor result = null;
        if (pluginElement != null && "plugin".equals(pluginElement.getTagName())) {
            result = new PluginDescriptor(pluginDescriptorUrl);
            DescriptorParser.handlePluginAttributes(pluginElement, result);
            DescriptorParser.handleRequiresElements(pluginElement.getElementsByTagName("requires"), result);
            DescriptorParser.handleRuntimeElements(pluginElement.getElementsByTagName("runtime"), result);
            DescriptorParser.handleExtensionElements(pluginElement.getElementsByTagName("extension"), result);
            DescriptorParser.handleExtensionPointElements(pluginElement.getElementsByTagName("extension-point"), result);
        } else {
            Boot.LOG.log(Level.WARNING, "Incorrect plugin descriptor format for " + pluginDescriptorUrl.getPath() + ", ignoring this plugin");
        }
        return result;
    }

    private static void handlePluginAttributes(Element pluginElement, PluginDescriptor pluginDescriptor) {
        String requiredId = pluginElement.getAttribute("id");
        DescriptorParser.assertAttributeIsNotEmpty(pluginDescriptor, requiredId, "id");
        String requiredName = pluginElement.getAttribute("name");
        DescriptorParser.assertAttributeIsNotEmpty(pluginDescriptor, requiredName, "name");
        String requiredVersion = pluginElement.getAttribute("version");
        DescriptorParser.assertAttributeIsNotEmpty(pluginDescriptor, requiredVersion, "version");
        pluginDescriptor.setName(requiredName);
        pluginDescriptor.setId(requiredId);
        pluginDescriptor.setVersion(requiredVersion);
        pluginDescriptor.setProviderName(pluginElement.getAttribute("provider-name"));
        pluginDescriptor.setClassName(pluginElement.getAttribute("class"));
    }

    private static void assertAttributeIsNotEmpty(PluginDescriptor descriptor, String attribute, String attrName) {
        if ("".equals(attribute.trim())) {
            throw new IllegalArgumentException("Descriptor of plugin=" + descriptor.getLocation() + " is missing required attribute=" + attrName);
        }
    }

    private static void handleRequiresElements(NodeList requiresElements, PluginDescriptor pluginDescriptor) {
        if (requiresElements != null && requiresElements.getLength() != 0) {
            if (requiresElements.getLength() != 1) {
                throw new IllegalArgumentException("There can be only one <requires> element in " + pluginDescriptor.myLocationUrl);
            }
            Element element = (Element)requiresElements.item(0);
            NodeList imports = element.getElementsByTagName("import");
            if (imports == null || imports.getLength() < 1) {
                throw new IllegalArgumentException("<requires> element must have 1+ <import> in " + pluginDescriptor.myLocationUrl);
            }
            for (int i = 0; imports != null && i < imports.getLength(); ++i) {
                Element imported = (Element)imports.item(i);
                String requiredPluginId = imported.getAttribute("plugin");
                if ("org.eclipse.core.runtime".equals(requiredPluginId)) continue;
                pluginDescriptor.addRequiredPluginId(requiredPluginId);
            }
        }
    }

    private static void handleRuntimeElements(NodeList runtimeElements, PluginDescriptor pluginDescriptor) {
        if (runtimeElements != null && runtimeElements.getLength() != 0) {
            if (runtimeElements.getLength() != 1) {
                throw new IllegalArgumentException("There can be only one <runtime> element in " + pluginDescriptor.myLocationUrl);
            }
            Element element = (Element)runtimeElements.item(0);
            NodeList libraries = element.getElementsByTagName("library");
            if (libraries == null || libraries.getLength() < 1) {
                throw new IllegalArgumentException("<runtime> element must have 1+ <library> in " + pluginDescriptor.myLocationUrl);
            }
            for (int i = 0; libraries != null && i < libraries.getLength(); ++i) {
                Element library = (Element)libraries.item(i);
                String relativePath = library.getAttribute("name");
                pluginDescriptor.addRuntimeLibrary(relativePath);
            }
        }
    }

    private static void handleExtensionPointElements(NodeList extensionPoints, PluginDescriptor pluginDescriptor) {
        for (int i = 0; extensionPoints != null && i < extensionPoints.getLength(); ++i) {
            Element element = (Element)extensionPoints.item(i);
            String label = element.getAttribute("name");
            String uniqueIdentifier = element.getAttribute("id");
            String schemaReference = element.getAttribute("schema");
            pluginDescriptor.addExtensionPointDescriptor(uniqueIdentifier, label, schemaReference);
        }
    }

    private static void handleExtensionElements(NodeList extensionElements, PluginDescriptor pluginDescriptor) {
        for (int i = 0; extensionElements != null && i < extensionElements.getLength(); ++i) {
            Element element = (Element)extensionElements.item(i);
            String label = element.getAttribute("name");
            String id = element.getAttribute("id");
            String pointId = element.getAttribute("point");
            NodeList configurationTags = element.getElementsByTagName("*");
            pluginDescriptor.addExtension(id, label, pointId, configurationTags);
        }
    }

    static {
        try {
            myDocumentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Boot.LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (FactoryConfigurationError e) {
            Boot.LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

