/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.util.ArrayList;
import java.util.logging.Level;
import org.bardsoftware.eclipsito.Boot;
import org.bardsoftware.impl.eclipsito.PluginDescriptor;

public class DependencyResolver {
    private final MarkedDescriptor[] myMarkedDescriptors;

    public DependencyResolver(PluginDescriptor[] descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException("Cannot resolve null descriptors");
        }
        this.myMarkedDescriptors = new MarkedDescriptor[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            this.myMarkedDescriptors[i] = new MarkedDescriptor(descriptors[i]);
        }
    }

    public PluginDescriptor[] resolveAll() {
        int i;
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        for (i = 0; i < this.myMarkedDescriptors.length; ++i) {
            this.markAndSweep(this.myMarkedDescriptors[i]);
        }
        for (i = 0; i < this.myMarkedDescriptors.length; ++i) {
            if (!this.myMarkedDescriptors[i].isResolved()) continue;
            result.add(this.myMarkedDescriptors[i].myDescriptor);
        }
        return result.toArray(new PluginDescriptor[result.size()]);
    }

    private boolean markAndSweep(MarkedDescriptor marked) {
        boolean result = false;
        if (marked.isMarked()) {
            result = false;
        } else if (marked.isResolved()) {
            result = true;
        } else {
            marked.mark();
            String[] children = marked.myDescriptor.getRequiredPluginIds();
            boolean allChildrenResolved = true;
            for (int i = 0; children != null && i < children.length; ++i) {
                MarkedDescriptor child = this.getMarkedById(children[i]);
                if (child == null) {
                    Boot.LOG.log(Level.WARNING, "Found unknown required plugin " + children[i] + ",\n    please, correct " + marked.myDescriptor.myLocationUrl.getPath() + ",\n    plugin " + marked.myDescriptor.getId() + " is ignored!");
                    allChildrenResolved = false;
                    break;
                }
                if (this.markAndSweep(child)) continue;
                Boot.LOG.log(Level.WARNING, "Found dependency cycle plugin " + children[i] + ",\n    please, correct " + marked.myDescriptor.myLocationUrl.getPath() + ",\n    plugin " + marked.myDescriptor.getId() + " is ignored!");
                allChildrenResolved = false;
                break;
            }
            if (allChildrenResolved) {
                marked.resolve();
                result = true;
            }
        }
        return result;
    }

    private MarkedDescriptor getMarkedById(String id) {
        for (int i = 0; i < this.myMarkedDescriptors.length; ++i) {
            if (!this.myMarkedDescriptors[i].myDescriptor.getId().equals(id)) continue;
            return this.myMarkedDescriptors[i];
        }
        return null;
    }

    public PluginDescriptor[] getUsingBundles(PluginDescriptor descriptor) {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        block0: for (int i = 0; i < this.myMarkedDescriptors.length; ++i) {
            MarkedDescriptor marked = this.myMarkedDescriptors[i];
            if (marked.myDescriptor == descriptor || !marked.isResolved()) continue;
            String[] childrendIds = marked.myDescriptor.getRequiredPluginIds();
            for (int j = 0; childrendIds != null && j < childrendIds.length; ++j) {
                if (!marked.myDescriptor.getId().equals(childrendIds[j])) continue;
                result.add(marked.myDescriptor);
                continue block0;
            }
        }
        return result.toArray(new PluginDescriptor[result.size()]);
    }

    protected static class MarkedDescriptor {
        private static byte INIT = 0;
        private static byte MARKED = 1;
        private static byte RESOLVED = (byte)2;
        public final PluginDescriptor myDescriptor;
        private byte myState;

        public MarkedDescriptor(PluginDescriptor descriptor) {
            this.myDescriptor = descriptor;
            this.myState = INIT;
        }

        public void mark() {
            this.myState = MARKED;
        }

        public void resolve() {
            this.myState = RESOLVED;
        }

        public boolean isMarked() {
            return this.myState == MARKED;
        }

        public boolean isResolved() {
            return this.myState == RESOLVED;
        }
    }
}

