/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.osgi.framework.Bundle;

public class BundleClassLoader
extends URLClassLoader {
    static final String PACKED_JAR = "org.bardsoftware.eclipsito.packedjar";
    private ArrayList myParentBundles = new ArrayList();

    public BundleClassLoader() {
        super(new URL[0]);
    }

    public BundleClassLoader(URL[] defaultUrls, ClassLoader mainParent) {
        super(new URL[0], mainParent);
        for (int i = 0; i < defaultUrls.length; ++i) {
            URL next = defaultUrls[i];
            if (next.getProtocol().equals(PACKED_JAR) && next.getFile().endsWith(".jar")) {
                super.addURL(this.unpackJar(next));
                continue;
            }
            super.addURL(next);
        }
    }

    protected URL unpackJar(URL packedJarUrl) {
        assert (packedJarUrl != null && PACKED_JAR.equals(packedJarUrl.getProtocol()));
        String className = packedJarUrl.getHost();
        InputStream in = null;
        try {
            Class<?> clazz = Class.forName(className);
            String path = packedJarUrl.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((in = clazz.getClassLoader().getResourceAsStream(path)) == null) {
                throw new RuntimeException("Failed to access input stream addressed by path=" + packedJarUrl.getPath() + " of URL=" + packedJarUrl);
            }
            File file = File.createTempFile("org.bardsoftware.eclipsito.WebStartBootImpl-", ".jar");
            if (file == null) {
                throw new RuntimeException("Null file created");
            }
            this.saveStream(in, file);
            URL uRL = file.toURL();
            return uRL;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to find class mentioned in packed JAR URL=" + packedJarUrl, e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to extract jar addressed by url=" + packedJarUrl, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to extract jar addressed by url=" + packedJarUrl, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStream(InputStream inputStream, File outFile) throws IOException {
        FileOutputStream out = new FileOutputStream(outFile);
        try {
            int bytes_read;
            byte[] buf = new byte[4096];
            while ((bytes_read = inputStream.read(buf)) != -1) {
                out.write(buf, 0, bytes_read);
            }
        }
        finally {
            out.close();
        }
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    public void addParent(Bundle dependencyBundle) {
        this.myParentBundles.add(dependencyBundle);
    }

    protected Bundle[] parents() {
        return (Bundle[])this.myParentBundles.toArray(new BundleClassLoader[this.myParentBundles.size()]);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Class result = null;
        for (int i = 0; i < this.myParentBundles.size(); ++i) {
            Bundle nextParent = (Bundle)this.myParentBundles.get(i);
            try {
                result = nextParent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (result != null) break;
        }
        if (result == null) {
            result = super.findClass(name);
        }
        return result;
    }
}

