/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.bardsoftware.eclipsito.Boot;
import org.bardsoftware.impl.eclipsito.ApplicationLauncher;
import org.bardsoftware.impl.eclipsito.ModulesDirectoryProcessor;
import org.bardsoftware.impl.eclipsito.PlatformImpl;
import org.bardsoftware.impl.eclipsito.PluginDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootImpl
extends Boot {
    private static final ThreadGroup topThreadGroup = new ThreadGroup("TopThreadGroup"){

        public void uncaughtException(Thread t, Throwable e) {
            Boot.LOG.log(Level.WARNING, "[uncaughtException]" + e, e);
        }
    };
    private PlatformImpl myPlatform;

    @Override
    public void run(String application, File modulesDir, String descriptorPattern, List<String> args) {
        this.myPlatform = new PlatformImpl();
        Boot.LOG.info("Eclipsito platform is running.");
        ShutdownHook.install();
        PluginDescriptor[] plugins = this.getPlugins(modulesDir, descriptorPattern);
        this.run(plugins, application, args.toArray(new String[args.size()]));
    }

    protected PluginDescriptor[] getPlugins(File pluginDirFile, String descriptorPattern) {
        assert (pluginDirFile.exists() && pluginDirFile.isDirectory()) : "Plugin directory doesn't exist or is not a directory: " + pluginDirFile;
        Boot.LOG.info("Searching for plugins in " + pluginDirFile);
        PluginDescriptor[] plugins = ModulesDirectoryProcessor.process(pluginDirFile, descriptorPattern);
        return plugins;
    }

    public void run(PluginDescriptor[] plugins, final String application, final String[] args) {
        if (plugins.length == 0) {
            Boot.LOG.severe("No plugins found");
        }
        Boot.LOG.info("Command line args: " + Arrays.asList(args));
        this.myPlatform.setup(plugins);
        new Thread(topThreadGroup, "Start"){

            public void run() {
                BootImpl.this.myPlatform.start();
                if (application != null && application.length() > 0) {
                    ApplicationLauncher.launchApplication(application, args);
                }
            }
        }.start();
    }

    @Override
    public void shutdown() {
        this.myPlatform.stop();
        Boot.LOG.info("Eclipsito platform is shut down.");
    }

    private static class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super(topThreadGroup, "ShutdownHook-Thread");
            this.setPriority(10);
        }

        public void run() {
            Boot.getInstance().shutdown();
        }

        public static void install() {
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        }
    }
}

