/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.util.logging.Level;
import org.bardsoftware.eclipsito.Boot;
import org.bardsoftware.impl.eclipsito.PluginDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;

public class ApplicationLauncher {
    static final PluginDescriptor.ExtensionPointDescriptor ourRuntimeApplicationExtensionPoint = new PluginDescriptor.ExtensionPointDescriptor("applications", "org.eclipse.core.runtime", null, null);
    static final String ourAppsPointId = ourRuntimeApplicationExtensionPoint.getId();

    static void launchApplication(String applicationId, String[] commandLineArgs) {
        IConfigurationElement runElement = ApplicationLauncher.findAndValidateConfigForApplication(applicationId);
        if (runElement == null) {
            throw new IllegalArgumentException("Could not launch application " + applicationId);
        }
        try {
            IPlatformRunnable runnable = (IPlatformRunnable)runElement.createExecutableExtension("class");
            runnable.run(commandLineArgs);
        }
        catch (Exception e) {
            Boot.LOG.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private static IConfigurationElement findAndValidateConfigForApplication(String applicationId) {
        IExtensionPoint point;
        IConfigurationElement result = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null && (point = registry.getExtensionPoint(ourAppsPointId)) != null) {
            IExtension[] applications = point.getExtensions();
            for (int i = 0; applications != null && i < applications.length; ++i) {
                if (!applications[i].getUniqueIdentifier().equals(applicationId)) continue;
                IConfigurationElement[] appElements = applications[i].getConfigurationElements();
                if (appElements != null && appElements.length > 0 && "application".equals(appElements[0].getName())) {
                    IConfigurationElement[] runElements = appElements[0].getChildren("run");
                    if (runElements == null) break;
                    if (runElements.length == 1) {
                        result = runElements[0];
                        break;
                    }
                    throw new IllegalStateException("Application " + applicationId + " must have one <run> element");
                }
                throw new IllegalStateException("Extension " + applicationId + " must have one <application> element");
            }
        }
        return result;
    }
}

