/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.commons.net.ftp.FTPFileFilters;

public class FTPListParseEngine {
    private List<String> entries = new LinkedList<String>();
    private ListIterator<String> _internalIterator = this.entries.listIterator();
    private final FTPFileEntryParser parser;

    public FTPListParseEngine(FTPFileEntryParser fTPFileEntryParser) {
        this.parser = fTPFileEntryParser;
    }

    public void readServerList(InputStream inputStream, String string) throws IOException {
        this.entries = new LinkedList<String>();
        this.readStream(inputStream, string);
        this.parser.preParse(this.entries);
        this.resetIterator();
    }

    private void readStream(InputStream inputStream, String string) throws IOException {
        BufferedReader bufferedReader = string == null ? new BufferedReader(new InputStreamReader(inputStream)) : new BufferedReader(new InputStreamReader(inputStream, string));
        String string2 = this.parser.readNextEntry(bufferedReader);
        while (string2 != null) {
            this.entries.add(string2);
            string2 = this.parser.readNextEntry(bufferedReader);
        }
        bufferedReader.close();
    }

    public FTPFile[] getNext(int n) {
        LinkedList<FTPFile> linkedList = new LinkedList<FTPFile>();
        for (int i = n; i > 0 && this._internalIterator.hasNext(); --i) {
            String string = this._internalIterator.next();
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            linkedList.add(fTPFile);
        }
        return linkedList.toArray(new FTPFile[linkedList.size()]);
    }

    public FTPFile[] getPrevious(int n) {
        LinkedList<FTPFile> linkedList = new LinkedList<FTPFile>();
        for (int i = n; i > 0 && this._internalIterator.hasPrevious(); --i) {
            String string = this._internalIterator.previous();
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            linkedList.add(0, fTPFile);
        }
        return linkedList.toArray(new FTPFile[linkedList.size()]);
    }

    public FTPFile[] getFiles() throws IOException {
        return this.getFiles(FTPFileFilters.NON_NULL);
    }

    public FTPFile[] getFiles(FTPFileFilter fTPFileFilter) throws IOException {
        ArrayList<FTPFile> arrayList = new ArrayList<FTPFile>();
        for (String string : this.entries) {
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            if (!fTPFileFilter.accept(fTPFile)) continue;
            arrayList.add(fTPFile);
        }
        return arrayList.toArray(new FTPFile[arrayList.size()]);
    }

    public boolean hasNext() {
        return this._internalIterator.hasNext();
    }

    public boolean hasPrevious() {
        return this._internalIterator.hasPrevious();
    }

    public void resetIterator() {
        this._internalIterator = this.entries.listIterator();
    }

    @Deprecated
    public void readServerList(InputStream inputStream) throws IOException {
        this.readServerList(inputStream, null);
    }
}

