/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ProtocolCommandSupport;

public abstract class SocketClient {
    public static final String NETASCII_EOL = "\r\n";
    private static final SocketFactory __DEFAULT_SOCKET_FACTORY = SocketFactory.getDefault();
    private static final ServerSocketFactory __DEFAULT_SERVER_SOCKET_FACTORY = ServerSocketFactory.getDefault();
    private ProtocolCommandSupport __commandSupport;
    protected int _timeout_ = 0;
    protected Socket _socket_ = null;
    protected int _defaultPort_ = 0;
    protected InputStream _input_ = null;
    protected OutputStream _output_ = null;
    protected SocketFactory _socketFactory_ = __DEFAULT_SOCKET_FACTORY;
    protected ServerSocketFactory _serverSocketFactory_ = __DEFAULT_SERVER_SOCKET_FACTORY;
    private static final int DEFAULT_CONNECT_TIMEOUT = 0;
    protected int connectTimeout = 0;
    private int receiveBufferSize = -1;
    private int sendBufferSize = -1;

    protected void _connectAction_() throws IOException {
        this._socket_.setSoTimeout(this._timeout_);
        this._input_ = this._socket_.getInputStream();
        this._output_ = this._socket_.getOutputStream();
    }

    public void connect(InetAddress inetAddress, int n) throws SocketException, IOException {
        this._socket_ = this._socketFactory_.createSocket();
        if (this.receiveBufferSize != -1) {
            this._socket_.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize != -1) {
            this._socket_.setSendBufferSize(this.sendBufferSize);
        }
        this._socket_.connect(new InetSocketAddress(inetAddress, n), this.connectTimeout);
        this._connectAction_();
    }

    public void connect(String string, int n) throws SocketException, IOException {
        this.connect(InetAddress.getByName(string), n);
    }

    public void connect(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws SocketException, IOException {
        this._socket_ = this._socketFactory_.createSocket();
        if (this.receiveBufferSize != -1) {
            this._socket_.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize != -1) {
            this._socket_.setSendBufferSize(this.sendBufferSize);
        }
        this._socket_.bind(new InetSocketAddress(inetAddress2, n2));
        this._socket_.connect(new InetSocketAddress(inetAddress, n), this.connectTimeout);
        this._connectAction_();
    }

    public void connect(String string, int n, InetAddress inetAddress, int n2) throws SocketException, IOException {
        this.connect(InetAddress.getByName(string), n, inetAddress, n2);
    }

    public void connect(InetAddress inetAddress) throws SocketException, IOException {
        this.connect(inetAddress, this._defaultPort_);
    }

    public void connect(String string) throws SocketException, IOException {
        this.connect(string, this._defaultPort_);
    }

    public void disconnect() throws IOException {
        this.closeQuietly(this._socket_);
        this.closeQuietly(this._input_);
        this.closeQuietly(this._output_);
        this._socket_ = null;
        this._input_ = null;
        this._output_ = null;
    }

    private void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isConnected() {
        if (this._socket_ == null) {
            return false;
        }
        return this._socket_.isConnected();
    }

    public boolean isAvailable() {
        if (this.isConnected()) {
            try {
                if (this._socket_.getInetAddress() == null) {
                    return false;
                }
                if (this._socket_.getPort() == 0) {
                    return false;
                }
                if (this._socket_.getRemoteSocketAddress() == null) {
                    return false;
                }
                if (this._socket_.isClosed()) {
                    return false;
                }
                if (this._socket_.isInputShutdown()) {
                    return false;
                }
                if (this._socket_.isOutputShutdown()) {
                    return false;
                }
                this._socket_.getInputStream();
                this._socket_.getOutputStream();
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void setDefaultPort(int n) {
        this._defaultPort_ = n;
    }

    public int getDefaultPort() {
        return this._defaultPort_;
    }

    public void setDefaultTimeout(int n) {
        this._timeout_ = n;
    }

    public int getDefaultTimeout() {
        return this._timeout_;
    }

    public void setSoTimeout(int n) throws SocketException {
        this._socket_.setSoTimeout(n);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.sendBufferSize = n;
    }

    protected int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.receiveBufferSize = n;
    }

    protected int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSoTimeout() throws SocketException {
        return this._socket_.getSoTimeout();
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this._socket_.setTcpNoDelay(bl);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this._socket_.getTcpNoDelay();
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this._socket_.setKeepAlive(bl);
    }

    public boolean getKeepAlive() throws SocketException {
        return this._socket_.getKeepAlive();
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this._socket_.setSoLinger(bl, n);
    }

    public int getSoLinger() throws SocketException {
        return this._socket_.getSoLinger();
    }

    public int getLocalPort() {
        return this._socket_.getLocalPort();
    }

    public InetAddress getLocalAddress() {
        return this._socket_.getLocalAddress();
    }

    public int getRemotePort() {
        return this._socket_.getPort();
    }

    public InetAddress getRemoteAddress() {
        return this._socket_.getInetAddress();
    }

    public boolean verifyRemote(Socket socket) {
        InetAddress inetAddress = socket.getInetAddress();
        InetAddress inetAddress2 = this.getRemoteAddress();
        return inetAddress.equals(inetAddress2);
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this._socketFactory_ = socketFactory == null ? __DEFAULT_SOCKET_FACTORY : socketFactory;
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this._serverSocketFactory_ = serverSocketFactory == null ? __DEFAULT_SERVER_SOCKET_FACTORY : serverSocketFactory;
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this._serverSocketFactory_;
    }

    public void addProtocolCommandListener(ProtocolCommandListener protocolCommandListener) {
        this.getCommandSupport().addProtocolCommandListener(protocolCommandListener);
    }

    public void removeProtocolCommandListener(ProtocolCommandListener protocolCommandListener) {
        this.getCommandSupport().removeProtocolCommandListener(protocolCommandListener);
    }

    protected void fireReplyReceived(int n, String string) {
        if (this.getCommandSupport().getListenerCount() > 0) {
            this.getCommandSupport().fireReplyReceived(n, string);
        }
    }

    protected void fireCommandSent(String string, String string2) {
        if (this.getCommandSupport().getListenerCount() > 0) {
            this.getCommandSupport().fireCommandSent(string, string2);
        }
    }

    protected void createCommandSupport() {
        this.__commandSupport = new ProtocolCommandSupport(this);
    }

    protected ProtocolCommandSupport getCommandSupport() {
        return this.__commandSupport;
    }
}

