/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.cache;

import com.ettrema.cache.Cache;
import com.ettrema.cache.OrderedMap;
import com.ettrema.common.Service;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCache<K, T>
implements Cache<K, T>,
Service {
    private static final Logger log = LoggerFactory.getLogger(MemoryCache.class);
    private static final String IN_PROGRESS = "__in_progress";
    private final String name;
    private long highWater;
    private long lowWater;
    private final Thread clearer;
    private final Cache<K, T> auxillary;
    private final OrderedMap<K, Object> map;
    private long memHits;
    private long auxHits;
    private long misses;
    private long numFlushed;
    private boolean started;
    private int lowMemoryLimit = 10;

    public MemoryCache(String name, int highWater, int lowWater) {
        this.name = name;
        this.map = new OrderedMap();
        if (highWater < lowWater) {
            throw new IllegalArgumentException("highWater must be greater then lowWater");
        }
        this.highWater = highWater;
        this.lowWater = lowWater;
        this.clearer = new Thread(new Clearer());
        this.clearer.setDaemon(true);
        this.auxillary = null;
    }

    public MemoryCache(int highWater, int lowWater, Cache<K, T> auxillary) {
        this.name = auxillary.getName() + " Memory";
        this.map = new OrderedMap();
        if (highWater < lowWater) {
            throw new IllegalArgumentException("highWater must be greater then lowWater");
        }
        this.highWater = highWater;
        this.lowWater = lowWater;
        this.clearer = new Thread(new Clearer());
        this.clearer.setDaemon(true);
        this.auxillary = auxillary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T loadData(K key, Cache.Creator<K, T> creator) throws InterruptedException {
        Object data;
        MemoryCache memoryCache = this;
        synchronized (memoryCache) {
            data = this.map.get(key);
            while (data == IN_PROGRESS) {
                this.wait();
                data = this.get(key);
            }
            if (data == null) {
                this.map.put(key, IN_PROGRESS);
            }
        }
        if (data == null) {
            try {
                data = creator.createCacheItem(key);
            }
            finally {
                memoryCache = this;
                synchronized (memoryCache) {
                    this._put(key, data);
                    this.notifyAll();
                }
            }
        }
        return (T)data;
    }

    @Override
    public Long getSize() {
        return this.map.size();
    }

    public void start() {
        log.debug("starting MemoryCache: " + this.name);
        this.started = true;
        this.clearer.start();
    }

    public void stop() {
        this.started = false;
        this.clearer.interrupt();
    }

    @Override
    public void put(K key, T val) {
        this._put(key, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _put(K key, Object val) {
        OrderedMap<K, Object> orderedMap = this.map;
        synchronized (orderedMap) {
            this.map.put(key, val);
            if (this.auxillary != null) {
                this.auxillary.remove(key);
            }
        }
    }

    @Override
    public T get(K key) {
        long tm = 0L;
        if (log.isTraceEnabled()) {
            log.trace("get: cache: " + this.name + " - key: " + key);
            tm = System.nanoTime();
        }
        Object val = this.map.get(key);
        if (log.isTraceEnabled()) {
            log.trace("query time: " + (tm -= System.nanoTime()) + "ns  found=" + (val != null));
        }
        if (val == null) {
            if (this.auxillary != null) {
                val = this.auxillary.get(key);
                if (val != null) {
                    this.put(key, val);
                    ++this.auxHits;
                    ++this.misses;
                } else {
                    log.trace("local cache miss and auxilliary cache miss");
                    ++this.misses;
                }
            } else {
                log.trace("local cache miss");
                ++this.misses;
            }
        } else {
            ++this.memHits;
        }
        return (T)val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        OrderedMap<K, Object> orderedMap = this.map;
        synchronized (orderedMap) {
            this.map.clear();
        }
        if (this.auxillary != null) {
            this.auxillary.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        if (this.auxillary != null) {
            this.auxillary.remove(key);
        }
        OrderedMap<K, Object> orderedMap = this.map;
        synchronized (orderedMap) {
            this.map.remove(key);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getHits() {
        return this.memHits;
    }

    @Override
    public long getMisses() {
        return this.misses;
    }

    public int getLowMemoryLimit() {
        return this.lowMemoryLimit;
    }

    public void setLowMemoryLimit(int lowMemoryLimit) {
        this.lowMemoryLimit = lowMemoryLimit;
    }

    public long getHighWater() {
        return this.highWater;
    }

    public class Clearer
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (MemoryCache.this.started) {
                    if (this.compactRequired()) {
                        log.debug("removing old keys: freeMemory: " + Runtime.getRuntime().freeMemory() + " max Memory: " + Runtime.getRuntime().maxMemory());
                        long currentSize = MemoryCache.this.getSize();
                        long newLimit = currentSize > MemoryCache.this.highWater ? MemoryCache.this.lowWater : currentSize / 2L;
                        long removed = 0L;
                        while (MemoryCache.this.getSize() > newLimit) {
                            OrderedMap orderedMap = MemoryCache.this.map;
                            synchronized (orderedMap) {
                                ++removed;
                                this.removeOneKey();
                            }
                            Thread.sleep(1L);
                        }
                        System.gc();
                        log.info("removed keys: " + removed);
                        log.info("finished removing old keys: freeMemory: " + Runtime.getRuntime().freeMemory() + " max Memory: " + Runtime.getRuntime().maxMemory());
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug("clearer interrupted");
            }
            finally {
                log.warn("clearer finished: " + MemoryCache.this.getName() + "------------------------------------------");
            }
        }

        private void removeOneKey() {
            Object val;
            Map.Entry entry = MemoryCache.this.map.removeFirst();
            if (MemoryCache.this.auxillary != null && (val = entry.getValue()) != MemoryCache.IN_PROGRESS) {
                MemoryCache.this.auxillary.put(entry.getKey(), val);
                MemoryCache.this.numFlushed++;
            }
        }

        private boolean compactRequired() {
            if ((long)MemoryCache.this.map.size() > MemoryCache.this.highWater) {
                log.info("highwater exceeded: " + MemoryCache.this.getName() + " highwater: " + MemoryCache.this.highWater + " size: " + MemoryCache.this.getSize());
                return true;
            }
            if ((long)MemoryCache.this.map.size() > MemoryCache.this.lowWater) {
                long free = Runtime.getRuntime().freeMemory();
                long total = Runtime.getRuntime().totalMemory();
                long max = Runtime.getRuntime().maxMemory();
                long actualFree = max - total + free;
                long actualPerc = actualFree * 100L / max;
                if (actualPerc < (long)MemoryCache.this.lowMemoryLimit) {
                    log.warn("Memory free: " + actualPerc + "% of max: " + max / 1000000L + "Mb");
                    log.warn("Free memory below " + MemoryCache.this.lowMemoryLimit + "% so compacting cache: " + MemoryCache.this.getName() + " Old Highwater: " + MemoryCache.this.highWater + " Current Size: " + MemoryCache.this.getSize());
                    MemoryCache.this.highWater = MemoryCache.this.getSize();
                    MemoryCache.this.lowWater = MemoryCache.this.highWater / 2L;
                    log.warn("Adjusted high/low water marks due to low memory. New highwater: " + MemoryCache.this.highWater + " new low water: " + MemoryCache.this.lowWater);
                    return true;
                }
                if (log.isDebugEnabled()) {
                    log.debug("memory free: " + actualPerc + "% of max: " + max / 1000000L + "Mb");
                }
            }
            return false;
        }
    }
}

