/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.cache;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.ObjectBuffer;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.StringSerializer;
import com.ettrema.cache.ObjectSerializer;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class KryoObjectSerializer
implements ObjectSerializer {
    private final Kryo kryo = new Kryo();

    public KryoObjectSerializer(List<Class> classesToSerialize) {
        this.kryo.register(UUID.class, (Serializer)new UUIDSerializer());
        this.kryo.register(ArrayList.class);
        this.kryo.register(byte[].class);
        this.kryo.register(Timestamp.class, (Serializer)new TimestampSerializer());
        this.kryo.register(Class.class, (Serializer)new ClassSerializer());
        for (Class c : classesToSerialize) {
            this.kryo.register(c);
        }
    }

    @Override
    public byte[] keyToBytes(Object key) {
        ByteBuffer bb = ByteBuffer.allocate(1000);
        this.kryo.writeClassAndObject(bb, key);
        return bb.array();
    }

    @Override
    public Object loadData(byte[] data) {
        ObjectBuffer objectBuffer = new ObjectBuffer(this.kryo, 1000, 10000000);
        Object o = objectBuffer.readClassAndObject(data);
        return o;
    }

    @Override
    public byte[] valueToBytes(Object val) {
        ObjectBuffer objectBuffer = new ObjectBuffer(this.kryo, 1000, 10000000);
        try {
            return objectBuffer.writeClassAndObject(val);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldnt serialize class of type: " + val.getClass(), e);
        }
    }

    private class UUIDSerializer
    extends Serializer {
        public void writeObjectData(ByteBuffer buffer, Object object) {
            UUID id = (UUID)object;
            StringSerializer.put((ByteBuffer)buffer, (String)id.toString());
        }

        public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
            String s = StringSerializer.get((ByteBuffer)buffer);
            UUID id = UUID.fromString(s);
            return (T)id;
        }
    }

    private class ClassSerializer
    extends Serializer {
        private ClassSerializer() {
        }

        public void writeObjectData(ByteBuffer buffer, Object object) {
            Class ts = (Class)object;
            StringSerializer.put((ByteBuffer)buffer, (String)ts.getName());
        }

        public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
            Class<?> c;
            String s = StringSerializer.get((ByteBuffer)buffer);
            try {
                c = Class.forName(s);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Couldnt load class: " + s, ex);
            }
            return (T)c;
        }
    }

    private class TimestampSerializer
    extends Serializer {
        private TimestampSerializer() {
        }

        public void writeObjectData(ByteBuffer buffer, Object object) {
            Timestamp ts = (Timestamp)object;
            buffer.putLong(ts.getTime());
        }

        public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
            long t = buffer.getLong();
            return (T)new Timestamp(t);
        }
    }
}

