/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskIoHandler {
    private static final Logger log = LoggerFactory.getLogger(DiskIoHandler.class);
    private static final int MAX_NESTED_DIRS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadData(File f) throws FileNotFoundException {
        FileInputStream fin = new FileInputStream(f);
        BufferedInputStream bufin = new BufferedInputStream(fin);
        ObjectInputStream oin = null;
        try {
            try {
                oin = new ObjectInputStream(bufin);
            }
            catch (IOException ex) {
                log.error("Failed to read: " + f.getAbsolutePath(), (Throwable)ex);
                Object var6_9 = null;
                try {
                    fin.close();
                }
                catch (IOException ex2) {
                    log.warn("exception closing input stream");
                }
                return var6_9;
            }
            Object ex = oin.readObject();
            return ex;
        }
        finally {
            try {
                fin.close();
            }
            catch (IOException ex) {
                log.warn("exception closing input stream");
            }
        }
    }

    public File locateFolder(File root, String key, boolean create) {
        return this.locateFolder(root, 0, key.toCharArray(), create);
    }

    public File locateFolder(File parent, int pos, char[] key, boolean create) {
        if (pos >= key.length - 1 || pos >= 3) {
            return parent;
        }
        char c = key[pos];
        String s = "" + c;
        File next = new File(parent, s);
        if (!next.exists()) {
            if (create) {
                if (!next.mkdir()) {
                    throw new RuntimeException("Failed to create: " + next.getAbsolutePath());
                }
            } else {
                return null;
            }
        }
        return this.locateFolder(next, ++pos, key, create);
    }

    public void saveData(Object val, File dataFile) {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(dataFile);
            BufferedOutputStream bufout = new BufferedOutputStream(fout);
            ObjectOutputStream oos = new ObjectOutputStream(bufout);
            oos.writeObject(val);
            bufout.flush();
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                fout.close();
            }
            catch (IOException ex) {
                log.error("extends closing fout");
            }
        }
    }

    public void delete(File f) {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                this.delete(child);
            }
        }
        if (!f.delete()) {
            throw new RuntimeException("Failed to delete: " + f.getAbsolutePath());
        }
    }
}

