/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.cache;

import com.ettrema.cache.ObjectSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultObjectSerializer
implements ObjectSerializer {
    private static final Logger log = LoggerFactory.getLogger(DefaultObjectSerializer.class);

    @Override
    public byte[] keyToBytes(Object key) {
        String keyStr = key.toString();
        return keyStr.getBytes();
    }

    @Override
    public byte[] valueToBytes(Object val) {
        if (val == null) {
            throw new NullPointerException("value cannot be null");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            byte[] arr;
            ObjectOutputStream oos = new ObjectOutputStream(bout);
            oos.writeObject(val);
            byte[] byArray = arr = bout.toByteArray();
            return byArray;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException ex) {
                log.error("extends closing fout");
            }
        }
    }

    @Override
    public Object loadData(byte[] data) {
        ObjectInputStream oin = null;
        try {
            Object o;
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            oin = new ObjectInputStream(bin);
            Object object = o = oin.readObject();
            return object;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                oin.close();
            }
            catch (IOException ex) {
                log.error("exeption closing oin");
            }
        }
    }
}

