/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.cache;

import com.ettrema.cache.DiskIoHandler;
import com.ettrema.cache.DiskManager;
import com.ettrema.common.Service;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDiskManager<K, T>
implements DiskManager<K, T>,
Service {
    private static final Logger log = LoggerFactory.getLogger(DefaultDiskManager.class);
    private final File root;
    private final DiskIoHandler handler;

    public DefaultDiskManager(File root) {
        if (root == null) {
            throw new IllegalArgumentException("root folder may not be null");
        }
        if (root.exists() && !root.isDirectory()) {
            throw new IllegalArgumentException("root must be a folder: " + root.getAbsolutePath());
        }
        this.root = root;
        this.handler = new DiskIoHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T fromDisk(K key) {
        long l = System.nanoTime();
        try {
            String keyStr = key.toString();
            File parent = this.handler.locateFolder(this.root, keyStr, false);
            File dataFile = new File(parent, keyStr);
            if (!dataFile.exists()) {
                T t = null;
                return t;
            }
            Object object = this.handler.loadData(dataFile);
            return (T)object;
        }
        finally {
            l = System.nanoTime() - l;
            log.debug("disk access3: " + l + "ns");
        }
    }

    @Override
    public void toDisk(K key, T val) {
        String keyStr = key.toString();
        File parent = this.handler.locateFolder(this.root, keyStr, true);
        File dataFile = new File(parent, keyStr);
        if (dataFile.exists() && !dataFile.delete()) {
            throw new RuntimeException("Couldnt delete dataFile: " + dataFile.getAbsolutePath());
        }
        this.handler.saveData(val, dataFile);
    }

    @Override
    public void remove(K key) {
        String keyStr = key.toString();
        File parent = this.handler.locateFolder(this.root, keyStr, false);
        File dataFile = new File(parent, keyStr);
        if (dataFile.exists() && !dataFile.delete()) {
            throw new RuntimeException("Failed to delete: " + dataFile.getAbsolutePath());
        }
    }

    @Override
    public void flush() {
        log.debug("flush");
        for (File child : this.root.listFiles()) {
            log.warn(" - " + child.getAbsolutePath());
            this.handler.delete(child);
        }
    }

    public File getRoot() {
        return this.root;
    }

    public void start() {
        if (!this.root.exists()) {
            log.warn("cache root does not exist, attempting to create it: " + this.root.getAbsolutePath());
            if (!this.root.mkdirs()) {
                throw new RuntimeException("Root path does not exist, and cant create it: " + this.root.getAbsolutePath());
            }
        }
    }

    public void stop() {
    }
}

