/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.cache;

import com.ettrema.cache.BerkeleyDb;
import com.ettrema.cache.DefaultDiskManager;
import com.ettrema.cache.DefaultObjectSerializer;
import com.ettrema.cache.DiskManager;
import com.ettrema.cache.ObjectSerializer;
import com.ettrema.common.Service;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyDiskManager<K, T>
implements DiskManager<K, T>,
Service {
    private static final Logger log = LoggerFactory.getLogger(DefaultDiskManager.class);
    private final String name;
    private final BerkeleyDb berkeleyDb;
    private final ObjectSerializer objectSerializer;
    private final boolean flushOnStart;
    private Database db;

    public BerkeleyDiskManager(String name, BerkeleyDb berkeleyDb, ObjectSerializer objectSerializer, boolean flushOnStart) {
        this.name = name;
        this.berkeleyDb = berkeleyDb;
        this.objectSerializer = objectSerializer;
        this.flushOnStart = flushOnStart;
    }

    public BerkeleyDiskManager(String name, BerkeleyDb berkeleyDb) {
        this.name = name;
        this.berkeleyDb = berkeleyDb;
        this.objectSerializer = new DefaultObjectSerializer();
        this.flushOnStart = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T fromDisk(K key) {
        long t = System.nanoTime();
        if (this.db == null) {
            throw new RuntimeException("Not started yet");
        }
        byte[] keyBytes = this.objectSerializer.keyToBytes(key);
        DatabaseEntry keyDb = new DatabaseEntry(keyBytes);
        DatabaseEntry valDb = new DatabaseEntry();
        if (log.isTraceEnabled()) {
            log.trace("time a: " + (System.nanoTime() - t) + "ns");
            t = System.nanoTime();
        }
        try {
            this.db.get(null, keyDb, valDb, LockMode.READ_UNCOMMITTED);
        }
        catch (DatabaseException ex) {
            throw new RuntimeException(ex);
        }
        if (log.isTraceEnabled()) {
            log.trace("time b: " + (System.nanoTime() - t) + "ns");
            t = System.nanoTime();
        }
        try {
            byte[] valBytes = valDb.getData();
            if (valBytes == null) {
                if (log.isTraceEnabled()) {
                    log.trace("time c1: " + (System.nanoTime() - t) + "ns");
                    t = System.nanoTime();
                }
                T t2 = null;
                return t2;
            }
            if (log.isTraceEnabled()) {
                log.trace("time c2a: " + (System.nanoTime() - t) + "ns");
                t = System.nanoTime();
            }
            Object val = this.objectSerializer.loadData(valDb.getData());
            if (log.isTraceEnabled()) {
                log.trace("time c2b: " + (System.nanoTime() - t) + "ns");
                t = System.nanoTime();
            }
            Object object = val;
            return (T)object;
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace("time d: " + (System.nanoTime() - t) + "ns");
            }
        }
    }

    @Override
    public void toDisk(K key, T val) {
        byte[] keyBytes = this.objectSerializer.keyToBytes(key);
        DatabaseEntry keyDb = new DatabaseEntry(keyBytes);
        byte[] data = this.objectSerializer.valueToBytes(val);
        DatabaseEntry valDb = new DatabaseEntry(data);
        try {
            this.db.put(null, keyDb, valDb);
        }
        catch (DatabaseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void remove(K key) {
        try {
            byte[] keyBytes = this.objectSerializer.keyToBytes(key);
            DatabaseEntry keyDb = new DatabaseEntry(keyBytes);
            this.db.delete(null, keyDb);
        }
        catch (DatabaseException ex) {
            throw new RuntimeException("Failed to delete: " + key, ex);
        }
    }

    @Override
    public void flush() {
        this.berkeleyDb.deleteDatabase(this.name);
    }

    public void start() {
        if (this.flushOnStart) {
            this.berkeleyDb.deleteDatabase(this.name);
        }
        this.db = this.berkeleyDb.openDatabase(this.name);
    }

    public void stop() {
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (DatabaseException ex) {
                log.error("Exception closing", (Throwable)ex);
            }
            catch (Throwable e) {
                log.error("Exception closing", e);
            }
        }
        this.db = null;
    }
}

