/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.cache;

import com.ettrema.common.Service;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyDb
implements Service {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyDb.class);
    private final File root;
    private Environment environment;
    private DatabaseConfig databaseConfig;
    private int cachingMemPercent = 1;

    public BerkeleyDb(File root) {
        this.root = root;
    }

    public void start() {
        if (!this.root.exists()) {
            log.warn("Attempting to create cache root: " + this.root.getAbsolutePath());
            if (!this.root.mkdirs()) {
                throw new RuntimeException("Cache root directory does not exist and cannot create it: " + this.root.getAbsolutePath());
            }
        }
        try {
            EnvironmentConfig environmentConfig = new EnvironmentConfig();
            environmentConfig.setAllowCreate(true);
            environmentConfig.setTransactional(false);
            environmentConfig.setLocking(false);
            environmentConfig.setCachePercent(this.cachingMemPercent);
            this.environment = new Environment(this.root, environmentConfig);
            this.databaseConfig = new DatabaseConfig();
            this.databaseConfig.setDeferredWrite(true);
            this.databaseConfig.setAllowCreate(true);
        }
        catch (DatabaseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Database openDatabase(String name) {
        try {
            Database db = this.environment.openDatabase(null, name, this.databaseConfig);
            return db;
        }
        catch (DatabaseException ex) {
            throw new RuntimeException(name, ex);
        }
    }

    public void deleteDatabase(String name) {
        try {
            this.environment.truncateDatabase(null, name, false);
        }
        catch (DatabaseException ex) {
            log.warn("Exception removing database, which might mean it just doesnt exist: " + ex.getMessage());
        }
    }

    public void stop() {
        try {
            this.environment.close();
        }
        catch (DatabaseException ex) {
            log.error("exception closing berkeley db: " + this.root.getAbsolutePath(), (Throwable)ex);
        }
    }

    public int getCachingMemPercent() {
        return this.cachingMemPercent;
    }

    public void setCachingMemPercent(int cachingMemPercent) {
        this.cachingMemPercent = cachingMemPercent;
    }
}

