/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import net.fortuna.ical4j.model.AbstractContentFactory;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Comment;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.Contact;
import net.fortuna.ical4j.model.property.Country;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.ExtendedAddress;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Locality;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.LocationType;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Name;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.PercentComplete;
import net.fortuna.ical4j.model.property.Postalcode;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.model.property.Region;
import net.fortuna.ical4j.model.property.RelatedTo;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.RequestStatus;
import net.fortuna.ical4j.model.property.Resources;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.StreetAddress;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Tel;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzName;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;
import net.fortuna.ical4j.model.property.TzUrl;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;

public class PropertyFactoryImpl
extends AbstractContentFactory
implements PropertyFactory {
    private static final long serialVersionUID = -7174232004486979641L;
    private static PropertyFactoryImpl instance = new PropertyFactoryImpl();

    protected PropertyFactoryImpl() {
        this.registerDefaultFactory("ACTION", new ActionFactory());
        this.registerDefaultFactory("ATTACH", new AttachFactory());
        this.registerDefaultFactory("ATTENDEE", new AttendeeFactory());
        this.registerDefaultFactory("CALSCALE", new CalScaleFactory());
        this.registerDefaultFactory("CATEGORIES", new CategoriesFactory());
        this.registerDefaultFactory("CLASS", new ClazzFactory());
        this.registerDefaultFactory("COMMENT", new CommentFactory());
        this.registerDefaultFactory("COMPLETED", new CompletedFactory());
        this.registerDefaultFactory("CONTACT", new ContactFactory());
        this.registerDefaultFactory("COUNTRY", new CountryFactory());
        this.registerDefaultFactory("CREATED", new CreatedFactory());
        this.registerDefaultFactory("DESCRIPTION", new DescriptionFactory());
        this.registerDefaultFactory("DTEND", new DtEndFactory());
        this.registerDefaultFactory("DTSTAMP", new DtStampFactory());
        this.registerDefaultFactory("DTSTART", new DtStartFactory());
        this.registerDefaultFactory("DUE", new DueFactory());
        this.registerDefaultFactory("DURATION", new DurationFactory());
        this.registerDefaultFactory("EXDATE", new ExDateFactory());
        this.registerDefaultFactory("EXRULE", new ExRuleFactory());
        this.registerDefaultFactory("EXTENDED-ADDRESS", new ExtendedAddressFactory());
        this.registerDefaultFactory("FREEBUSY", new FreeBusyFactory());
        this.registerDefaultFactory("GEO", new GeoFactory());
        this.registerDefaultFactory("LAST-MODIFIED", new LastModifiedFactory());
        this.registerDefaultFactory("LOCALITY", new LocalityFactory());
        this.registerDefaultFactory("LOCATION", new LocationFactory());
        this.registerDefaultFactory("LOCATION-TYPE", new LocationTypeFactory());
        this.registerDefaultFactory("METHOD", new MethodFactory());
        this.registerDefaultFactory("NAME", new NameFactory());
        this.registerDefaultFactory("ORGANIZER", new OrganizerFactory());
        this.registerDefaultFactory("PERCENT-COMPLETE", new PercentCompleteFactory());
        this.registerDefaultFactory("POSTAL-CODE", new PostalcodeFactory());
        this.registerDefaultFactory("PRIORITY", new PriorityFactory());
        this.registerDefaultFactory("PRODID", new ProdIdFactory());
        this.registerDefaultFactory("RDATE", new RDateFactory());
        this.registerDefaultFactory("RECURRENCE-ID", new RecurrenceIdFactory());
        this.registerDefaultFactory("REGION", new RegionFactory());
        this.registerDefaultFactory("RELATED-TO", new RelatedToFactory());
        this.registerDefaultFactory("REPEAT", new RepeatFactory());
        this.registerDefaultFactory("REQUEST-STATUS", new RequestStatusFactory());
        this.registerDefaultFactory("RESOURCES", new ResourcesFactory());
        this.registerDefaultFactory("RRULE", new RRuleFactory());
        this.registerDefaultFactory("SEQUENCE", new SequenceFactory());
        this.registerDefaultFactory("STATUS", new StatusFactory());
        this.registerDefaultFactory("STREET-ADDRESS", new StreetAddressFactory());
        this.registerDefaultFactory("SUMMARY", new SummaryFactory());
        this.registerDefaultFactory("TEL", new TelFactory());
        this.registerDefaultFactory("TRANSP", new TranspFactory());
        this.registerDefaultFactory("TRIGGER", new TriggerFactory());
        this.registerDefaultFactory("TZID", new TzIdFactory());
        this.registerDefaultFactory("TZNAME", new TzNameFactory());
        this.registerDefaultFactory("TZOFFSETFROM", new TzOffsetFromFactory());
        this.registerDefaultFactory("TZOFFSETTO", new TzOffsetToFactory());
        this.registerDefaultFactory("TZURL", new TzUrlFactory());
        this.registerDefaultFactory("UID", new UidFactory());
        this.registerDefaultFactory("URL", new UrlFactory());
        this.registerDefaultFactory("VERSION", new VersionFactory());
    }

    public static PropertyFactoryImpl getInstance() {
        return instance;
    }

    public Property createProperty(String name) {
        PropertyFactory factory = (PropertyFactory)this.getFactory(name);
        if (factory != null) {
            return factory.createProperty(name);
        }
        if (this.isExperimentalName(name)) {
            return new XProperty(name);
        }
        if (this.allowIllegalNames()) {
            return new XProperty(name);
        }
        throw new IllegalArgumentException("Illegal property [" + name + "]");
    }

    public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
        PropertyFactory factory = (PropertyFactory)this.getFactory(name);
        if (factory != null) {
            return factory.createProperty(name, parameters, value);
        }
        if (this.isExperimentalName(name)) {
            return new XProperty(name, parameters, value);
        }
        if (this.allowIllegalNames()) {
            return new XProperty(name, parameters, value);
        }
        throw new IllegalArgumentException("Illegal property [" + name + "]");
    }

    private boolean isExperimentalName(String name) {
        return name.startsWith("X-") && name.length() > "X-".length();
    }

    private static class ActionFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private ActionFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Action(parameters, value);
        }

        public Property createProperty(String name) {
            return new Action();
        }
    }

    private static class AttachFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private AttachFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Attach(parameters, value);
        }

        public Property createProperty(String name) {
            return new Attach();
        }
    }

    private static class AttendeeFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private AttendeeFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Attendee(parameters, value);
        }

        public Property createProperty(String name) {
            return new Attendee();
        }
    }

    private static class CalScaleFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private CalScaleFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new CalScale(parameters, value);
        }

        public Property createProperty(String name) {
            return new CalScale();
        }
    }

    private static class CategoriesFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private CategoriesFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Categories(parameters, value);
        }

        public Property createProperty(String name) {
            return new Categories();
        }
    }

    private static class ClazzFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private ClazzFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Clazz(parameters, value);
        }

        public Property createProperty(String name) {
            return new Clazz();
        }
    }

    private static class CommentFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private CommentFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Comment(parameters, value);
        }

        public Property createProperty(String name) {
            return new Comment();
        }
    }

    private static class CompletedFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private CompletedFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Completed(parameters, value);
        }

        public Property createProperty(String name) {
            return new Completed();
        }
    }

    private static class ContactFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private ContactFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Contact(parameters, value);
        }

        public Property createProperty(String name) {
            return new Contact();
        }
    }

    private static class CountryFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private CountryFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Country(parameters, value);
        }

        public Property createProperty(String name) {
            return new Country();
        }
    }

    private static class CreatedFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private CreatedFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Created(parameters, value);
        }

        public Property createProperty(String name) {
            return new Created();
        }
    }

    private static class DescriptionFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private DescriptionFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Description(parameters, value);
        }

        public Property createProperty(String name) {
            return new Description();
        }
    }

    private static class DtEndFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private DtEndFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new DtEnd(parameters, value);
        }

        public Property createProperty(String name) {
            return new DtEnd();
        }
    }

    private static class DtStampFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private DtStampFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new DtStamp(parameters, value);
        }

        public Property createProperty(String name) {
            return new DtStamp();
        }
    }

    private static class DtStartFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private DtStartFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new DtStart(parameters, value);
        }

        public Property createProperty(String name) {
            return new DtStart();
        }
    }

    private static class DueFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private DueFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Due(parameters, value);
        }

        public Property createProperty(String name) {
            return new Due();
        }
    }

    private static class DurationFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private DurationFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Duration(parameters, value);
        }

        public Property createProperty(String name) {
            return new Duration();
        }
    }

    private static class ExDateFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private ExDateFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new ExDate(parameters, value);
        }

        public Property createProperty(String name) {
            return new ExDate();
        }
    }

    private static class ExRuleFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private ExRuleFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new ExRule(parameters, value);
        }

        public Property createProperty(String name) {
            return new ExRule();
        }
    }

    private static class ExtendedAddressFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private ExtendedAddressFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new ExtendedAddress(parameters, value);
        }

        public Property createProperty(String name) {
            return new ExtendedAddress();
        }
    }

    private static class FreeBusyFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private FreeBusyFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new FreeBusy(parameters, value);
        }

        public Property createProperty(String name) {
            return new FreeBusy();
        }
    }

    private static class GeoFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private GeoFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Geo(parameters, value);
        }

        public Property createProperty(String name) {
            return new Geo();
        }
    }

    private static class LastModifiedFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private LastModifiedFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new LastModified(parameters, value);
        }

        public Property createProperty(String name) {
            return new LastModified();
        }
    }

    private static class LocalityFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private LocalityFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Locality(parameters, value);
        }

        public Property createProperty(String name) {
            return new Locality();
        }
    }

    private static class LocationFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private LocationFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Location(parameters, value);
        }

        public Property createProperty(String name) {
            return new Location();
        }
    }

    private static class LocationTypeFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private LocationTypeFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new LocationType(parameters, value);
        }

        public Property createProperty(String name) {
            return new LocationType();
        }
    }

    private static class MethodFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private MethodFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Method(parameters, value);
        }

        public Property createProperty(String name) {
            return new Method();
        }
    }

    private static class NameFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private NameFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Name(parameters, value);
        }

        public Property createProperty(String name) {
            return new Name();
        }
    }

    private static class OrganizerFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private OrganizerFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Organizer(parameters, value);
        }

        public Property createProperty(String name) {
            return new Organizer();
        }
    }

    private static class PercentCompleteFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private PercentCompleteFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new PercentComplete(parameters, value);
        }

        public Property createProperty(String name) {
            return new PercentComplete();
        }
    }

    private static class PostalcodeFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private PostalcodeFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Postalcode(parameters, value);
        }

        public Property createProperty(String name) {
            return new Postalcode();
        }
    }

    private static class PriorityFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private PriorityFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Priority(parameters, value);
        }

        public Property createProperty(String name) {
            return new Priority();
        }
    }

    private static class ProdIdFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private ProdIdFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new ProdId(parameters, value);
        }

        public Property createProperty(String name) {
            return new ProdId();
        }
    }

    private static class RDateFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private RDateFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new RDate(parameters, value);
        }

        public Property createProperty(String name) {
            return new RDate();
        }
    }

    private static class RRuleFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private RRuleFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new RRule(parameters, value);
        }

        public Property createProperty(String name) {
            return new RRule();
        }
    }

    private static class RecurrenceIdFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private RecurrenceIdFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new RecurrenceId(parameters, value);
        }

        public Property createProperty(String name) {
            return new RecurrenceId();
        }
    }

    private static class RegionFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private RegionFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Region(parameters, value);
        }

        public Property createProperty(String name) {
            return new Region();
        }
    }

    private static class RelatedToFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private RelatedToFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new RelatedTo(parameters, value);
        }

        public Property createProperty(String name) {
            return new RelatedTo();
        }
    }

    private static class RepeatFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private RepeatFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Repeat(parameters, value);
        }

        public Property createProperty(String name) {
            return new Repeat();
        }
    }

    private static class RequestStatusFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private RequestStatusFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new RequestStatus(parameters, value);
        }

        public Property createProperty(String name) {
            return new RequestStatus();
        }
    }

    private static class ResourcesFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private ResourcesFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Resources(parameters, value);
        }

        public Property createProperty(String name) {
            return new Resources();
        }
    }

    private static class SequenceFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private SequenceFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Sequence(parameters, value);
        }

        public Property createProperty(String name) {
            return new Sequence();
        }
    }

    private static class StatusFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private StatusFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Status(parameters, value);
        }

        public Property createProperty(String name) {
            return new Status();
        }
    }

    private static class StreetAddressFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private StreetAddressFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new StreetAddress(parameters, value);
        }

        public Property createProperty(String name) {
            return new StreetAddress();
        }
    }

    private static class SummaryFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private SummaryFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Summary(parameters, value);
        }

        public Property createProperty(String name) {
            return new Summary();
        }
    }

    private static class TelFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private TelFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Tel(parameters, value);
        }

        public Property createProperty(String name) {
            return new Tel();
        }
    }

    private static class TranspFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private TranspFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Transp(parameters, value);
        }

        public Property createProperty(String name) {
            return new Transp();
        }
    }

    private static class TriggerFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private TriggerFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Trigger(parameters, value);
        }

        public Property createProperty(String name) {
            return new Trigger();
        }
    }

    private static class TzIdFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private TzIdFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new TzId(parameters, value);
        }

        public Property createProperty(String name) {
            return new TzId();
        }
    }

    private static class TzNameFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private TzNameFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new TzName(parameters, value);
        }

        public Property createProperty(String name) {
            return new TzName();
        }
    }

    private static class TzOffsetFromFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private TzOffsetFromFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new TzOffsetFrom(parameters, value);
        }

        public Property createProperty(String name) {
            return new TzOffsetFrom();
        }
    }

    private static class TzOffsetToFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private TzOffsetToFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new TzOffsetTo(parameters, value);
        }

        public Property createProperty(String name) {
            return new TzOffsetTo();
        }
    }

    private static class TzUrlFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private TzUrlFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new TzUrl(parameters, value);
        }

        public Property createProperty(String name) {
            return new TzUrl();
        }
    }

    private static class UidFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private UidFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Uid(parameters, value);
        }

        public Property createProperty(String name) {
            return new Uid();
        }
    }

    private static class UrlFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private UrlFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Url(parameters, value);
        }

        public Property createProperty(String name) {
            return new Url();
        }
    }

    private static class VersionFactory
    implements PropertyFactory {
        private static final long serialVersionUID = 1L;

        private VersionFactory() {
        }

        public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
            return new Version(parameters, value);
        }

        public Property createProperty(String name) {
            return new Version();
        }
    }
}

