/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import java.math.BigInteger;

@GwtCompatible
final class MathPreconditions {
    static int checkPositive(String string, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(string + " (" + n + ") must be > 0");
        }
        return n;
    }

    static long checkPositive(String string, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(string + " (" + l + ") must be > 0");
        }
        return l;
    }

    static BigInteger checkPositive(String string, BigInteger bigInteger) {
        if (bigInteger.signum() <= 0) {
            throw new IllegalArgumentException(string + " (" + bigInteger + ") must be > 0");
        }
        return bigInteger;
    }

    static int checkNonNegative(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException(string + " (" + n + ") must be >= 0");
        }
        return n;
    }

    static long checkNonNegative(String string, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(string + " (" + l + ") must be >= 0");
        }
        return l;
    }

    static BigInteger checkNonNegative(String string, BigInteger bigInteger) {
        if (Preconditions.checkNotNull(bigInteger).signum() < 0) {
            throw new IllegalArgumentException(string + " (" + bigInteger + ") must be >= 0");
        }
        return bigInteger;
    }

    static void checkRoundingUnnecessary(boolean bl) {
        if (!bl) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRange(boolean bl) {
        if (!bl) {
            throw new ArithmeticException("not in range");
        }
    }

    static void checkNoOverflow(boolean bl) {
        if (!bl) {
            throw new ArithmeticException("overflow");
        }
    }

    private MathPreconditions() {
    }
}

