/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.AbstractSortedMultiset;
import com.google.common.collect.BoundType;
import com.google.common.collect.BstAggregate;
import com.google.common.collect.BstCountBasedBalancePolicies;
import com.google.common.collect.BstInOrderPath;
import com.google.common.collect.BstModificationResult;
import com.google.common.collect.BstModifier;
import com.google.common.collect.BstMutationResult;
import com.google.common.collect.BstMutationRule;
import com.google.common.collect.BstNode;
import com.google.common.collect.BstNodeFactory;
import com.google.common.collect.BstOperations;
import com.google.common.collect.BstPathFactory;
import com.google.common.collect.BstRangeOps;
import com.google.common.collect.BstSide;
import com.google.common.collect.GeneralRange;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.Serialization;
import com.google.common.collect.SortedMultiset;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class TreeMultiset<E>
extends AbstractSortedMultiset<E>
implements Serializable {
    private final transient GeneralRange<E> range;
    private final transient Reference<Node<E>> rootReference;
    private static final BstAggregate<Node<Object>> DISTINCT_AGGREGATE = new BstAggregate<Node<Object>>(){

        @Override
        public int entryValue(Node<Object> node) {
            return 1;
        }

        @Override
        public long treeValue(@Nullable Node<Object> node) {
            return TreeMultiset.distinctOrZero(node);
        }
    };
    private static final BstAggregate<Node<Object>> SIZE_AGGREGATE = new BstAggregate<Node<Object>>(){

        @Override
        public int entryValue(Node<Object> node) {
            return node.elemCount();
        }

        @Override
        public long treeValue(@Nullable Node<Object> node) {
            return TreeMultiset.sizeOrZero(node);
        }
    };
    private static final BstNodeFactory<Node<Object>> NODE_FACTORY = new BstNodeFactory<Node<Object>>(){

        @Override
        public Node<Object> createNode(Node<Object> node, @Nullable Node<Object> node2, @Nullable Node<Object> node3) {
            return new Node<Object>(node.getKey(), node.elemCount(), node2, node3);
        }
    };
    @GwtIncompatible(value="not needed in emulated source")
    private static final long serialVersionUID = 1L;

    public static <E extends Comparable> TreeMultiset<E> create() {
        return new TreeMultiset(Ordering.natural());
    }

    public static <E> TreeMultiset<E> create(@Nullable Comparator<? super E> comparator) {
        return comparator == null ? new TreeMultiset(Ordering.natural()) : new TreeMultiset<E>(comparator);
    }

    public static <E extends Comparable> TreeMultiset<E> create(Iterable<? extends E> iterable) {
        TreeMultiset<E> treeMultiset = TreeMultiset.create();
        Iterables.addAll(treeMultiset, iterable);
        return treeMultiset;
    }

    @Override
    public Iterator<E> iterator() {
        return super.iterator();
    }

    private TreeMultiset(Comparator<? super E> comparator) {
        super(comparator);
        this.range = GeneralRange.all(comparator);
        this.rootReference = new Reference();
    }

    private TreeMultiset(GeneralRange<E> generalRange, Reference<Node<E>> reference) {
        super(generalRange.comparator());
        this.range = generalRange;
        this.rootReference = reference;
    }

    E checkElement(Object object) {
        return (E)object;
    }

    @Override
    int distinctElements() {
        Node<E> node = this.rootReference.get();
        return Ints.checkedCast(BstRangeOps.totalInRange(this.distinctAggregate(), this.range, node));
    }

    @Override
    public int size() {
        Node<E> node = this.rootReference.get();
        return Ints.saturatedCast(BstRangeOps.totalInRange(this.sizeAggregate(), this.range, node));
    }

    @Override
    public int count(@Nullable Object object) {
        try {
            E e = this.checkElement(object);
            if (this.range.contains(e)) {
                Node node = (Node)BstOperations.seek(this.comparator(), (BstNode)this.rootReference.get(), e);
                return TreeMultiset.countOrZero(node);
            }
            return 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    private int mutate(@Nullable E e, MultisetModifier multisetModifier) {
        BstMutationRule bstMutationRule = BstMutationRule.createRule(multisetModifier, BstCountBasedBalancePolicies.singleRebalancePolicy(this.distinctAggregate()), this.nodeFactory());
        BstMutationResult<E, BstNode> bstMutationResult = BstOperations.mutate(this.comparator(), bstMutationRule, (BstNode)this.rootReference.get(), e);
        if (!this.rootReference.compareAndSet((Node<E>)bstMutationResult.getOriginalRoot(), (Node<E>)bstMutationResult.getChangedRoot())) {
            throw new ConcurrentModificationException();
        }
        Node node = (Node)bstMutationResult.getOriginalTarget();
        return TreeMultiset.countOrZero(node);
    }

    @Override
    public int add(E e, int n) {
        this.checkElement(e);
        if (n == 0) {
            return this.count(e);
        }
        Preconditions.checkArgument(this.range.contains(e));
        return this.mutate(e, new AddModifier(n));
    }

    @Override
    public int remove(@Nullable Object object, int n) {
        if (object == null) {
            return 0;
        }
        if (n == 0) {
            return this.count(object);
        }
        try {
            E e = this.checkElement(object);
            return this.range.contains(e) ? this.mutate(e, new RemoveModifier(n)) : 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    @Override
    public boolean setCount(E e, int n, int n2) {
        this.checkElement(e);
        Preconditions.checkArgument(this.range.contains(e));
        return this.mutate(e, new ConditionalSetCountModifier(n, n2)) == n;
    }

    @Override
    public int setCount(E e, int n) {
        this.checkElement(e);
        Preconditions.checkArgument(this.range.contains(e));
        return this.mutate(e, new SetCountModifier(n));
    }

    private BstPathFactory<Node<E>, BstInOrderPath<Node<E>>> pathFactory() {
        return BstInOrderPath.inOrderFactory();
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        Node<E> node = this.rootReference.get();
        BstInOrderPath bstInOrderPath = (BstInOrderPath)((Object)BstRangeOps.furthestPath(this.range, BstSide.LEFT, this.pathFactory(), node));
        return this.iteratorInDirection(bstInOrderPath, BstSide.RIGHT);
    }

    @Override
    Iterator<Multiset.Entry<E>> descendingEntryIterator() {
        Node<E> node = this.rootReference.get();
        BstInOrderPath bstInOrderPath = (BstInOrderPath)((Object)BstRangeOps.furthestPath(this.range, BstSide.RIGHT, this.pathFactory(), node));
        return this.iteratorInDirection(bstInOrderPath, BstSide.LEFT);
    }

    private Iterator<Multiset.Entry<E>> iteratorInDirection(@Nullable BstInOrderPath<Node<E>> bstInOrderPath, final BstSide bstSide) {
        final AbstractSequentialIterator abstractSequentialIterator = new AbstractSequentialIterator<BstInOrderPath<Node<E>>>(bstInOrderPath){

            @Override
            protected BstInOrderPath<Node<E>> computeNext(BstInOrderPath<Node<E>> bstInOrderPath) {
                if (!bstInOrderPath.hasNext(bstSide)) {
                    return null;
                }
                BstInOrderPath bstInOrderPath2 = bstInOrderPath.next(bstSide);
                return TreeMultiset.this.range.contains(((Node)bstInOrderPath2.getTip()).getKey()) ? bstInOrderPath2 : null;
            }
        };
        return new Iterator<Multiset.Entry<E>>(){
            E toRemove = null;

            @Override
            public boolean hasNext() {
                return abstractSequentialIterator.hasNext();
            }

            @Override
            public Multiset.Entry<E> next() {
                BstInOrderPath bstInOrderPath = (BstInOrderPath)abstractSequentialIterator.next();
                this.toRemove = ((Node)bstInOrderPath.getTip()).getKey();
                return new LiveEntry(this.toRemove, ((Node)bstInOrderPath.getTip()).elemCount());
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.toRemove != null);
                TreeMultiset.this.setCount(this.toRemove, 0);
                this.toRemove = null;
            }
        };
    }

    @Override
    public void clear() {
        Node<E> node;
        Node<E> node2 = this.rootReference.get();
        if (!this.rootReference.compareAndSet(node2, node = BstRangeOps.minusRange(this.range, BstCountBasedBalancePolicies.fullRebalancePolicy(this.distinctAggregate()), this.nodeFactory(), node2))) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public SortedMultiset<E> headMultiset(E e, BoundType boundType) {
        Preconditions.checkNotNull(e);
        return new TreeMultiset<E>(this.range.intersect(GeneralRange.upTo(this.comparator, e, boundType)), this.rootReference);
    }

    @Override
    public SortedMultiset<E> tailMultiset(E e, BoundType boundType) {
        Preconditions.checkNotNull(e);
        return new TreeMultiset<E>(this.range.intersect(GeneralRange.downTo(this.comparator, e, boundType)), this.rootReference);
    }

    @Override
    public Comparator<? super E> comparator() {
        return super.comparator();
    }

    private static long sizeOrZero(@Nullable Node<?> node) {
        return node == null ? 0L : ((Node)node).size;
    }

    private static int distinctOrZero(@Nullable Node<?> node) {
        return node == null ? 0 : ((Node)node).distinct;
    }

    private static int countOrZero(@Nullable Node<?> node) {
        return node == null ? 0 : node.elemCount();
    }

    private BstAggregate<Node<E>> distinctAggregate() {
        return DISTINCT_AGGREGATE;
    }

    private BstAggregate<Node<E>> sizeAggregate() {
        return SIZE_AGGREGATE;
    }

    private BstNodeFactory<Node<E>> nodeFactory() {
        return NODE_FACTORY;
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.elementSet().comparator());
        Serialization.writeMultiset(this, objectOutputStream);
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Comparator comparator = (Comparator)objectInputStream.readObject();
        Serialization.getFieldSetter(AbstractSortedMultiset.class, "comparator").set((AbstractSortedMultiset)this, comparator);
        Serialization.getFieldSetter(TreeMultiset.class, "range").set(this, GeneralRange.all(comparator));
        Serialization.getFieldSetter(TreeMultiset.class, "rootReference").set(this, new Reference());
        Serialization.populateMultiset(this, objectInputStream);
    }

    private final class ConditionalSetCountModifier
    extends MultisetModifier {
        private final int expectedCount;
        private final int setCount;

        private ConditionalSetCountModifier(int n, int n2) {
            Preconditions.checkArgument(n2 >= 0 & n >= 0);
            this.expectedCount = n;
            this.setCount = n2;
        }

        @Override
        int newCount(int n) {
            return n == this.expectedCount ? this.setCount : n;
        }
    }

    private final class SetCountModifier
    extends MultisetModifier {
        private final int countToSet;

        private SetCountModifier(int n) {
            Preconditions.checkArgument(n >= 0);
            this.countToSet = n;
        }

        @Override
        int newCount(int n) {
            return this.countToSet;
        }
    }

    private final class RemoveModifier
    extends MultisetModifier {
        private final int countToRemove;

        private RemoveModifier(int n) {
            Preconditions.checkArgument(n > 0);
            this.countToRemove = n;
        }

        @Override
        int newCount(int n) {
            return Math.max(0, n - this.countToRemove);
        }
    }

    private final class AddModifier
    extends MultisetModifier {
        private final int countToAdd;

        private AddModifier(int n) {
            Preconditions.checkArgument(n > 0);
            this.countToAdd = n;
        }

        @Override
        int newCount(int n) {
            Preconditions.checkArgument(this.countToAdd <= Integer.MAX_VALUE - n, "Cannot add this many elements");
            return n + this.countToAdd;
        }
    }

    private abstract class MultisetModifier
    implements BstModifier<E, Node<E>> {
        private MultisetModifier() {
        }

        abstract int newCount(int var1);

        @Override
        @Nullable
        public BstModificationResult<Node<E>> modify(E e, @Nullable Node<E> node) {
            int n;
            int n2 = TreeMultiset.countOrZero(node);
            if (n2 == (n = this.newCount(n2))) {
                return BstModificationResult.identity(node);
            }
            if (n == 0) {
                return BstModificationResult.rebalancingChange(node, null);
            }
            if (n2 == 0) {
                return BstModificationResult.rebalancingChange(null, new Node(e, n));
            }
            return BstModificationResult.rebuildingChange(node, new Node(node.getKey(), n));
        }
    }

    private static final class Node<E>
    extends BstNode<E, Node<E>>
    implements Serializable {
        private final long size;
        private final int distinct;
        private static final long serialVersionUID = 0L;

        private Node(E e, int n, @Nullable Node<E> node, @Nullable Node<E> node2) {
            super(e, node, node2);
            Preconditions.checkArgument(n > 0);
            this.size = (long)n + TreeMultiset.sizeOrZero(node) + TreeMultiset.sizeOrZero(node2);
            this.distinct = 1 + TreeMultiset.distinctOrZero(node) + TreeMultiset.distinctOrZero(node2);
        }

        int elemCount() {
            long l = this.size - TreeMultiset.sizeOrZero((Node)this.childOrNull(BstSide.LEFT)) - TreeMultiset.sizeOrZero((Node)this.childOrNull(BstSide.RIGHT));
            return Ints.checkedCast(l);
        }

        private Node(E e, int n) {
            this(e, n, null, null);
        }
    }

    class LiveEntry
    extends Multisets.AbstractEntry<E> {
        private Node<E> expectedRoot;
        private final E element;
        private int count;

        private LiveEntry(E e, int n) {
            this.expectedRoot = (Node)TreeMultiset.this.rootReference.get();
            this.element = e;
            this.count = n;
        }

        @Override
        public E getElement() {
            return this.element;
        }

        @Override
        public int getCount() {
            if (TreeMultiset.this.rootReference.get() == this.expectedRoot) {
                return this.count;
            }
            this.expectedRoot = (Node)TreeMultiset.this.rootReference.get();
            this.count = TreeMultiset.this.count(this.element);
            return this.count;
        }
    }

    static final class Reference<T> {
        T value;

        public T get() {
            return this.value;
        }

        public boolean compareAndSet(T t, T t2) {
            if (this.value == t) {
                this.value = t2;
                return true;
            }
            return false;
        }
    }
}

