/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import java.util.List;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableList<E>
extends ImmutableList<E> {
    private final transient int offset;
    private final transient int size;
    private final transient Object[] array;

    RegularImmutableList(Object[] objectArray, int n, int n2) {
        this.offset = n;
        this.size = n2;
        this.array = objectArray;
    }

    RegularImmutableList(Object[] objectArray) {
        this(objectArray, 0, objectArray.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    boolean isPartialView() {
        return this.offset != 0 || this.size != this.array.length;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.array, this.offset, this.size);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        System.arraycopy(this.array, this.offset, objectArray, 0, this.size);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length < this.size) {
            TArray = ObjectArrays.newArray(TArray, this.size);
        } else if (TArray.length > this.size) {
            TArray[this.size] = null;
        }
        System.arraycopy(this.array, this.offset, TArray, 0, this.size);
        return TArray;
    }

    @Override
    public E get(int n) {
        Preconditions.checkElementIndex(n, this.size);
        return (E)this.array[n + this.offset];
    }

    @Override
    public int indexOf(@Nullable Object object) {
        if (object != null) {
            for (int i = this.offset; i < this.offset + this.size; ++i) {
                if (!this.array[i].equals(object)) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        if (object != null) {
            for (int i = this.offset + this.size - 1; i >= this.offset; --i) {
                if (!this.array[i].equals(object)) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    @Override
    public ImmutableList<E> subList(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.size);
        return n == n2 ? ImmutableList.of() : new RegularImmutableList<E>(this.array, this.offset + n, n2 - n);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int n) {
        return new AbstractIndexedListIterator<E>(this.size, n){

            @Override
            protected E get(int n) {
                return RegularImmutableList.this.array[n + RegularImmutableList.this.offset];
            }
        };
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        int n = this.offset;
        if (object instanceof RegularImmutableList) {
            RegularImmutableList regularImmutableList = (RegularImmutableList)object;
            for (int i = regularImmutableList.offset; i < regularImmutableList.offset + regularImmutableList.size; ++i) {
                if (this.array[n++].equals(regularImmutableList.array[i])) continue;
                return false;
            }
        } else {
            for (Object e : list) {
                if (this.array[n++].equals(e)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = this.offset; i < this.offset + this.size; ++i) {
            n = 31 * n + this.array[i].hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(this.size()).append('[').append(this.array[this.offset]);
        for (int i = this.offset + 1; i < this.offset + this.size; ++i) {
            stringBuilder.append(", ").append(this.array[i]);
        }
        return stringBuilder.append(']').toString();
    }
}

