/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.MapMaker;
import java.lang.reflect.Array;

@GwtCompatible(emulated=true)
class Platform {
    static <T> T[] clone(T[] TArray) {
        return (Object[])TArray.clone();
    }

    static void unsafeArrayCopy(Object[] objectArray, int n, Object[] objectArray2, int n2, int n3) {
        System.arraycopy(objectArray, n, objectArray2, n2, n3);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    static <T> T[] newArray(Class<T> clazz, int n) {
        return (Object[])Array.newInstance(clazz, n);
    }

    static <T> T[] newArray(T[] TArray, int n) {
        Class<?> clazz = TArray.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        return objectArray;
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    private Platform() {
    }
}

