/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Equivalence;
import com.google.common.base.Equivalences;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ForwardingSortedMap;
import com.google.common.collect.ImmutableEntry;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMapDifference;
import com.google.common.collect.Synchronized;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class Maps {
    static final Joiner.MapJoiner STANDARD_JOINER = Collections2.STANDARD_JOINER.withKeyValueSeparator("=");

    private Maps() {
    }

    static <K> Function<Map.Entry<K, ?>, K> keyFunction() {
        return EntryFunction.KEY;
    }

    static <V> Function<Map.Entry<?, V>, V> valueFunction() {
        return EntryFunction.VALUE;
    }

    static <K, V> Iterator<K> keyIterator(Iterator<Map.Entry<K, V>> iterator) {
        return Iterators.transform(iterator, Maps.keyFunction());
    }

    static <K, V> Iterator<V> valueIterator(Iterator<Map.Entry<K, V>> iterator) {
        return Iterators.transform(iterator, Maps.valueFunction());
    }

    static <K, V> UnmodifiableIterator<V> valueIterator(final UnmodifiableIterator<Map.Entry<K, V>> unmodifiableIterator) {
        return new UnmodifiableIterator<V>(){

            @Override
            public boolean hasNext() {
                return unmodifiableIterator.hasNext();
            }

            @Override
            public V next() {
                return ((Map.Entry)unmodifiableIterator.next()).getValue();
            }
        };
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int n) {
        return new HashMap(Maps.capacity(n));
    }

    static int capacity(int n) {
        if (n < 3) {
            Preconditions.checkArgument(n >= 0);
            return n + 1;
        }
        if (n < 0x40000000) {
            return n + n / 3;
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<? extends K, ? extends V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new MapMaker().makeMap();
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap(SortedMap<K, ? extends V> sortedMap) {
        return new TreeMap<K, V>(sortedMap);
    }

    public static <C, K extends C, V> TreeMap<K, V> newTreeMap(@Nullable Comparator<C> comparator) {
        return new TreeMap(comparator);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Class<K> clazz) {
        return new EnumMap(Preconditions.checkNotNull(clazz));
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Map<K, ? extends V> map) {
        return new EnumMap<K, V>(map);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static <K, V> MapDifference<K, V> difference(Map<? extends K, ? extends V> map, Map<? extends K, ? extends V> map2) {
        if (map instanceof SortedMap) {
            SortedMap sortedMap = (SortedMap)map;
            MapDifference<? extends K, ? extends V> mapDifference = Maps.difference(sortedMap, map2);
            return mapDifference;
        }
        return Maps.difference(map, map2, Equivalences.equals());
    }

    @Beta
    public static <K, V> MapDifference<K, V> difference(Map<? extends K, ? extends V> map, Map<? extends K, ? extends V> map2, Equivalence<? super V> equivalence) {
        Preconditions.checkNotNull(equivalence);
        HashMap<K, V> hashMap = Maps.newHashMap();
        HashMap<K, V> hashMap2 = new HashMap<K, V>(map2);
        HashMap<K, V> hashMap3 = Maps.newHashMap();
        HashMap<K, MapDifference.ValueDifference<V>> hashMap4 = Maps.newHashMap();
        boolean bl = true;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K k = entry.getKey();
            V v = entry.getValue();
            if (map2.containsKey(k)) {
                Object v2 = hashMap2.remove(k);
                if (equivalence.equivalent(v, v2)) {
                    hashMap3.put(k, v);
                    continue;
                }
                bl = false;
                hashMap4.put(k, ValueDifferenceImpl.create(v, v2));
                continue;
            }
            bl = false;
            hashMap.put(k, v);
        }
        boolean bl2 = bl && hashMap2.isEmpty();
        return Maps.mapDifference(bl2, hashMap, hashMap2, hashMap3, hashMap4);
    }

    private static <K, V> MapDifference<K, V> mapDifference(boolean bl, Map<K, V> map, Map<K, V> map2, Map<K, V> map3, Map<K, MapDifference.ValueDifference<V>> map4) {
        return new MapDifferenceImpl<K, V>(bl, Collections.unmodifiableMap(map), Collections.unmodifiableMap(map2), Collections.unmodifiableMap(map3), Collections.unmodifiableMap(map4));
    }

    private static <K, V> SortedMapDifference<K, V> sortedMapDifference(boolean bl, SortedMap<K, V> sortedMap, SortedMap<K, V> sortedMap2, SortedMap<K, V> sortedMap3, SortedMap<K, MapDifference.ValueDifference<V>> sortedMap4) {
        return new SortedMapDifferenceImpl<K, V>(bl, Collections.unmodifiableSortedMap(sortedMap), Collections.unmodifiableSortedMap(sortedMap2), Collections.unmodifiableSortedMap(sortedMap3), Collections.unmodifiableSortedMap(sortedMap4));
    }

    static <E> Comparator<? super E> orNaturalOrder(@Nullable Comparator<? super E> comparator) {
        if (comparator != null) {
            return comparator;
        }
        return Ordering.natural();
    }

    public static <K, V> ImmutableMap<K, V> uniqueIndex(Iterable<V> iterable, Function<? super V, K> function) {
        return Maps.uniqueIndex(iterable.iterator(), function);
    }

    @Deprecated
    @Beta
    public static <K, V, I extends Object & Iterator<V>> ImmutableMap<K, V> uniqueIndex(I i, Function<? super V, K> function) {
        Iterable iterable = (Iterable)Preconditions.checkNotNull(i);
        return Maps.uniqueIndex(iterable, function);
    }

    public static <K, V> ImmutableMap<K, V> uniqueIndex(Iterator<V> iterator, Function<? super V, K> function) {
        Preconditions.checkNotNull(function);
        ImmutableMap.Builder<K, V> builder = ImmutableMap.builder();
        while (iterator.hasNext()) {
            V v = iterator.next();
            builder.put(function.apply(v), v);
        }
        return builder.build();
    }

    @GwtIncompatible(value="java.util.Properties")
    public static ImmutableMap<String, String> fromProperties(Properties properties) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            builder.put(string, properties.getProperty(string));
        }
        return builder.build();
    }

    @GwtCompatible(serializable=true)
    public static <K, V> Map.Entry<K, V> immutableEntry(@Nullable K k, @Nullable V v) {
        return new ImmutableEntry<K, V>(k, v);
    }

    static <K, V> Set<Map.Entry<K, V>> unmodifiableEntrySet(Set<Map.Entry<K, V>> set) {
        return new UnmodifiableEntrySet<K, V>(Collections.unmodifiableSet(set));
    }

    static <K, V> Map.Entry<K, V> unmodifiableEntry(final Map.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        return new AbstractMapEntry<K, V>(){

            @Override
            public K getKey() {
                return entry.getKey();
            }

            @Override
            public V getValue() {
                return entry.getValue();
            }
        };
    }

    public static <K, V> BiMap<K, V> synchronizedBiMap(BiMap<K, V> biMap) {
        return Synchronized.biMap(biMap, null);
    }

    public static <K, V> BiMap<K, V> unmodifiableBiMap(BiMap<? extends K, ? extends V> biMap) {
        return new UnmodifiableBiMap<K, V>(biMap, null);
    }

    public static <K, V1, V2> Map<K, V2> transformValues(Map<K, V1> map, final Function<? super V1, V2> function) {
        Preconditions.checkNotNull(function);
        EntryTransformer entryTransformer = new EntryTransformer<K, V1, V2>(){

            @Override
            public V2 transformEntry(K k, V1 V1) {
                return function.apply(V1);
            }
        };
        return Maps.transformEntries(map, entryTransformer);
    }

    @Beta
    public static <K, V1, V2> SortedMap<K, V2> transformValues(SortedMap<K, V1> sortedMap, final Function<? super V1, V2> function) {
        Preconditions.checkNotNull(function);
        EntryTransformer entryTransformer = new EntryTransformer<K, V1, V2>(){

            @Override
            public V2 transformEntry(K k, V1 V1) {
                return function.apply(V1);
            }
        };
        return Maps.transformEntries(sortedMap, entryTransformer);
    }

    public static <K, V1, V2> Map<K, V2> transformEntries(Map<K, V1> map, EntryTransformer<? super K, ? super V1, V2> entryTransformer) {
        if (map instanceof SortedMap) {
            return Maps.transformEntries((SortedMap)map, entryTransformer);
        }
        return new TransformedEntriesMap<K, V1, V2>(map, entryTransformer);
    }

    @Beta
    public static <K, V1, V2> SortedMap<K, V2> transformEntries(SortedMap<K, V1> sortedMap, EntryTransformer<? super K, ? super V1, V2> entryTransformer) {
        return new TransformedEntriesSortedMap<K, V1, V2>(sortedMap, entryTransformer);
    }

    public static <K, V> Map<K, V> filterKeys(Map<K, V> map, final Predicate<? super K> predicate) {
        if (map instanceof SortedMap) {
            return Maps.filterKeys((SortedMap)map, predicate);
        }
        Preconditions.checkNotNull(predicate);
        Predicate predicate2 = new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> entry) {
                return predicate.apply(entry.getKey());
            }
        };
        return map instanceof AbstractFilteredMap ? Maps.filterFiltered((AbstractFilteredMap)map, predicate2) : new FilteredKeyMap<K, V>(Preconditions.checkNotNull(map), predicate, predicate2);
    }

    @Beta
    public static <K, V> SortedMap<K, V> filterKeys(SortedMap<K, V> sortedMap, final Predicate<? super K> predicate) {
        Preconditions.checkNotNull(predicate);
        Predicate predicate2 = new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> entry) {
                return predicate.apply(entry.getKey());
            }
        };
        return Maps.filterEntries(sortedMap, predicate2);
    }

    public static <K, V> Map<K, V> filterValues(Map<K, V> map, final Predicate<? super V> predicate) {
        if (map instanceof SortedMap) {
            return Maps.filterValues((SortedMap)map, predicate);
        }
        Preconditions.checkNotNull(predicate);
        Predicate predicate2 = new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> entry) {
                return predicate.apply(entry.getValue());
            }
        };
        return Maps.filterEntries(map, predicate2);
    }

    @Beta
    public static <K, V> SortedMap<K, V> filterValues(SortedMap<K, V> sortedMap, final Predicate<? super V> predicate) {
        Preconditions.checkNotNull(predicate);
        Predicate predicate2 = new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> entry) {
                return predicate.apply(entry.getValue());
            }
        };
        return Maps.filterEntries(sortedMap, predicate2);
    }

    public static <K, V> Map<K, V> filterEntries(Map<K, V> map, Predicate<? super Map.Entry<K, V>> predicate) {
        if (map instanceof SortedMap) {
            return Maps.filterEntries((SortedMap)map, predicate);
        }
        Preconditions.checkNotNull(predicate);
        return map instanceof AbstractFilteredMap ? Maps.filterFiltered((AbstractFilteredMap)map, predicate) : new FilteredEntryMap<K, V>(Preconditions.checkNotNull(map), predicate);
    }

    @Beta
    public static <K, V> SortedMap<K, V> filterEntries(SortedMap<K, V> sortedMap, Predicate<? super Map.Entry<K, V>> predicate) {
        Preconditions.checkNotNull(predicate);
        return sortedMap instanceof FilteredEntrySortedMap ? Maps.filterFiltered((FilteredEntrySortedMap)sortedMap, predicate) : new FilteredEntrySortedMap<K, V>(Preconditions.checkNotNull(sortedMap), predicate);
    }

    private static <K, V> Map<K, V> filterFiltered(AbstractFilteredMap<K, V> abstractFilteredMap, Predicate<? super Map.Entry<K, V>> predicate) {
        Predicate<? super Map.Entry<K, V>> predicate2 = Predicates.and(abstractFilteredMap.predicate, predicate);
        return new FilteredEntryMap(abstractFilteredMap.unfiltered, predicate2);
    }

    private static <K, V> SortedMap<K, V> filterFiltered(FilteredEntrySortedMap<K, V> filteredEntrySortedMap, Predicate<? super Map.Entry<K, V>> predicate) {
        Predicate<? super Map.Entry<K, V>> predicate2 = Predicates.and(filteredEntrySortedMap.predicate, predicate);
        return new FilteredEntrySortedMap<K, V>(filteredEntrySortedMap.sortedMap(), predicate2);
    }

    @GwtIncompatible(value="NavigableMap")
    public static <K, V> NavigableMap<K, V> unmodifiableNavigableMap(NavigableMap<K, V> navigableMap) {
        Preconditions.checkNotNull(navigableMap);
        if (navigableMap instanceof UnmodifiableNavigableMap) {
            return navigableMap;
        }
        return new UnmodifiableNavigableMap<K, V>(navigableMap);
    }

    @Nullable
    private static <K, V> Map.Entry<K, V> unmodifiableOrNull(@Nullable Map.Entry<K, V> entry) {
        return entry == null ? null : Maps.unmodifiableEntry(entry);
    }

    static <V> V safeGet(Map<?, V> map, Object object) {
        try {
            return map.get(object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    static boolean safeContainsKey(Map<?, ?> map, Object object) {
        try {
            return map.containsKey(object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    static <K, V> boolean containsEntryImpl(Collection<Map.Entry<K, V>> collection, Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        return collection.contains(Maps.unmodifiableEntry((Map.Entry)object));
    }

    static <K, V> boolean removeEntryImpl(Collection<Map.Entry<K, V>> collection, Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        return collection.remove(Maps.unmodifiableEntry((Map.Entry)object));
    }

    static boolean equalsImpl(Map<?, ?> map, Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            return map.entrySet().equals(map2.entrySet());
        }
        return false;
    }

    static int hashCodeImpl(Map<?, ?> map) {
        return Sets.hashCodeImpl(map.entrySet());
    }

    static String toStringImpl(Map<?, ?> map) {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(map.size()).append('{');
        STANDARD_JOINER.appendTo(stringBuilder, map);
        return stringBuilder.append('}').toString();
    }

    static <K, V> void putAllImpl(Map<K, V> map, Map<? extends K, ? extends V> map2) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    static boolean containsKeyImpl(Map<?, ?> map, @Nullable Object object) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!Objects.equal(entry.getKey(), object)) continue;
            return true;
        }
        return false;
    }

    static boolean containsValueImpl(Map<?, ?> map, @Nullable Object object) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!Objects.equal(entry.getValue(), object)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static <K> K keyOrNull(@Nullable Map.Entry<K, ?> entry) {
        return entry == null ? null : (K)entry.getKey();
    }

    @GwtIncompatible(value="NavigableMap")
    static abstract class DescendingMap<K, V>
    extends ForwardingMap<K, V>
    implements NavigableMap<K, V> {
        private transient Comparator<? super K> comparator;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient NavigableSet<K> navigableKeySet;

        DescendingMap() {
        }

        abstract NavigableMap<K, V> forward();

        @Override
        protected final Map<K, V> delegate() {
            return this.forward();
        }

        @Override
        public Comparator<? super K> comparator() {
            Comparator<? super K> comparator = this.comparator;
            if (comparator == null) {
                Comparator comparator2 = this.forward().comparator();
                if (comparator2 == null) {
                    comparator2 = Ordering.natural();
                }
                comparator = this.comparator = DescendingMap.reverse(comparator2);
            }
            return comparator;
        }

        private static <T> Ordering<T> reverse(Comparator<T> comparator) {
            return Ordering.from(comparator).reverse();
        }

        @Override
        public K firstKey() {
            return this.forward().lastKey();
        }

        @Override
        public K lastKey() {
            return this.forward().firstKey();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            return this.forward().higherEntry(k);
        }

        @Override
        public K lowerKey(K k) {
            return this.forward().higherKey(k);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            return this.forward().ceilingEntry(k);
        }

        @Override
        public K floorKey(K k) {
            return this.forward().ceilingKey(k);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            return this.forward().floorEntry(k);
        }

        @Override
        public K ceilingKey(K k) {
            return this.forward().floorKey(k);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            return this.forward().lowerEntry(k);
        }

        @Override
        public K higherKey(K k) {
            return this.forward().lowerKey(k);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.forward().lastEntry();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.forward().firstEntry();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return this.forward().pollLastEntry();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return this.forward().pollFirstEntry();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return this.forward();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> set = this.entrySet;
            return set == null ? (this.entrySet = this.createEntrySet()) : set;
        }

        abstract Iterator<Map.Entry<K, V>> entryIterator();

        Set<Map.Entry<K, V>> createEntrySet() {
            return new EntrySet<K, V>(){

                @Override
                Map<K, V> map() {
                    return DescendingMap.this;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return DescendingMap.this.entryIterator();
                }
            };
        }

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            NavigableKeySet navigableKeySet = this.navigableKeySet;
            if (navigableKeySet == null) {
                navigableKeySet = this.navigableKeySet = new NavigableKeySet<K, V>(){

                    @Override
                    NavigableMap<K, V> map() {
                        return DescendingMap.this;
                    }
                };
            }
            return navigableKeySet;
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.forward().navigableKeySet();
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            return this.forward().subMap(k2, bl2, k, bl).descendingMap();
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            return this.forward().tailMap(k, bl).descendingMap();
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            return this.forward().headMap(k, bl).descendingMap();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return this.subMap(k, true, k2, false);
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return this.headMap(k, false);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return this.tailMap(k, true);
        }

        @Override
        public Collection<V> values() {
            return new Values<K, V>(){

                @Override
                Map<K, V> map() {
                    return DescendingMap.this;
                }
            };
        }
    }

    static abstract class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        abstract Map<K, V> map();

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                V v = this.map().get(k);
                return Objects.equal(v, entry.getValue()) && (v != null || this.map().containsKey(k));
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                Map.Entry entry = (Map.Entry)object;
                return this.map().keySet().remove(entry.getKey());
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            try {
                return super.removeAll(Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                boolean bl = true;
                for (Object obj : collection) {
                    bl |= this.remove(obj);
                }
                return bl;
            }
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            try {
                return super.retainAll(Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet hashSet = Sets.newHashSetWithExpectedSize(collection.size());
                for (Object obj : collection) {
                    if (!this.contains(obj)) continue;
                    Map.Entry entry = (Map.Entry)obj;
                    hashSet.add(entry.getKey());
                }
                return this.map().keySet().retainAll(hashSet);
            }
        }
    }

    static abstract class Values<K, V>
    extends AbstractCollection<V> {
        Values() {
        }

        abstract Map<K, V> map();

        @Override
        public Iterator<V> iterator() {
            return Iterators.transform(this.map().entrySet().iterator(), new Function<Map.Entry<K, V>, V>(){

                @Override
                public V apply(Map.Entry<K, V> entry) {
                    return entry.getValue();
                }
            });
        }

        @Override
        public boolean remove(Object object) {
            try {
                return super.remove(object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    if (!Objects.equal(object, entry.getValue())) continue;
                    this.map().remove(entry.getKey());
                    return true;
                }
                return false;
            }
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            try {
                return super.removeAll(Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet<K> hashSet = Sets.newHashSet();
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    if (!collection.contains(entry.getValue())) continue;
                    hashSet.add(entry.getKey());
                }
                return this.map().keySet().removeAll(hashSet);
            }
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            try {
                return super.retainAll(Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet<K> hashSet = Sets.newHashSet();
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    if (!collection.contains(entry.getValue())) continue;
                    hashSet.add(entry.getKey());
                }
                return this.map().keySet().retainAll(hashSet);
            }
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return this.map().containsValue(object);
        }

        @Override
        public void clear() {
            this.map().clear();
        }
    }

    @GwtIncompatible(value="NavigableMap")
    static abstract class NavigableKeySet<K, V>
    extends KeySet<K, V>
    implements NavigableSet<K> {
        NavigableKeySet() {
        }

        @Override
        abstract NavigableMap<K, V> map();

        @Override
        public Comparator<? super K> comparator() {
            return this.map().comparator();
        }

        @Override
        public K first() {
            return this.map().firstKey();
        }

        @Override
        public K last() {
            return this.map().lastKey();
        }

        @Override
        public K lower(K k) {
            return this.map().lowerKey(k);
        }

        @Override
        public K floor(K k) {
            return this.map().floorKey(k);
        }

        @Override
        public K ceiling(K k) {
            return this.map().ceilingKey(k);
        }

        @Override
        public K higher(K k) {
            return this.map().higherKey(k);
        }

        @Override
        public K pollFirst() {
            return Maps.keyOrNull(this.map().pollFirstEntry());
        }

        @Override
        public K pollLast() {
            return Maps.keyOrNull(this.map().pollLastEntry());
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return this.map().descendingKeySet();
        }

        @Override
        public Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<K> subSet(K k, boolean bl, K k2, boolean bl2) {
            return this.map().subMap(k, bl, k2, bl2).navigableKeySet();
        }

        @Override
        public NavigableSet<K> headSet(K k, boolean bl) {
            return this.map().headMap(k, bl).navigableKeySet();
        }

        @Override
        public NavigableSet<K> tailSet(K k, boolean bl) {
            return this.map().tailMap(k, bl).navigableKeySet();
        }

        @Override
        public SortedSet<K> subSet(K k, K k2) {
            return this.subSet(k, true, k2, false);
        }

        @Override
        public SortedSet<K> headSet(K k) {
            return this.headSet(k, false);
        }

        @Override
        public SortedSet<K> tailSet(K k) {
            return this.tailSet(k, true);
        }
    }

    static abstract class KeySet<K, V>
    extends AbstractSet<K> {
        KeySet() {
        }

        abstract Map<K, V> map();

        @Override
        public Iterator<K> iterator() {
            return Iterators.transform(this.map().entrySet().iterator(), new Function<Map.Entry<K, V>, K>(){

                @Override
                public K apply(Map.Entry<K, V> entry) {
                    return entry.getKey();
                }
            });
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.map().containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                this.map().remove(object);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return super.removeAll(Preconditions.checkNotNull(collection));
        }

        @Override
        public void clear() {
            this.map().clear();
        }
    }

    @GwtCompatible
    static abstract class ImprovedAbstractMap<K, V>
    extends AbstractMap<K, V> {
        private Set<Map.Entry<K, V>> entrySet;
        private Set<K> keySet;
        private Collection<V> values;

        ImprovedAbstractMap() {
        }

        protected abstract Set<Map.Entry<K, V>> createEntrySet();

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> set = this.entrySet;
            if (set == null) {
                this.entrySet = set = this.createEntrySet();
            }
            return set;
        }

        @Override
        public Set<K> keySet() {
            Set<K> set = this.keySet;
            if (set == null) {
                this.keySet = new KeySet<K, V>(){

                    @Override
                    Map<K, V> map() {
                        return ImprovedAbstractMap.this;
                    }
                };
                return this.keySet;
            }
            return set;
        }

        @Override
        public Collection<V> values() {
            Collection<V> collection = this.values;
            if (collection == null) {
                this.values = new Values<K, V>(){

                    @Override
                    Map<K, V> map() {
                        return ImprovedAbstractMap.this;
                    }
                };
                return this.values;
            }
            return collection;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }
    }

    @GwtIncompatible(value="NavigableMap")
    static class UnmodifiableNavigableMap<K, V>
    extends ForwardingSortedMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        private final NavigableMap<K, V> delegate;
        private transient UnmodifiableNavigableMap<K, V> descendingMap;

        UnmodifiableNavigableMap(NavigableMap<K, V> navigableMap) {
            this.delegate = navigableMap;
        }

        @Override
        protected SortedMap<K, V> delegate() {
            return Collections.unmodifiableSortedMap(this.delegate);
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            return Maps.unmodifiableOrNull(this.delegate.lowerEntry(k));
        }

        @Override
        public K lowerKey(K k) {
            return this.delegate.lowerKey(k);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            return Maps.unmodifiableOrNull(this.delegate.floorEntry(k));
        }

        @Override
        public K floorKey(K k) {
            return this.delegate.floorKey(k);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            return Maps.unmodifiableOrNull(this.delegate.ceilingEntry(k));
        }

        @Override
        public K ceilingKey(K k) {
            return this.delegate.ceilingKey(k);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            return Maps.unmodifiableOrNull(this.delegate.higherEntry(k));
        }

        @Override
        public K higherKey(K k) {
            return this.delegate.higherKey(k);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return Maps.unmodifiableOrNull(this.delegate.firstEntry());
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return Maps.unmodifiableOrNull(this.delegate.lastEntry());
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            UnmodifiableNavigableMap<K, V> unmodifiableNavigableMap = this.descendingMap;
            if (unmodifiableNavigableMap == null) {
                this.descendingMap = unmodifiableNavigableMap = new UnmodifiableNavigableMap<K, V>(this.delegate.descendingMap());
                unmodifiableNavigableMap.descendingMap = this;
            }
            return unmodifiableNavigableMap;
        }

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return Sets.unmodifiableNavigableSet(this.delegate.navigableKeySet());
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return Sets.unmodifiableNavigableSet(this.delegate.descendingKeySet());
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            return Maps.unmodifiableNavigableMap(this.delegate.subMap(k, bl, k2, bl2));
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            return Maps.unmodifiableNavigableMap(this.delegate.headMap(k, bl));
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            return Maps.unmodifiableNavigableMap(this.delegate.tailMap(k, bl));
        }
    }

    static class FilteredEntryMap<K, V>
    extends AbstractFilteredMap<K, V> {
        final Set<Map.Entry<K, V>> filteredEntrySet;
        Set<Map.Entry<K, V>> entrySet;
        Set<K> keySet;

        FilteredEntryMap(Map<K, V> map, Predicate<? super Map.Entry<K, V>> predicate) {
            super(map, predicate);
            this.filteredEntrySet = Sets.filter(map.entrySet(), this.predicate);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            EntrySet entrySet = this.entrySet;
            return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
        }

        @Override
        public Set<K> keySet() {
            KeySet keySet = this.keySet;
            return keySet == null ? (this.keySet = new KeySet()) : keySet;
        }

        private class KeySet
        extends AbstractSet<K> {
            private KeySet() {
            }

            @Override
            public Iterator<K> iterator() {
                final Iterator iterator = FilteredEntryMap.this.filteredEntrySet.iterator();
                return new UnmodifiableIterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((Map.Entry)iterator.next()).getKey();
                    }
                };
            }

            @Override
            public int size() {
                return FilteredEntryMap.this.filteredEntrySet.size();
            }

            @Override
            public void clear() {
                FilteredEntryMap.this.filteredEntrySet.clear();
            }

            @Override
            public boolean contains(Object object) {
                return FilteredEntryMap.this.containsKey(object);
            }

            @Override
            public boolean remove(Object object) {
                if (FilteredEntryMap.this.containsKey(object)) {
                    FilteredEntryMap.this.unfiltered.remove(object);
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                boolean bl = false;
                for (Object obj : collection) {
                    bl |= this.remove(obj);
                }
                return bl;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                boolean bl = false;
                Iterator iterator = FilteredEntryMap.this.unfiltered.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (collection.contains(entry.getKey()) || !FilteredEntryMap.this.predicate.apply(entry)) continue;
                    iterator.remove();
                    bl = true;
                }
                return bl;
            }

            @Override
            public Object[] toArray() {
                return Lists.newArrayList(this.iterator()).toArray();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return Lists.newArrayList(this.iterator()).toArray(TArray);
            }
        }

        private class EntrySet
        extends ForwardingSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            protected Set<Map.Entry<K, V>> delegate() {
                return FilteredEntryMap.this.filteredEntrySet;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator iterator = FilteredEntryMap.this.filteredEntrySet.iterator();
                return new UnmodifiableIterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry entry = (Map.Entry)iterator.next();
                        return new ForwardingMapEntry<K, V>(){

                            @Override
                            protected Map.Entry<K, V> delegate() {
                                return entry;
                            }

                            @Override
                            public V setValue(V v) {
                                Preconditions.checkArgument(FilteredEntryMap.this.apply(entry.getKey(), v));
                                return super.setValue(v);
                            }
                        };
                    }
                };
            }
        }
    }

    private static class FilteredKeyMap<K, V>
    extends AbstractFilteredMap<K, V> {
        Predicate<? super K> keyPredicate;
        Set<Map.Entry<K, V>> entrySet;
        Set<K> keySet;

        FilteredKeyMap(Map<K, V> map, Predicate<? super K> predicate, Predicate<Map.Entry<K, V>> predicate2) {
            super(map, predicate2);
            this.keyPredicate = predicate;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> set = this.entrySet;
            return set == null ? (this.entrySet = Sets.filter(this.unfiltered.entrySet(), this.predicate)) : set;
        }

        @Override
        public Set<K> keySet() {
            Set<K> set = this.keySet;
            return set == null ? (this.keySet = Sets.filter(this.unfiltered.keySet(), this.keyPredicate)) : set;
        }

        @Override
        public boolean containsKey(Object object) {
            return this.unfiltered.containsKey(object) && this.keyPredicate.apply(object);
        }
    }

    private static class FilteredEntrySortedMap<K, V>
    extends FilteredEntryMap<K, V>
    implements SortedMap<K, V> {
        FilteredEntrySortedMap(SortedMap<K, V> sortedMap, Predicate<? super Map.Entry<K, V>> predicate) {
            super(sortedMap, predicate);
        }

        SortedMap<K, V> sortedMap() {
            return (SortedMap)this.unfiltered;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        public K firstKey() {
            return this.keySet().iterator().next();
        }

        @Override
        public K lastKey() {
            SortedMap<K, V> sortedMap = this.sortedMap();
            K k;
            while (!this.apply(k = sortedMap.lastKey(), this.unfiltered.get(k))) {
                sortedMap = this.sortedMap().headMap(k);
            }
            return k;
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return new FilteredEntrySortedMap<K, V>(this.sortedMap().headMap(k), this.predicate);
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return new FilteredEntrySortedMap<K, V>(this.sortedMap().subMap(k, k2), this.predicate);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return new FilteredEntrySortedMap<K, V>(this.sortedMap().tailMap(k), this.predicate);
        }
    }

    private static abstract class AbstractFilteredMap<K, V>
    extends AbstractMap<K, V> {
        final Map<K, V> unfiltered;
        final Predicate<? super Map.Entry<K, V>> predicate;
        Collection<V> values;

        AbstractFilteredMap(Map<K, V> map, Predicate<? super Map.Entry<K, V>> predicate) {
            this.unfiltered = map;
            this.predicate = predicate;
        }

        boolean apply(Object object, V v) {
            Object object2 = object;
            return this.predicate.apply(Maps.immutableEntry(object2, v));
        }

        @Override
        public V put(K k, V v) {
            Preconditions.checkArgument(this.apply(k, v));
            return this.unfiltered.put(k, v);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                Preconditions.checkArgument(this.apply(entry.getKey(), entry.getValue()));
            }
            this.unfiltered.putAll(map);
        }

        @Override
        public boolean containsKey(Object object) {
            return this.unfiltered.containsKey(object) && this.apply(object, this.unfiltered.get(object));
        }

        @Override
        public V get(Object object) {
            V v = this.unfiltered.get(object);
            return v != null && this.apply(object, v) ? (V)v : null;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }

        @Override
        public V remove(Object object) {
            return this.containsKey(object) ? (V)this.unfiltered.remove(object) : null;
        }

        @Override
        public Collection<V> values() {
            Values values = this.values;
            return values == null ? (this.values = new Values()) : values;
        }

        class Values
        extends AbstractCollection<V> {
            Values() {
            }

            @Override
            public Iterator<V> iterator() {
                final Iterator iterator = AbstractFilteredMap.this.entrySet().iterator();
                return new UnmodifiableIterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((Map.Entry)iterator.next()).getValue();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractFilteredMap.this.entrySet().size();
            }

            @Override
            public void clear() {
                AbstractFilteredMap.this.entrySet().clear();
            }

            @Override
            public boolean isEmpty() {
                return AbstractFilteredMap.this.entrySet().isEmpty();
            }

            @Override
            public boolean remove(Object object) {
                Iterator iterator = AbstractFilteredMap.this.unfiltered.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!Objects.equal(object, entry.getValue()) || !AbstractFilteredMap.this.predicate.apply(entry)) continue;
                    iterator.remove();
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                boolean bl = false;
                Iterator iterator = AbstractFilteredMap.this.unfiltered.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!collection.contains(entry.getValue()) || !AbstractFilteredMap.this.predicate.apply(entry)) continue;
                    iterator.remove();
                    bl = true;
                }
                return bl;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                boolean bl = false;
                Iterator iterator = AbstractFilteredMap.this.unfiltered.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (collection.contains(entry.getValue()) || !AbstractFilteredMap.this.predicate.apply(entry)) continue;
                    iterator.remove();
                    bl = true;
                }
                return bl;
            }

            @Override
            public Object[] toArray() {
                return Lists.newArrayList(this.iterator()).toArray();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return Lists.newArrayList(this.iterator()).toArray(TArray);
            }
        }
    }

    static class TransformedEntriesSortedMap<K, V1, V2>
    extends TransformedEntriesMap<K, V1, V2>
    implements SortedMap<K, V2> {
        protected SortedMap<K, V1> fromMap() {
            return (SortedMap)this.fromMap;
        }

        TransformedEntriesSortedMap(SortedMap<K, V1> sortedMap, EntryTransformer<? super K, ? super V1, V2> entryTransformer) {
            super(sortedMap, entryTransformer);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.fromMap().comparator();
        }

        @Override
        public K firstKey() {
            return this.fromMap().firstKey();
        }

        @Override
        public SortedMap<K, V2> headMap(K k) {
            return Maps.transformEntries(this.fromMap().headMap(k), this.transformer);
        }

        @Override
        public K lastKey() {
            return this.fromMap().lastKey();
        }

        @Override
        public SortedMap<K, V2> subMap(K k, K k2) {
            return Maps.transformEntries(this.fromMap().subMap(k, k2), this.transformer);
        }

        @Override
        public SortedMap<K, V2> tailMap(K k) {
            return Maps.transformEntries(this.fromMap().tailMap(k), this.transformer);
        }
    }

    static class TransformedEntriesMap<K, V1, V2>
    extends AbstractMap<K, V2> {
        final Map<K, V1> fromMap;
        final EntryTransformer<? super K, ? super V1, V2> transformer;
        Set<Map.Entry<K, V2>> entrySet;
        Collection<V2> values;

        TransformedEntriesMap(Map<K, V1> map, EntryTransformer<? super K, ? super V1, V2> entryTransformer) {
            this.fromMap = Preconditions.checkNotNull(map);
            this.transformer = Preconditions.checkNotNull(entryTransformer);
        }

        @Override
        public int size() {
            return this.fromMap.size();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.fromMap.containsKey(object);
        }

        @Override
        public V2 get(Object object) {
            V1 V1 = this.fromMap.get(object);
            return (V2)(V1 != null || this.fromMap.containsKey(object) ? this.transformer.transformEntry(object, V1) : null);
        }

        @Override
        public V2 remove(Object object) {
            return this.fromMap.containsKey(object) ? (V2)this.transformer.transformEntry((K)object, (V1)this.fromMap.remove(object)) : null;
        }

        @Override
        public void clear() {
            this.fromMap.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.fromMap.keySet();
        }

        @Override
        public Set<Map.Entry<K, V2>> entrySet() {
            EntrySet entrySet = this.entrySet;
            if (entrySet == null) {
                this.entrySet = entrySet = new EntrySet<K, V2>(){

                    @Override
                    Map<K, V2> map() {
                        return TransformedEntriesMap.this;
                    }

                    @Override
                    public Iterator<Map.Entry<K, V2>> iterator() {
                        Iterator iterator = TransformedEntriesMap.this.fromMap.entrySet().iterator();
                        return Iterators.transform(iterator, new Function<Map.Entry<K, V1>, Map.Entry<K, V2>>(){

                            @Override
                            public Map.Entry<K, V2> apply(Map.Entry<K, V1> entry) {
                                return Maps.immutableEntry(entry.getKey(), TransformedEntriesMap.this.transformer.transformEntry(entry.getKey(), entry.getValue()));
                            }
                        });
                    }
                };
            }
            return entrySet;
        }

        @Override
        public Collection<V2> values() {
            Collection<V2> collection = this.values;
            if (collection == null) {
                this.values = new Values<K, V2>(){

                    @Override
                    Map<K, V2> map() {
                        return TransformedEntriesMap.this;
                    }
                };
                return this.values;
            }
            return collection;
        }
    }

    public static interface EntryTransformer<K, V1, V2> {
        public V2 transformEntry(@Nullable K var1, @Nullable V1 var2);
    }

    private static class UnmodifiableBiMap<K, V>
    extends ForwardingMap<K, V>
    implements BiMap<K, V>,
    Serializable {
        final Map<K, V> unmodifiableMap;
        final BiMap<? extends K, ? extends V> delegate;
        transient BiMap<V, K> inverse;
        transient Set<V> values;
        private static final long serialVersionUID = 0L;

        UnmodifiableBiMap(BiMap<? extends K, ? extends V> biMap, @Nullable BiMap<V, K> biMap2) {
            this.unmodifiableMap = Collections.unmodifiableMap(biMap);
            this.delegate = biMap;
            this.inverse = biMap2;
        }

        @Override
        protected Map<K, V> delegate() {
            return this.unmodifiableMap;
        }

        @Override
        public V forcePut(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BiMap<V, K> inverse() {
            BiMap<K, V> biMap = this.inverse;
            return biMap == null ? (this.inverse = new UnmodifiableBiMap<V, K>(this.delegate.inverse(), this)) : biMap;
        }

        @Override
        public Set<V> values() {
            Set<V> set = this.values;
            return set == null ? (this.values = Collections.unmodifiableSet(this.delegate.values())) : set;
        }
    }

    static class UnmodifiableEntrySet<K, V>
    extends UnmodifiableEntries<K, V>
    implements Set<Map.Entry<K, V>> {
        UnmodifiableEntrySet(Set<Map.Entry<K, V>> set) {
            super(set);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return Sets.equalsImpl(this, object);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    static class UnmodifiableEntries<K, V>
    extends ForwardingCollection<Map.Entry<K, V>> {
        private final Collection<Map.Entry<K, V>> entries;

        UnmodifiableEntries(Collection<Map.Entry<K, V>> collection) {
            this.entries = collection;
        }

        @Override
        protected Collection<Map.Entry<K, V>> delegate() {
            return this.entries;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator iterator = super.iterator();
            return new ForwardingIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return Maps.unmodifiableEntry((Map.Entry)super.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                protected Iterator<Map.Entry<K, V>> delegate() {
                    return iterator;
                }
            };
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.standardToArray(TArray);
        }
    }

    static class SortedMapDifferenceImpl<K, V>
    extends MapDifferenceImpl<K, V>
    implements SortedMapDifference<K, V> {
        SortedMapDifferenceImpl(boolean bl, SortedMap<K, V> sortedMap, SortedMap<K, V> sortedMap2, SortedMap<K, V> sortedMap3, SortedMap<K, MapDifference.ValueDifference<V>> sortedMap4) {
            super(bl, sortedMap, sortedMap2, sortedMap3, sortedMap4);
        }

        @Override
        public SortedMap<K, MapDifference.ValueDifference<V>> entriesDiffering() {
            return (SortedMap)super.entriesDiffering();
        }

        @Override
        public SortedMap<K, V> entriesInCommon() {
            return (SortedMap)super.entriesInCommon();
        }

        @Override
        public SortedMap<K, V> entriesOnlyOnLeft() {
            return (SortedMap)super.entriesOnlyOnLeft();
        }

        @Override
        public SortedMap<K, V> entriesOnlyOnRight() {
            return (SortedMap)super.entriesOnlyOnRight();
        }
    }

    static class ValueDifferenceImpl<V>
    implements MapDifference.ValueDifference<V> {
        private final V left;
        private final V right;

        static <V> MapDifference.ValueDifference<V> create(@Nullable V v, @Nullable V v2) {
            return new ValueDifferenceImpl<V>(v, v2);
        }

        private ValueDifferenceImpl(@Nullable V v, @Nullable V v2) {
            this.left = v;
            this.right = v2;
        }

        @Override
        public V leftValue() {
            return this.left;
        }

        @Override
        public V rightValue() {
            return this.right;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof MapDifference.ValueDifference) {
                MapDifference.ValueDifference valueDifference = (MapDifference.ValueDifference)object;
                return Objects.equal(this.left, valueDifference.leftValue()) && Objects.equal(this.right, valueDifference.rightValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.left, this.right);
        }

        public String toString() {
            return "(" + this.left + ", " + this.right + ")";
        }
    }

    static class MapDifferenceImpl<K, V>
    implements MapDifference<K, V> {
        final boolean areEqual;
        final Map<K, V> onlyOnLeft;
        final Map<K, V> onlyOnRight;
        final Map<K, V> onBoth;
        final Map<K, MapDifference.ValueDifference<V>> differences;

        MapDifferenceImpl(boolean bl, Map<K, V> map, Map<K, V> map2, Map<K, V> map3, Map<K, MapDifference.ValueDifference<V>> map4) {
            this.areEqual = bl;
            this.onlyOnLeft = map;
            this.onlyOnRight = map2;
            this.onBoth = map3;
            this.differences = map4;
        }

        @Override
        public boolean areEqual() {
            return this.areEqual;
        }

        @Override
        public Map<K, V> entriesOnlyOnLeft() {
            return this.onlyOnLeft;
        }

        @Override
        public Map<K, V> entriesOnlyOnRight() {
            return this.onlyOnRight;
        }

        @Override
        public Map<K, V> entriesInCommon() {
            return this.onBoth;
        }

        @Override
        public Map<K, MapDifference.ValueDifference<V>> entriesDiffering() {
            return this.differences;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof MapDifference) {
                MapDifference mapDifference = (MapDifference)object;
                return this.entriesOnlyOnLeft().equals(mapDifference.entriesOnlyOnLeft()) && this.entriesOnlyOnRight().equals(mapDifference.entriesOnlyOnRight()) && this.entriesInCommon().equals(mapDifference.entriesInCommon()) && this.entriesDiffering().equals(mapDifference.entriesDiffering());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.entriesOnlyOnLeft(), this.entriesOnlyOnRight(), this.entriesInCommon(), this.entriesDiffering());
        }

        public String toString() {
            if (this.areEqual) {
                return "equal";
            }
            StringBuilder stringBuilder = new StringBuilder("not equal");
            if (!this.onlyOnLeft.isEmpty()) {
                stringBuilder.append(": only on left=").append(this.onlyOnLeft);
            }
            if (!this.onlyOnRight.isEmpty()) {
                stringBuilder.append(": only on right=").append(this.onlyOnRight);
            }
            if (!this.differences.isEmpty()) {
                stringBuilder.append(": value differences=").append(this.differences);
            }
            return stringBuilder.toString();
        }
    }

    private static enum EntryFunction implements Function<Map.Entry<?, ?>, Object>
    {
        KEY{

            @Override
            @Nullable
            public Object apply(Map.Entry<?, ?> entry) {
                return entry.getKey();
            }
        }
        ,
        VALUE{

            @Override
            @Nullable
            public Object apply(Map.Entry<?, ?> entry) {
                return entry.getValue();
            }
        };

    }
}

