/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class Iterators {
    static final UnmodifiableIterator<Object> EMPTY_ITERATOR = new UnmodifiableIterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }
    };
    private static final Iterator<Object> EMPTY_MODIFIABLE_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };

    private Iterators() {
    }

    public static <T> UnmodifiableIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    static <T> Iterator<T> emptyModifiableIterator() {
        return EMPTY_MODIFIABLE_ITERATOR;
    }

    public static <T> UnmodifiableIterator<T> unmodifiableIterator(final Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator);
        if (iterator instanceof UnmodifiableIterator) {
            return (UnmodifiableIterator)iterator;
        }
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    @Deprecated
    public static <T> UnmodifiableIterator<T> unmodifiableIterator(UnmodifiableIterator<T> unmodifiableIterator) {
        return Preconditions.checkNotNull(unmodifiableIterator);
    }

    public static int size(Iterator<?> iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public static boolean contains(Iterator<?> iterator, @Nullable Object object) {
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean removeAll(Iterator<?> iterator, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static <T> boolean removeIf(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!predicate.apply(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static boolean retainAll(Iterator<?> iterator, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static boolean elementsEqual(Iterator<?> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            Object obj;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object obj2 = iterator.next();
            if (Objects.equal(obj2, obj = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterator<?> iterator) {
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(", ").append(iterator.next());
        }
        return stringBuilder.append(']').toString();
    }

    public static <T> T getOnlyElement(Iterator<T> iterator) {
        T t = iterator.next();
        if (!iterator.hasNext()) {
            return t;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("expected one element but was: <" + t);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            stringBuilder.append(", " + iterator.next());
        }
        if (iterator.hasNext()) {
            stringBuilder.append(", ...");
        }
        stringBuilder.append('>');
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static <T> T getOnlyElement(Iterator<T> iterator, @Nullable T t) {
        return iterator.hasNext() ? Iterators.getOnlyElement(iterator) : t;
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] toArray(Iterator<? extends T> iterator, Class<T> clazz) {
        ArrayList<? extends T> arrayList = Lists.newArrayList(iterator);
        return Iterables.toArray(arrayList, clazz);
    }

    public static <T> boolean addAll(Collection<T> collection, Iterator<? extends T> iterator) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= collection.add(iterator.next());
        }
        return bl;
    }

    public static int frequency(Iterator<?> iterator, @Nullable Object object) {
        int n = 0;
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                ++n;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                ++n;
            }
        }
        return n;
    }

    public static <T> Iterator<T> cycle(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Iterator<T>(){
            Iterator<T> iterator = Iterators.emptyIterator();
            Iterator<T> removeFrom;

            @Override
            public boolean hasNext() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                }
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removeFrom = this.iterator;
                return this.iterator.next();
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.removeFrom != null, "no calls to next() since last call to remove()");
                this.removeFrom.remove();
                this.removeFrom = null;
            }
        };
    }

    public static <T> Iterator<T> cycle(T ... TArray) {
        return Iterators.cycle(Lists.newArrayList(TArray));
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator, Iterator<? extends T> iterator2) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(iterator2);
        return Iterators.concat(Arrays.asList(iterator, iterator2).iterator());
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator, Iterator<? extends T> iterator2, Iterator<? extends T> iterator3) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(iterator3);
        return Iterators.concat(Arrays.asList(iterator, iterator2, iterator3).iterator());
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator, Iterator<? extends T> iterator2, Iterator<? extends T> iterator3, Iterator<? extends T> iterator4) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(iterator3);
        Preconditions.checkNotNull(iterator4);
        return Iterators.concat(Arrays.asList(iterator, iterator2, iterator3, iterator4).iterator());
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> ... iteratorArray) {
        return Iterators.concat(ImmutableList.copyOf(iteratorArray).iterator());
    }

    public static <T> Iterator<T> concat(final Iterator<? extends Iterator<? extends T>> iterator) {
        Preconditions.checkNotNull(iterator);
        return new Iterator<T>(){
            Iterator<? extends T> current = Iterators.emptyIterator();
            Iterator<? extends T> removeFrom;

            @Override
            public boolean hasNext() {
                boolean bl;
                while (!(bl = Preconditions.checkNotNull(this.current).hasNext()) && iterator.hasNext()) {
                    this.current = (Iterator)iterator.next();
                }
                return bl;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removeFrom = this.current;
                return this.current.next();
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.removeFrom != null, "no calls to next() since last call to remove()");
                this.removeFrom.remove();
                this.removeFrom = null;
            }
        };
    }

    public static <T> UnmodifiableIterator<List<T>> partition(Iterator<T> iterator, int n) {
        return Iterators.partitionImpl(iterator, n, false);
    }

    public static <T> UnmodifiableIterator<List<T>> paddedPartition(Iterator<T> iterator, int n) {
        return Iterators.partitionImpl(iterator, n, true);
    }

    private static <T> UnmodifiableIterator<List<T>> partitionImpl(final Iterator<T> iterator, final int n, final boolean bl) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(n > 0);
        return new UnmodifiableIterator<List<T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public List<T> next() {
                int n2;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] objectArray = new Object[n];
                for (n2 = 0; n2 < n && iterator.hasNext(); ++n2) {
                    objectArray[n2] = iterator.next();
                }
                for (int i = n2; i < n; ++i) {
                    objectArray[i] = null;
                }
                List<Object> list = Collections.unmodifiableList(Arrays.asList(objectArray));
                return bl || n2 == n ? list : list.subList(0, n2);
            }
        };
    }

    public static <T> UnmodifiableIterator<T> filter(final Iterator<T> iterator, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        return new AbstractIterator<T>(){

            @Override
            protected T computeNext() {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!predicate.apply(e)) continue;
                    return e;
                }
                return this.endOfData();
            }
        };
    }

    @GwtIncompatible(value="Class.isInstance")
    public static <T> UnmodifiableIterator<T> filter(Iterator<?> iterator, Class<T> clazz) {
        return Iterators.filter(iterator, Predicates.instanceOf(clazz));
    }

    public static <T> boolean any(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!predicate.apply(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean all(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (predicate.apply(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> T find(Iterator<T> iterator, Predicate<? super T> predicate) {
        return (T)Iterators.filter(iterator, predicate).next();
    }

    public static <T> T find(Iterator<T> iterator, Predicate<? super T> predicate, @Nullable T t) {
        UnmodifiableIterator<T> unmodifiableIterator = Iterators.filter(iterator, predicate);
        return (T)(unmodifiableIterator.hasNext() ? unmodifiableIterator.next() : t);
    }

    public static <T> Optional<T> tryFind(Iterator<T> iterator, Predicate<? super T> predicate) {
        UnmodifiableIterator<T> unmodifiableIterator = Iterators.filter(iterator, predicate);
        return unmodifiableIterator.hasNext() ? Optional.of(unmodifiableIterator.next()) : Optional.absent();
    }

    public static <T> int indexOf(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate, "predicate");
        int n = 0;
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (predicate.apply(t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static <F, T> Iterator<T> transform(final Iterator<F> iterator, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(function);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                Object e = iterator.next();
                return function.apply(e);
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T> T get(Iterator<T> iterator, int n) {
        Iterators.checkNonnegative(n);
        int n2 = 0;
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (n2++ != n) continue;
            return t;
        }
        throw new IndexOutOfBoundsException("position (" + n + ") must be less than the number of elements that remained (" + n2 + ")");
    }

    private static void checkNonnegative(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("position (" + n + ") must not be negative");
        }
    }

    public static <T> T get(Iterator<T> iterator, int n, @Nullable T t) {
        Iterators.checkNonnegative(n);
        try {
            return Iterators.get(iterator, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return t;
        }
    }

    public static <T> T getNext(Iterator<T> iterator, @Nullable T t) {
        return iterator.hasNext() ? iterator.next() : t;
    }

    public static <T> T getLast(Iterator<T> iterator) {
        T t;
        do {
            t = iterator.next();
        } while (iterator.hasNext());
        return t;
    }

    public static <T> T getLast(Iterator<T> iterator, @Nullable T t) {
        return iterator.hasNext() ? Iterators.getLast(iterator) : t;
    }

    @Beta
    public static <T> int skip(Iterator<T> iterator, int n) {
        int n2;
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(n >= 0, "number to skip cannot be negative");
        for (n2 = 0; n2 < n && iterator.hasNext(); ++n2) {
            iterator.next();
        }
        return n2;
    }

    public static <T> Iterator<T> limit(final Iterator<T> iterator, final int n) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(n >= 0, "limit is negative");
        return new Iterator<T>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < n && iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T> Iterator<T> consumingIterator(final Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator);
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                Object e = iterator.next();
                iterator.remove();
                return e;
            }
        };
    }

    static void clear(Iterator<?> iterator) {
        Preconditions.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public static <T> UnmodifiableIterator<T> forArray(final T ... TArray) {
        Preconditions.checkNotNull(TArray);
        return new AbstractIndexedListIterator<T>(TArray.length){

            @Override
            protected T get(int n) {
                return TArray[n];
            }
        };
    }

    static <T> UnmodifiableIterator<T> forArray(final T[] TArray, final int n, int n2) {
        Preconditions.checkArgument(n2 >= 0);
        int n3 = n + n2;
        Preconditions.checkPositionIndexes(n, n3, TArray.length);
        return new AbstractIndexedListIterator<T>(n2){

            @Override
            protected T get(int n2) {
                return TArray[n + n2];
            }
        };
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(final @Nullable T t) {
        return new UnmodifiableIterator<T>(){
            boolean done;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return t;
            }
        };
    }

    public static <T> UnmodifiableIterator<T> forEnumeration(final Enumeration<T> enumeration) {
        Preconditions.checkNotNull(enumeration);
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T> Enumeration<T> asEnumeration(final Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator);
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
    }

    public static <T> PeekingIterator<T> peekingIterator(Iterator<? extends T> iterator) {
        if (iterator instanceof PeekingImpl) {
            PeekingImpl peekingImpl = (PeekingImpl)iterator;
            return peekingImpl;
        }
        return new PeekingImpl<T>(iterator);
    }

    @Deprecated
    public static <T> PeekingIterator<T> peekingIterator(PeekingIterator<T> peekingIterator) {
        return Preconditions.checkNotNull(peekingIterator);
    }

    @Beta
    public static <T> UnmodifiableIterator<T> mergeSorted(Iterable<? extends Iterator<? extends T>> iterable, Comparator<? super T> comparator) {
        Preconditions.checkNotNull(iterable, "iterators");
        Preconditions.checkNotNull(comparator, "comparator");
        return new MergingIterator<T>(iterable, comparator);
    }

    private static class MergingIterator<T>
    extends AbstractIterator<T> {
        final Queue<PeekingIterator<T>> queue;
        final Comparator<? super T> comparator;

        public MergingIterator(Iterable<? extends Iterator<? extends T>> iterable, Comparator<? super T> comparator) {
            this.comparator = comparator;
            Comparator comparator2 = new Comparator<PeekingIterator<T>>(){

                @Override
                public int compare(PeekingIterator<T> peekingIterator, PeekingIterator<T> peekingIterator2) {
                    return MergingIterator.this.comparator.compare(peekingIterator.peek(), peekingIterator2.peek());
                }
            };
            this.queue = new PriorityQueue<PeekingIterator<T>>(2, comparator2);
            for (Iterator<T> iterator : iterable) {
                if (!iterator.hasNext()) continue;
                this.queue.add(Iterators.peekingIterator(iterator));
            }
        }

        @Override
        protected T computeNext() {
            if (this.queue.isEmpty()) {
                return this.endOfData();
            }
            PeekingIterator<T> peekingIterator = this.queue.poll();
            T t = peekingIterator.next();
            if (peekingIterator.hasNext()) {
                this.queue.add(peekingIterator);
            }
            return t;
        }
    }

    private static class PeekingImpl<E>
    implements PeekingIterator<E> {
        private final Iterator<? extends E> iterator;
        private boolean hasPeeked;
        private E peekedElement;

        public PeekingImpl(Iterator<? extends E> iterator) {
            this.iterator = Preconditions.checkNotNull(iterator);
        }

        @Override
        public boolean hasNext() {
            return this.hasPeeked || this.iterator.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasPeeked) {
                return this.iterator.next();
            }
            E e = this.peekedElement;
            this.hasPeeked = false;
            this.peekedElement = null;
            return e;
        }

        @Override
        public void remove() {
            Preconditions.checkState(!this.hasPeeked, "Can't remove after you've peeked at next");
            this.iterator.remove();
        }

        @Override
        public E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.iterator.next();
                this.hasPeeked = true;
            }
            return this.peekedElement;
        }
    }
}

